/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.actions.locationapi.combined;

import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.AsyncFunction;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.inject.Inject;
import com.scythebill.birdlist.model.sighting.LatLongCoordinates;
import com.scythebill.birdlist.model.sighting.LocationSet;
import com.scythebill.birdlist.ui.actions.locationapi.GeocoderResults;
import com.scythebill.birdlist.ui.actions.locationapi.LocationApiPreferences;
import com.scythebill.birdlist.ui.actions.locationapi.ReverseGeocoder;
import com.scythebill.birdlist.ui.actions.locationapi.combined.CombinedGeocoder;
import com.scythebill.birdlist.ui.actions.locationapi.ebird.EBirdGeocoder;
import com.scythebill.birdlist.ui.actions.locationapi.google.GoogleGeocoder;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CombinedReverseGeocoder
implements ReverseGeocoder {
    private static final Logger logger = Logger.getLogger(CombinedGeocoder.class.getName());
    private final GoogleGeocoder googleGeocoder;
    private final EBirdGeocoder ebirdGeocoder;
    private final LocationApiPreferences locationApiPreferences;

    @Inject
    CombinedReverseGeocoder(GoogleGeocoder googleGeocoder, EBirdGeocoder ebirdGeocoder, LocationApiPreferences locationApiPreferences) {
        this.googleGeocoder = googleGeocoder;
        this.ebirdGeocoder = ebirdGeocoder;
        this.locationApiPreferences = locationApiPreferences;
    }

    @Override
    public ListenableFuture<ImmutableList<GeocoderResults>> reverseGeocode(LocationSet locationSet, final LatLongCoordinates latLong) {
        ListenableFuture googleResults = this.locationApiPreferences.enableGoogleApis ? this.googleGeocoder.reverseGeocode(locationSet, latLong) : Futures.immediateFuture(ImmutableList.of());
        ListenableFuture ebirdResults = this.locationApiPreferences.enableEBirdApis ? this.ebirdGeocoder.reverseGeocode(locationSet, latLong) : Futures.immediateFuture(ImmutableList.of());
        final ImmutableList allResultsAsList = ImmutableList.of(googleResults, ebirdResults);
        Futures.addCallback(ebirdResults, new FutureCallback<ImmutableList<GeocoderResults>>(){

            @Override
            public void onFailure(Throwable t) {
                logger.log(Level.WARNING, "eBird reverse geocoding failed", t);
            }

            @Override
            public void onSuccess(ImmutableList<GeocoderResults> results) {
            }
        }, MoreExecutors.directExecutor());
        Futures.addCallback(googleResults, new FutureCallback<ImmutableList<GeocoderResults>>(){

            @Override
            public void onFailure(Throwable t) {
                logger.log(Level.WARNING, "Google reverse geocoding failed", t);
            }

            @Override
            public void onSuccess(ImmutableList<GeocoderResults> results) {
            }
        }, MoreExecutors.directExecutor());
        final Ordering<GeocoderResults> ordering = new Ordering<GeocoderResults>(){

            @Override
            public int compare(GeocoderResults left, GeocoderResults right) {
                double rightDistance;
                double leftDistance = latLong.kmDistance(left.coordinates());
                if (leftDistance == (rightDistance = latLong.kmDistance(right.coordinates()))) {
                    return 0;
                }
                if (leftDistance < rightDistance) {
                    return -1;
                }
                return 1;
            }
        };
        ListenableFuture successfulResults = Futures.successfulAsList(allResultsAsList);
        return Futures.transformAsync(successfulResults, new AsyncFunction<List<ImmutableList<GeocoderResults>>, ImmutableList<GeocoderResults>>(){

            @Override
            public ListenableFuture<ImmutableList<GeocoderResults>> apply(List<ImmutableList<GeocoderResults>> allResults) {
                if (Iterables.all(allResults, Predicates.isNull())) {
                    try {
                        ((ListenableFuture)allResultsAsList.get(0)).get();
                    }
                    catch (Throwable t) {
                        return Futures.immediateFailedFuture(t);
                    }
                }
                ImmutableSortedSet<GeocoderResults> sortedBuilder = ImmutableSortedSet.copyOf(ordering, Iterables.concat(Iterables.filter(allResults, Predicates.notNull())));
                HashSet<String> names = Sets.newHashSet();
                ImmutableList.Builder builder = ImmutableList.builder();
                for (GeocoderResults result : sortedBuilder) {
                    if (!names.add(result.name())) continue;
                    builder.add(result);
                }
                return Futures.immediateFuture(builder.build());
            }
        }, MoreExecutors.directExecutor());
    }
}

