/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.actions.locationapi.combined;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.SettableFuture;
import com.google.inject.Inject;
import com.scythebill.birdlist.model.sighting.LatLongCoordinates;
import com.scythebill.birdlist.model.sighting.Location;
import com.scythebill.birdlist.model.sighting.LocationSet;
import com.scythebill.birdlist.ui.actions.locationapi.GeocoderResults;
import com.scythebill.birdlist.ui.actions.locationapi.LocationApiPreferences;
import com.scythebill.birdlist.ui.actions.locationapi.ebird.EBirdGeocoder;
import com.scythebill.birdlist.ui.actions.locationapi.google.GoogleGeocoder;
import java.util.Collection;
import java.util.HashSet;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CombinedGeocoder {
    private static final Logger logger = Logger.getLogger(CombinedGeocoder.class.getName());
    private final GoogleGeocoder googleGeocoder;
    private final EBirdGeocoder eBirdGeocoder;
    private final LocationApiPreferences locationApiPreferences;

    @Inject
    public CombinedGeocoder(GoogleGeocoder googleGeocoder, EBirdGeocoder eBirdGeocoder, LocationApiPreferences locationApiPreferences) {
        this.googleGeocoder = googleGeocoder;
        this.eBirdGeocoder = eBirdGeocoder;
        this.locationApiPreferences = locationApiPreferences;
    }

    public ListenableFuture<ImmutableList<GeocoderResults>> geocode(LocationSet locationSet, Location location, Collection<LatLongCoordinates> geocodeResultsToIgnore) {
        ListenableFuture ebirdResults;
        Preconditions.checkNotNull(location);
        ImmutableSet<LatLongCoordinates> coordsToIgnore = ImmutableSet.copyOf(geocodeResultsToIgnore);
        final Predicate acceptableResultPredicate = results -> !coordsToIgnore.contains(results.coordinates());
        ListenableFuture googleResults = this.locationApiPreferences.enableGoogleApis ? this.googleGeocoder.geocode(locationSet, location) : Futures.immediateFuture(ImmutableList.of());
        final ListenableFuture primaryResults = ebirdResults = this.locationApiPreferences.enableEBirdApis ? this.eBirdGeocoder.geocode(locationSet, location) : Futures.immediateFuture(ImmutableList.of());
        final ListenableFuture secondaryResults = googleResults;
        final String primaryName = "eBird";
        final String secondaryName = "Google";
        final SettableFuture<ImmutableList<GeocoderResults>> finalResults = SettableFuture.create();
        Futures.allAsList(ImmutableList.of(primaryResults, secondaryResults)).addListener(new Runnable(){

            @Override
            public void run() {
                Exception error = null;
                ImmutableList.Builder results = ImmutableList.builder();
                HashSet<String> currentNames = Sets.newHashSet();
                try {
                    FluentIterable filtered = FluentIterable.from((Iterable)primaryResults.get()).filter(acceptableResultPredicate);
                    results.addAll((Iterable)filtered);
                    for (GeocoderResults result : filtered) {
                        currentNames.add(result.name());
                    }
                }
                catch (Exception e) {
                    error = e;
                    logger.log(Level.WARNING, primaryName + " geocoding failed", e);
                }
                Predicate skippingPrimaryNames = Predicates.and(acceptableResultPredicate, r -> !currentNames.contains(r.name()));
                try {
                    results.addAll((Iterable)FluentIterable.from((Iterable)secondaryResults.get()).filter(skippingPrimaryNames));
                }
                catch (Exception e) {
                    error = e;
                    logger.log(Level.WARNING, secondaryName + " geocoding failed", e);
                }
                ImmutableCollection built = results.build();
                if (built.isEmpty() && error != null) {
                    finalResults.setException(error);
                } else {
                    finalResults.set(built);
                }
            }
        }, MoreExecutors.directExecutor());
        return finalResults;
    }
}

