/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.actions.locationapi;

import com.scythebill.birdlist.model.annotations.Preference;
import com.scythebill.birdlist.model.sighting.LatLongCoordinates;

public class LocationApiPreferences {
    @Preference
    public boolean enableEBirdApis = true;
    @Preference
    public boolean enableGoogleApis = true;
    @Preference
    public MapProvider mapProvider = MapProvider.GOOGLE;

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum MapProvider {
        GOOGLE{

            @Override
            public String mapUrl(LatLongCoordinates latLong) {
                return String.format("https://www.google.com/maps/search/?api=1&query=%s%%2C%s", latLong.latitudeAsCanonicalString(), latLong.longitudeAsCanonicalString());
            }
        }
        ,
        OPEN_STREET_MAP{

            @Override
            public String mapUrl(LatLongCoordinates latLong) {
                return String.format("https://www.openstreetmap.org/#map=17/%s/%s", latLong.latitudeAsCanonicalString(), latLong.longitudeAsCanonicalString());
            }
        }
        ,
        NONE{

            @Override
            public String mapUrl(LatLongCoordinates latLong) {
                return null;
            }
        };


        public abstract String mapUrl(LatLongCoordinates var1);
    }
}

