/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.actions.locationapi;

import com.google.common.base.MoreObjects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.scythebill.birdlist.model.sighting.LatLongCoordinates;
import com.scythebill.birdlist.model.sighting.Location;

public final class GeocoderResults {
    private final String name;
    private final LatLongCoordinates coordinates;
    private final Location preferredParent;
    private final Source source;

    public GeocoderResults(Source source, String name, LatLongCoordinates coordinates, Location preferredParent) {
        this.source = source;
        Preconditions.checkArgument(!Strings.isNullOrEmpty(name));
        this.name = name;
        this.coordinates = coordinates;
        this.preferredParent = preferredParent;
    }

    public String name() {
        return this.name;
    }

    public String nameWithSource() {
        return String.format("%s - %s", new Object[]{this.name, this.source});
    }

    public LatLongCoordinates coordinates() {
        return this.coordinates;
    }

    public Optional<Location> preferredParent() {
        return Optional.fromNullable(this.preferredParent);
    }

    public Source source() {
        return this.source;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("source", (Object)this.source).add("name", this.name).add("coordinates", this.coordinates).add("preferredParent", this.preferredParent).toString();
    }

    public static enum Source {
        GOOGLE("Google"),
        EBIRD("eBird");

        private final String name;

        private Source(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

