/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.actions;

import com.google.inject.Inject;
import com.scythebill.birdlist.ui.actions.ActionBroker;
import com.scythebill.birdlist.ui.actions.Attachable;
import com.scythebill.birdlist.ui.actions.ForwardingAction;
import com.scythebill.birdlist.ui.util.FocusTracker;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.TransferHandler;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.JTextComponent;

public class TextFieldActions {
    private static final Logger logger = Logger.getLogger(TextFieldActions.class.getName());
    private final ActionBroker broker;

    @Inject
    public TextFieldActions(ActionBroker broker) {
        this.broker = broker;
    }

    public void install(JComponent component) {
        new FocusTracker(component){
            private Action cut;
            private Action copy;
            private Action paste;

            @Override
            protected boolean isTargetOfTracker(Component potentialTarget) {
                return potentialTarget instanceof JTextComponent && super.isTargetOfTracker(potentialTarget);
            }

            @Override
            protected boolean includeTextComponents() {
                return true;
            }

            @Override
            protected void focusLost(Component child) {
                if (this.cut != null) {
                    TextFieldActions.this.broker.unpublishAction("cut", this.cut);
                    this.cut = null;
                }
                if (this.copy != null) {
                    TextFieldActions.this.broker.unpublishAction("copy", this.copy);
                    this.copy = null;
                }
                if (this.paste != null) {
                    TextFieldActions.this.broker.unpublishAction("paste", this.paste);
                    this.paste = null;
                }
            }

            @Override
            protected void focusGained(Component child) {
                JTextComponent text = (JTextComponent)child;
                if (text.getTransferHandler() != null) {
                    this.cut = new TextFieldCutCopy(text, TransferHandler.getCutAction());
                    TextFieldActions.this.broker.publishAction("cut", this.cut);
                    this.copy = new TextFieldCutCopy(text, TransferHandler.getCopyAction());
                    TextFieldActions.this.broker.publishAction("copy", this.copy);
                    try {
                        DataFlavor[] availableDataFlavors = Toolkit.getDefaultToolkit().getSystemClipboard().getAvailableDataFlavors();
                        DataFlavor textFlavor = DataFlavor.selectBestTextFlavor(availableDataFlavors);
                        if (textFlavor != null) {
                            this.paste = new ForwardingAction(text, TransferHandler.getPasteAction());
                            TextFieldActions.this.broker.publishAction("paste", this.paste);
                        }
                    }
                    catch (IllegalStateException e) {
                        logger.log(Level.WARNING, "Could not open clipboard, paste will not be enabled", e);
                    }
                    catch (IllegalArgumentException e) {
                        logger.log(Level.WARNING, "Could not open clipboard, paste will not be enabled", e);
                    }
                }
            }
        };
    }

    private static class TextFieldCutCopy
    extends ForwardingAction
    implements Attachable,
    CaretListener {
        private final JTextComponent component;

        public TextFieldCutCopy(JTextComponent component, Action delegate) {
            super(component, delegate);
            this.component = component;
        }

        @Override
        public void attach() {
            this.component.addCaretListener(this);
        }

        @Override
        public void unattach() {
            this.component.removeCaretListener(this);
        }

        @Override
        public void caretUpdate(CaretEvent event) {
            this.updateEnabled();
        }

        private void updateEnabled() {
            this.setEnabled(this.component.getSelectionStart() != this.component.getSelectionEnd());
        }
    }
}

