/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.actions;

import com.google.inject.Inject;
import com.scythebill.birdlist.ui.app.ReportSetSaver;
import com.scythebill.birdlist.ui.messages.Messages;
import com.scythebill.birdlist.ui.util.Alerts;
import com.scythebill.birdlist.ui.util.FileDialogs;
import java.awt.event.ActionEvent;
import java.io.IOException;
import javax.swing.AbstractAction;

public class SaveAction
extends AbstractAction {
    private final ReportSetSaver reportSetSaver;
    private final Alerts alerts;

    @Inject
    public SaveAction(ReportSetSaver reportSetSaver, Alerts alerts) {
        super(Messages.getMessage(Messages.Name.SAVE_MENU));
        this.reportSetSaver = reportSetSaver;
        this.alerts = alerts;
        this.setEnabled(reportSetSaver.getDirty().isDirty());
        reportSetSaver.getDirty().addDirtyListener(event -> this.setEnabled(Boolean.TRUE.equals(event.getNewValue())));
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        try {
            this.reportSetSaver.save();
        }
        catch (IOException e) {
            FileDialogs.showFileSaveError(this.alerts, e, this.reportSetSaver.file());
        }
    }
}

