/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.actions;

import com.google.inject.Inject;
import com.scythebill.birdlist.model.io.HtmlResponseWriter;
import com.scythebill.birdlist.model.sighting.ReportSet;
import com.scythebill.birdlist.model.taxa.Taxonomy;
import com.scythebill.birdlist.model.xml.XmlReportSetExport;
import com.scythebill.birdlist.ui.guice.Clements;
import com.scythebill.birdlist.ui.messages.Messages;
import com.scythebill.birdlist.ui.panels.FilePreferences;
import com.scythebill.birdlist.ui.util.Alerts;
import com.scythebill.birdlist.ui.util.FileDialogs;
import java.awt.event.ActionEvent;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import javax.swing.AbstractAction;

public class SaveACopyAsAction
extends AbstractAction {
    private final ReportSet reportSet;
    private final FileDialogs fileDialogs;
    private final File originalFile;
    private final Taxonomy clements;
    private final Alerts alerts;

    @Inject
    public SaveACopyAsAction(ReportSet reportSet, File file, FileDialogs fileDialogs, Alerts alerts, @Clements Taxonomy clements) {
        super(Messages.getMessage(Messages.Name.SAVE_A_COPY_AS));
        this.reportSet = reportSet;
        this.originalFile = file;
        this.fileDialogs = fileDialogs;
        this.alerts = alerts;
        this.clements = clements;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        FileOutputStream fileOutputStream;
        String originalFileName = this.originalFile.getName();
        int lastPeriod = originalFileName.lastIndexOf(46);
        String fileName = lastPeriod < 0 ? originalFileName + "-copy.bsxm" : originalFileName.substring(0, lastPeriod) + "-copy.bsxm";
        File saveFile = this.fileDialogs.saveFile(null, Messages.getFormattedMessage(Messages.Name.COPY_OF_FORMAT, this.originalFile.getName()), fileName, null, FilePreferences.FileType.SIGHTINGS);
        if (saveFile == null) {
            return;
        }
        if (!saveFile.getName().endsWith(".bsxm") && (saveFile = new File(saveFile.getParent(), saveFile.getName() + ".bsxm")).exists()) {
            this.alerts.showError(null, Messages.Name.FILE_ALREADY_EXISTS_TITLE, Messages.Name.FILE_ALREADY_EXISTS_FORMAT, HtmlResponseWriter.htmlEscape(saveFile.getName()));
            return;
        }
        try {
            if (!saveFile.exists() && !saveFile.createNewFile()) {
                throw new IOException("Could not create new file");
            }
        }
        catch (IOException e) {
            this.alerts.showError(null, Messages.Name.COULD_NOT_SAVE_TITLE, Messages.Name.COULD_NOT_SAVE_FORMAT, HtmlResponseWriter.htmlEscape(saveFile.getParentFile().getName()));
            return;
        }
        try {
            fileOutputStream = new FileOutputStream(saveFile);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new BufferedOutputStream(fileOutputStream), StandardCharsets.UTF_8);
        try {
            new XmlReportSetExport().export(writer, "UTF-8", this.reportSet, this.clements);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to save a copy", e);
        }
        finally {
            try {
                ((Writer)writer).close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

