/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.actions;

import com.google.common.collect.ImmutableSet;
import com.google.inject.Inject;
import com.scythebill.birdlist.model.checklist.Checklist;
import com.scythebill.birdlist.model.checklist.ChecklistResolution;
import com.scythebill.birdlist.model.checklist.Checklists;
import com.scythebill.birdlist.model.sighting.ReportSet;
import com.scythebill.birdlist.model.sighting.Sighting;
import com.scythebill.birdlist.model.sighting.SightingTaxon;
import com.scythebill.birdlist.model.taxa.Taxon;
import com.scythebill.birdlist.model.taxa.Taxonomy;
import com.scythebill.birdlist.ui.events.TaxonomyStore;
import com.scythebill.birdlist.ui.fonts.FontManager;
import com.scythebill.birdlist.ui.messages.Messages;
import com.scythebill.birdlist.ui.panels.location.ChecklistResolutionResults;
import com.scythebill.birdlist.ui.util.Alerts;
import java.awt.event.ActionEvent;
import java.util.LinkedHashSet;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JLabel;

public class ReconcileAgainstChecklistsAction
extends AbstractAction {
    private final TaxonomyStore taxonomyStore;
    private final ReportSet reportSet;
    private final Alerts alerts;
    private final Checklists checklists;
    private FontManager fontManager;

    @Inject
    public ReconcileAgainstChecklistsAction(TaxonomyStore taxonomyStore, ReportSet reportSet, Checklists checklists, FontManager fontManager, Alerts alerts) {
        this.taxonomyStore = taxonomyStore;
        this.reportSet = reportSet;
        this.checklists = checklists;
        this.fontManager = fontManager;
        this.alerts = alerts;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (!this.taxonomyStore.isBirdTaxonomy()) {
            throw new IllegalStateException("Not supported except for birds.");
        }
        LinkedHashSet<SightingTaxon> taxaToResolve = new LinkedHashSet<SightingTaxon>();
        Taxonomy taxonomy = this.taxonomyStore.getTaxonomy();
        for (Sighting sighting : this.reportSet.getSightings(this.taxonomyStore.getTaxonomy())) {
            SightingTaxon.Resolved resolved = sighting.getTaxon().resolve(taxonomy);
            if (resolved.getType() != SightingTaxon.Type.SP || resolved.getLargestTaxonType() != Taxon.Type.species) continue;
            taxaToResolve.add(sighting.getTaxon());
        }
        if (taxaToResolve.isEmpty()) {
            this.alerts.showMessage(e.getSource(), Messages.Name.NO_RECONCILED_SPS_TITLE, Messages.Name.NO_RECONCILED_SPS_MESSAGE, new Object[0]);
            return;
        }
        ChecklistResolution checklistResolution = new ChecklistResolution(this.checklists, ImmutableSet.of());
        ImmutableSet<SightingTaxon> remainingTaxa = checklistResolution.attemptChecklistResolution(this.reportSet, taxaToResolve, taxonomy);
        ChecklistResolution checklistResolutionWithoutRarities = new ChecklistResolution(this.checklists, ImmutableSet.of(Checklist.Status.RARITY, Checklist.Status.RARITY_FROM_INTRODUCED));
        ImmutableSet<SightingTaxon> remainingTaxaWithoutRarities = checklistResolutionWithoutRarities.attemptChecklistResolution(this.reportSet, taxaToResolve, taxonomy);
        if ((remainingTaxa == null || checklistResolution.sightingsToAdd().isEmpty()) && (remainingTaxaWithoutRarities == null || checklistResolutionWithoutRarities.sightingsToAdd().isEmpty())) {
            this.alerts.showMessage(e.getSource(), Messages.Name.NO_RECONCILED_SPS_TITLE, Messages.Name.NO_RECONCILED_SPS_MESSAGE, new Object[0]);
            return;
        }
        if (checklistResolution.sightingsToAdd().size() == checklistResolutionWithoutRarities.sightingsToAdd().size()) {
            Messages.Name messageFormat;
            int totalSightings = checklistResolution.sightingsToAdd().size();
            int partialImprovements = checklistResolution.simplifiedButNotFullyResolved();
            int arg1 = 0;
            int arg2 = 0;
            if (partialImprovements == 0) {
                arg1 = totalSightings;
                messageFormat = totalSightings == 1 ? Messages.Name.SIGHTING_CAN_BE_RESOLVED : Messages.Name.SIGHTINGS_CAN_BE_RESOLVED;
            } else if (partialImprovements == totalSightings) {
                arg1 = totalSightings;
                messageFormat = totalSightings == 1 ? Messages.Name.SIGHTING_CAN_BE_PARTIALLY_RESOLVED : Messages.Name.SIGHTINGS_CAN_BE_PARTIALLY_RESOLVED;
            } else {
                arg1 = totalSightings - partialImprovements;
                arg2 = partialImprovements;
                messageFormat = Messages.Name.SIGHTINGS_CAN_BE_FULLY_AND_PARTIALLY_RESOLVED;
            }
            JComponent panel = ChecklistResolutionResults.asPanel(checklistResolution, taxonomy, this.fontManager);
            int okOrCancel = this.alerts.showOkCancelWithPanel(e.getSource(), this.alerts.getFormattedDialogMessage(Messages.Name.RESULTS_TITLE, messageFormat, arg1, arg2), panel);
            if (okOrCancel == 0) {
                this.reportSet.mutator().removing(checklistResolution.sightingsToRemove()).adding(checklistResolution.sightingsToAdd()).mutate();
            }
        } else if (checklistResolution.sightingsToAdd().size() == 0) {
            Messages.Name messageFormat;
            int totalSightings = checklistResolutionWithoutRarities.sightingsToAdd().size();
            int partialImprovements = checklistResolutionWithoutRarities.simplifiedButNotFullyResolved();
            int arg1 = 0;
            int arg2 = 0;
            if (partialImprovements == 0) {
                arg1 = totalSightings;
                messageFormat = totalSightings == 1 ? Messages.Name.SIGHTING_CAN_BE_RESOLVED_USING_RARITIES : Messages.Name.SIGHTINGS_CAN_BE_RESOLVED_USING_RARITIES;
            } else if (partialImprovements == totalSightings) {
                arg1 = totalSightings;
                messageFormat = totalSightings == 1 ? Messages.Name.SIGHTING_CAN_BE_PARTIALLY_RESOLVED_USING_RARITIES : Messages.Name.SIGHTINGS_CAN_BE_PARTIALLY_RESOLVED_USING_RARITIES;
            } else {
                arg1 = totalSightings - partialImprovements;
                arg2 = partialImprovements;
                messageFormat = Messages.Name.SIGHTINGS_CAN_BE_FULLY_AND_PARTIALLY_RESOLVED_USING_RARITIES;
            }
            JComponent panel = ChecklistResolutionResults.asPanel(checklistResolutionWithoutRarities, taxonomy, this.fontManager);
            int okOrCancel = this.alerts.showOkCancelWithPanel(e.getSource(), this.alerts.getFormattedDialogMessage(Messages.Name.RESULTS_TITLE, messageFormat, arg1, arg2), panel);
            if (okOrCancel == 0) {
                this.reportSet.mutator().removing(checklistResolutionWithoutRarities.sightingsToRemove()).adding(checklistResolutionWithoutRarities.sightingsToAdd()).mutate();
            }
        } else {
            Messages.Name messageFormat;
            int totalSightings = checklistResolution.sightingsToAdd().size();
            int partialImprovements = checklistResolution.simplifiedButNotFullyResolved();
            int arg1 = 0;
            int arg2 = 0;
            if (partialImprovements == 0) {
                arg1 = totalSightings;
                messageFormat = totalSightings == 1 ? Messages.Name.SIGHTING_CAN_BE_RESOLVED : Messages.Name.SIGHTINGS_CAN_BE_RESOLVED;
            } else if (partialImprovements == totalSightings) {
                arg1 = totalSightings;
                messageFormat = totalSightings == 1 ? Messages.Name.SIGHTING_CAN_BE_PARTIALLY_RESOLVED : Messages.Name.SIGHTINGS_CAN_BE_PARTIALLY_RESOLVED;
            } else {
                arg1 = totalSightings - partialImprovements;
                arg2 = partialImprovements;
                messageFormat = Messages.Name.SIGHTINGS_CAN_BE_FULLY_AND_PARTIALLY_RESOLVED;
            }
            String formattedMessage = this.alerts.getFormattedDialogMessage(Messages.Name.RESULTS_TITLE, messageFormat, arg1, arg2);
            int totalSightingsWithoutRarities = checklistResolutionWithoutRarities.sightingsToAdd().size();
            int partialImprovementsWithoutRarities = checklistResolutionWithoutRarities.simplifiedButNotFullyResolved();
            String messageWithoutRarities = partialImprovementsWithoutRarities == 0 ? (totalSightingsWithoutRarities == 1 ? Messages.getMessage(Messages.Name.SIGHTING_CAN_BE_RESOLVED_USING_RARITIES) : Messages.getFormattedMessage(Messages.Name.SIGHTINGS_CAN_BE_RESOLVED_USING_RARITIES, totalSightingsWithoutRarities)) : (partialImprovementsWithoutRarities == totalSightingsWithoutRarities ? (totalSightingsWithoutRarities == 1 ? Messages.getMessage(Messages.Name.SIGHTING_CAN_BE_PARTIALLY_RESOLVED_USING_RARITIES) : Messages.getFormattedMessage(Messages.Name.SIGHTINGS_CAN_BE_PARTIALLY_RESOLVED_USING_RARITIES, totalSightingsWithoutRarities)) : Messages.getFormattedMessage(Messages.Name.SIGHTINGS_CAN_BE_FULLY_AND_PARTIALLY_RESOLVED_USING_RARITIES, totalSightingsWithoutRarities - partialImprovementsWithoutRarities, partialImprovementsWithoutRarities));
            Box panel = Box.createVerticalBox();
            panel.add(ChecklistResolutionResults.asPanel(checklistResolution, taxonomy, this.fontManager));
            panel.add(Box.createVerticalStrut(20));
            panel.add(new JLabel("<html>" + messageWithoutRarities));
            panel.add(Box.createVerticalStrut(5));
            panel.add(ChecklistResolutionResults.asPanel(checklistResolutionWithoutRarities, taxonomy, this.fontManager));
            int option = this.alerts.showOptionsWithPanel(e.getSource(), formattedMessage, panel, Messages.getMessage(Messages.Name.CANCEL_BUTTON), Messages.getMessage(Messages.Name.USE_RARITIES_BUTTON), Messages.getMessage(Messages.Name.DONT_USE_RARITIES_BUTTON));
            if (option == 1) {
                this.reportSet.mutator().removing(checklistResolutionWithoutRarities.sightingsToRemove()).adding(checklistResolutionWithoutRarities.sightingsToAdd()).mutate();
            } else if (option == 2) {
                this.reportSet.mutator().removing(checklistResolution.sightingsToRemove()).adding(checklistResolution.sightingsToAdd()).mutate();
            }
        }
    }
}

