/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.actions;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.scythebill.birdlist.ui.app.FrameRegistry;
import com.scythebill.birdlist.ui.prefs.PreferencesManager;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;

@Singleton
public class QuitAction
extends AbstractAction {
    private final PreferencesManager preferencesManager;
    private final FrameRegistry frameRegistry;

    @Inject
    public QuitAction(PreferencesManager preferencesManager, FrameRegistry frameRegistry) {
        this.preferencesManager = preferencesManager;
        this.frameRegistry = frameRegistry;
    }

    public boolean tryQuit() {
        block3: {
            try {
                this.preferencesManager.save();
                if (!this.frameRegistry.saveBeforeQuitting()) {
                    return false;
                }
            }
            catch (RuntimeException e) {
                Thread.UncaughtExceptionHandler handler = Thread.currentThread().getUncaughtExceptionHandler();
                if (handler == null) break block3;
                handler.uncaughtException(Thread.currentThread(), e);
            }
        }
        return true;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        if (this.tryQuit()) {
            System.exit(0);
        }
    }
}

