/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.actions;

import com.google.common.collect.Lists;
import com.google.common.io.Resources;
import com.scythebill.birdlist.ui.messages.Messages;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class OpenSourceLicensesAction
extends AbstractAction {
    @Override
    public void actionPerformed(ActionEvent e) {
        ArrayList<String> names = Lists.newArrayList();
        final ArrayList<String> licenseText = Lists.newArrayList();
        for (License license : License.values()) {
            String text = license.read();
            if (text == null) continue;
            names.add(license.projectName());
            licenseText.add(text);
        }
        final JComboBox<String> licenses = new JComboBox<String>(names.toArray(new String[0]));
        final JTextArea textArea = new JTextArea();
        textArea.setText((String)licenseText.get(0));
        textArea.setColumns(60);
        textArea.setRows(20);
        textArea.setWrapStyleWord(true);
        textArea.setLineWrap(true);
        textArea.setEditable(false);
        textArea.select(0, 0);
        JScrollPane scrollPane = new JScrollPane(textArea, 20, 30);
        licenses.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                textArea.setText((String)licenseText.get(licenses.getSelectedIndex()));
                textArea.select(0, 0);
            }
        });
        String message = Messages.getMessage(Messages.Name.SCYTHEBILL_COULD_NOT_BE_BUILT);
        JOptionPane.showMessageDialog(null, new Object[]{message, licenses, "", scrollPane}, "", -1);
    }

    static enum License {
        GUICE("Google Guice", "LICENSE.guice"),
        GUAVA("Google Guava", "LICENSE.guava"),
        JODA_TIME("Joda Time", "LICENSE.joda-time"),
        OPEN_CSV("opencsv", "LICENSE.opencsv"),
        COMMONS_LANG("Apache Commons Lang", "LICENSE.apache-commons-lang"),
        POI("Apache POI", "LICENSE.apache-poi"),
        HTTP_COMPONENTS("Apache HTTP Components", "LICENSE.apache-http-components"),
        GSON("Google Gson", "LICENSE.gson"),
        GEOTOOLS("Geotools", "LICENSE.geotools"),
        JACKCESS("Jackcess", "LICENSE.jackcess"),
        FLATLAF("FlatLaf", "LICENSE.flatlaf"),
        JXMAPVIEWER2("JXMapViewer2", "LICENSE.jxmapviewer2"),
        METADATA_EXTRACTOR("Metadata Extractor", "LICENSE.metadata-extractor");

        private final String name;
        private final String resource;

        private License(String name, String resource) {
            this.name = name;
            this.resource = resource;
        }

        public String projectName() {
            return this.name;
        }

        public String read() {
            try {
                URL url = Resources.getResource("licenses/" + this.resource);
                return Resources.toString(url, StandardCharsets.UTF_8);
            }
            catch (IllegalArgumentException e) {
                return null;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

