/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.actions;

import com.google.inject.Inject;
import com.scythebill.birdlist.ui.app.FrameRegistry;
import com.scythebill.birdlist.ui.messages.Messages;
import com.scythebill.birdlist.ui.panels.FilePreferences;
import com.scythebill.birdlist.ui.util.FileDialogs;
import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.AbstractAction;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;

public final class OpenAction
extends AbstractAction {
    private final FrameRegistry frameRegistry;
    private final FileDialogs fileDialogs;
    private final FileFilter fileFilter = new FileNameExtensionFilter(Messages.getMessage(Messages.Name.SCYTHEBILL_LISTFILES), ".bsxm".substring(1));

    @Inject
    public OpenAction(FrameRegistry frameRegistry, FileDialogs fileDialogs) {
        this.frameRegistry = frameRegistry;
        this.fileDialogs = fileDialogs;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        File openFile = this.fileDialogs.openFile(null, Messages.getMessage(Messages.Name.OPEN_LIST_TITLE), this.fileFilter, FilePreferences.FileType.SIGHTINGS);
        if (openFile != null) {
            this.frameRegistry.startLoadingReportSet(openFile.getAbsolutePath(), null);
        }
    }
}

