/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.actions;

import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.inject.Inject;
import com.scythebill.birdlist.model.io.HtmlResponseWriter;
import com.scythebill.birdlist.model.sighting.ReportSet;
import com.scythebill.birdlist.model.sighting.ReportSets;
import com.scythebill.birdlist.model.taxa.Taxonomy;
import com.scythebill.birdlist.model.xml.XmlReportSetExport;
import com.scythebill.birdlist.ui.app.FrameRegistry;
import com.scythebill.birdlist.ui.guice.Clements;
import com.scythebill.birdlist.ui.messages.Messages;
import com.scythebill.birdlist.ui.panels.FilePreferences;
import com.scythebill.birdlist.ui.util.Alerts;
import com.scythebill.birdlist.ui.util.FileDialogs;
import java.awt.event.ActionEvent;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;

public final class NewReportSetAction
extends AbstractAction {
    private static final Logger logger = Logger.getLogger(NewReportSetAction.class.getName());
    private final FrameRegistry frameRegistry;
    private final Supplier<Taxonomy> taxonomySupplier;
    private final FileDialogs fileDialogs;
    private final Alerts alerts;

    @Inject
    public NewReportSetAction(FrameRegistry frameRegistry, FileDialogs fileDialogs, @Clements Supplier<Taxonomy> taxonomySupplier, Alerts alerts) {
        this.frameRegistry = frameRegistry;
        this.fileDialogs = fileDialogs;
        this.taxonomySupplier = taxonomySupplier;
        this.alerts = alerts;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        ReportSet newReportSet = ReportSets.newReportSet(this.taxonomySupplier.get());
        this.saveAndOpenNewReportSet(newReportSet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean saveAndOpenNewReportSet(ReportSet reportSet) {
        File saveFile;
        while (true) {
            String username;
            String fileName = (username = System.getProperty("user.name")) == null ? "List.bsxm" : String.format("List-%s%s", username, ".bsxm");
            saveFile = this.fileDialogs.saveFile(null, Messages.getMessage(Messages.Name.NEW_LIST_TITLE), fileName, null, FilePreferences.FileType.SIGHTINGS);
            if (saveFile == null) {
                return false;
            }
            if (!saveFile.getName().endsWith(".bsxm") && (saveFile = new File(saveFile.getParent(), saveFile.getName() + ".bsxm")).exists()) {
                this.alerts.showError(null, Messages.Name.FILE_ALREADY_EXISTS_TITLE, Messages.Name.FILE_ALREADY_EXISTS_FORMAT, HtmlResponseWriter.htmlEscape(saveFile.getName()));
                continue;
            }
            try {
                if (!saveFile.exists() && !saveFile.createNewFile()) {
                    throw new IOException("Could not create new file");
                }
            }
            catch (IOException e) {
                this.alerts.showError(null, Messages.Name.COULD_NOT_SAVE_TITLE, Messages.Name.COULD_NOT_SAVE_FORMAT, HtmlResponseWriter.htmlEscape(saveFile.getParentFile().getName()));
                continue;
            }
            break;
        }
        try {
            FileOutputStream output = new FileOutputStream(saveFile);
            try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)output, StandardCharsets.UTF_8));){
                Taxonomy taxonomy = Preconditions.checkNotNull(this.taxonomySupplier.get(), "Taxonomy should be loaded before this is available");
                XmlReportSetExport rse = new XmlReportSetExport();
                rse.export(writer, StandardCharsets.UTF_8.name(), reportSet, taxonomy);
            }
        }
        catch (IOException ioe) {
            logger.log(Level.WARNING, "Could not create file", ioe);
            this.alerts.showError(null, Messages.Name.COULD_NOT_CREATE_TITLE, Messages.Name.ERROR_OCCURRED_TRY_AGAIN, new Object[0]);
            return false;
        }
        this.frameRegistry.displayLoadedReportSet(saveFile, reportSet);
        return true;
    }
}

