/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.actions;

import com.google.inject.Inject;
import com.scythebill.birdlist.ui.actions.ActionBroker;
import com.scythebill.birdlist.ui.actions.DownloadLatestAction;
import com.scythebill.birdlist.ui.actions.MenuConfiguration;
import com.scythebill.birdlist.ui.actions.NewReportSetAction;
import com.scythebill.birdlist.ui.actions.OpenAction;
import com.scythebill.birdlist.ui.actions.OpenSourceLicensesAction;
import com.scythebill.birdlist.ui.actions.ReportIssueAction;
import com.scythebill.birdlist.ui.actions.ShowEMailGroupAction;
import com.scythebill.birdlist.ui.actions.ShowManualAction;
import com.scythebill.birdlist.ui.fonts.DecreaseFontSizeAction;
import com.scythebill.birdlist.ui.fonts.IncreaseFontSizeAction;
import com.scythebill.birdlist.ui.messages.Messages;
import com.scythebill.birdlist.ui.panels.PrivacyPolicyFrame;
import com.scythebill.birdlist.ui.util.Alerts;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;

public class MinimalMenuConfiguration
implements MenuConfiguration {
    private final ActionBroker actionBroker;
    private final OpenAction openAction;
    private final NewReportSetAction newAction;
    private final IncreaseFontSizeAction increaseFontSizeAction;
    private final DecreaseFontSizeAction decreaseFontSizeAction;
    private final Alerts alerts;
    private final PrivacyPolicyFrame privacyPolicyFrame;

    @Inject
    public MinimalMenuConfiguration(ActionBroker actionBroker, OpenAction openAction, NewReportSetAction newAction, IncreaseFontSizeAction increaseFontSizeAction, DecreaseFontSizeAction decreaseFontSizeAction, PrivacyPolicyFrame privacyPolicyFrame, Alerts alerts) {
        this.actionBroker = actionBroker;
        this.openAction = openAction;
        this.newAction = newAction;
        this.increaseFontSizeAction = increaseFontSizeAction;
        this.decreaseFontSizeAction = decreaseFontSizeAction;
        this.privacyPolicyFrame = privacyPolicyFrame;
        this.alerts = alerts;
    }

    @Override
    public JMenu getFileMenu() {
        JMenu menu = new JMenu();
        menu.setText(Messages.getMessage(Messages.Name.FILE_MENU));
        int keyModifier = Toolkit.getDefaultToolkit().getMenuShortcutKeyMaskEx();
        JMenuItem closeItem = new JMenuItem();
        closeItem.setAction(this.actionBroker.createAction("close"));
        closeItem.setText(Messages.getMessage(Messages.Name.CLOSE_MENU));
        closeItem.setAccelerator(KeyStroke.getKeyStroke(87, keyModifier));
        menu.add(closeItem);
        JMenuItem saveItem = new JMenuItem();
        saveItem.setAction(this.actionBroker.createAction("save"));
        saveItem.setText(Messages.getMessage(Messages.Name.SAVE_MENU));
        saveItem.setAccelerator(KeyStroke.getKeyStroke(83, keyModifier));
        menu.add(saveItem);
        JMenuItem saveACopyAsItem = new JMenuItem();
        saveACopyAsItem.setAction(this.actionBroker.createAction("saveACopyAs"));
        saveACopyAsItem.setText(Messages.getMessage(Messages.Name.SAVE_A_COPY_AS));
        menu.add(saveACopyAsItem);
        JMenuItem openContainingItem = new JMenuItem();
        openContainingItem.setAction(this.actionBroker.createAction("openContaining"));
        openContainingItem.setText(Messages.getMessage(Messages.Name.OPEN_CONTAINING_FOLDER));
        menu.add(openContainingItem);
        menu.addSeparator();
        JMenuItem importItem = new JMenuItem();
        importItem.setAction(this.actionBroker.createAction("import"));
        importItem.setAccelerator(KeyStroke.getKeyStroke(73, keyModifier));
        importItem.setText(Messages.getMessage(Messages.Name.IMPORT_SIGHTINGS_MENU));
        menu.add(importItem);
        JMenuItem exportItem = new JMenuItem();
        exportItem.setAction(this.actionBroker.createAction("export"));
        exportItem.setAccelerator(KeyStroke.getKeyStroke(69, keyModifier));
        exportItem.setText(Messages.getMessage(Messages.Name.EXPORT_MENU));
        menu.add(exportItem);
        JMenuItem printItem = new JMenuItem();
        printItem.setAction(this.actionBroker.createAction("print"));
        printItem.setText(Messages.getMessage(Messages.Name.PRINT_MENU));
        printItem.setAccelerator(KeyStroke.getKeyStroke(80, keyModifier));
        menu.add(printItem);
        JMenuItem manageTaxonomiesItem = new JMenuItem();
        manageTaxonomiesItem.setAction(this.actionBroker.createAction("manageTaxonomies"));
        manageTaxonomiesItem.setText(Messages.getMessage(Messages.Name.MANAGE_TAXONOMIES_MENU));
        menu.add(manageTaxonomiesItem);
        menu.addSeparator();
        JMenuItem importChecklistsItem = new JMenuItem();
        importChecklistsItem.setAction(this.actionBroker.createAction("importChecklists"));
        importChecklistsItem.setText(Messages.getMessage(Messages.Name.IMPORT_CHECKLISTS_MENU));
        menu.add(importChecklistsItem);
        JMenuItem checklistErrorsItem = new JMenuItem();
        checklistErrorsItem.setAction(this.actionBroker.createAction("identifyChecklistErrors"));
        checklistErrorsItem.setText(Messages.getMessage(Messages.Name.VERIFY_AGAINST_CHECKLISTS));
        menu.add(checklistErrorsItem);
        JMenuItem checklistRaritiesItem = new JMenuItem();
        checklistRaritiesItem.setAction(this.actionBroker.createAction("identifyChecklistRarities"));
        checklistRaritiesItem.setText(Messages.getMessage(Messages.Name.FIND_CHECKLIST_RARITIES));
        menu.add(checklistRaritiesItem);
        JMenuItem reconcileAgainstChecklistsItem = new JMenuItem();
        reconcileAgainstChecklistsItem.setAction(this.actionBroker.createAction("recocileAgainstChecklists"));
        reconcileAgainstChecklistsItem.setText(Messages.getMessage(Messages.Name.RECONCILE_AGAINST_CHECKLISTS));
        menu.add(reconcileAgainstChecklistsItem);
        menu.addSeparator();
        JMenuItem newItem = new JMenuItem();
        newItem.setAction(this.newAction);
        newItem.setText(Messages.getMessage(Messages.Name.NEW_SIGHTINGS_FILE_MENU));
        menu.add(newItem);
        JMenuItem openItem = new JMenuItem();
        openItem.setAction(this.openAction);
        openItem.setText(Messages.getMessage(Messages.Name.OPEN_SIGHTINGS_FILE_MENU));
        menu.add(openItem);
        return menu;
    }

    @Override
    public JMenu getHelpMenu() {
        JMenu menu = new JMenu();
        menu.setText(Messages.getMessage(Messages.Name.HELP_MENU));
        JMenuItem showManualItem = new JMenuItem();
        showManualItem.setAction(new ShowManualAction(this.alerts));
        showManualItem.setText(Messages.getMessage(Messages.Name.SCYTHEBILL_MANUAL));
        menu.add(showManualItem);
        JMenuItem emailGroup = new JMenuItem();
        emailGroup.setAction(new ShowEMailGroupAction(this.alerts));
        emailGroup.setText(Messages.getMessage(Messages.Name.SCYTHEBILL_EMAIL_GROUP));
        menu.add(emailGroup);
        JMenuItem downloadLatest = new JMenuItem();
        downloadLatest.setAction(new DownloadLatestAction(this.alerts));
        downloadLatest.setText(Messages.getMessage(Messages.Name.DOWNLOAD_LATEST));
        menu.add(downloadLatest);
        JMenuItem reportIssueItem = new JMenuItem();
        reportIssueItem.setAction(new ReportIssueAction(this.alerts));
        reportIssueItem.setText(Messages.getMessage(Messages.Name.REPORT_ISSUE));
        menu.add(reportIssueItem);
        JMenuItem openSourceItem = new JMenuItem();
        openSourceItem.setAction(new OpenSourceLicensesAction());
        openSourceItem.setText(Messages.getMessage(Messages.Name.OPEN_SOURCE_LICENSES));
        menu.add(openSourceItem);
        JMenuItem privacyPolicyItem = new JMenuItem();
        privacyPolicyItem.setAction(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MinimalMenuConfiguration.this.privacyPolicyFrame.show();
            }
        });
        privacyPolicyItem.setText(Messages.getMessage(Messages.Name.PRIVACY_POLICY_MENU));
        menu.add(privacyPolicyItem);
        return menu;
    }

    @Override
    public JMenu getViewMenu() {
        JMenu menu = new JMenu();
        menu.setText(Messages.getMessage(Messages.Name.VIEW_MENU));
        int keyModifier = Toolkit.getDefaultToolkit().getMenuShortcutKeyMaskEx();
        JMenuItem increaseFontSizeItem = new JMenuItem();
        increaseFontSizeItem.setAction(this.increaseFontSizeAction);
        increaseFontSizeItem.setAccelerator(KeyStroke.getKeyStroke(61, keyModifier));
        menu.add(increaseFontSizeItem);
        JMenuItem decreaseFontSizeItem = new JMenuItem();
        decreaseFontSizeItem.setAction(this.decreaseFontSizeAction);
        decreaseFontSizeItem.setAccelerator(KeyStroke.getKeyStroke(45, keyModifier));
        menu.add(decreaseFontSizeItem);
        return menu;
    }
}

