/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.actions;

import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.opencsv.exceptions.CsvValidationException;
import com.scythebill.birdlist.model.checklist.Checklists;
import com.scythebill.birdlist.model.checklist.ClementsChecklistReader;
import com.scythebill.birdlist.model.io.HtmlResponseWriter;
import com.scythebill.birdlist.model.sighting.PredefinedLocations;
import com.scythebill.birdlist.model.sighting.ReportSet;
import com.scythebill.birdlist.model.taxa.Taxonomy;
import com.scythebill.birdlist.model.taxa.TaxonomyMappings;
import com.scythebill.birdlist.ui.guice.Clements;
import com.scythebill.birdlist.ui.messages.Messages;
import com.scythebill.birdlist.ui.panels.FilePreferences;
import com.scythebill.birdlist.ui.util.Alerts;
import com.scythebill.birdlist.ui.util.FileDialogs;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.filechooser.FileFilter;

public class ImportChecklistsAction
extends AbstractAction {
    private final ReportSet reportSet;
    private final PredefinedLocations predefinedLocations;
    private final Alerts alerts;
    private final FileDialogs fileDialogs;
    private final Taxonomy taxonomy;
    private final TaxonomyMappings taxonomyMappings;

    @Inject
    ImportChecklistsAction(@Clements Taxonomy taxonomy, ReportSet reportSet, PredefinedLocations predefinedLocations, Checklists checklists, Alerts alerts, FileDialogs fileDialogs, TaxonomyMappings taxonomyMappings) {
        this.taxonomy = taxonomy;
        this.reportSet = reportSet;
        this.predefinedLocations = predefinedLocations;
        this.alerts = alerts;
        this.fileDialogs = fileDialogs;
        this.taxonomyMappings = taxonomyMappings;
    }

    @Override
    public void actionPerformed(ActionEvent action) {
        File[] files = this.fileDialogs.openFiles(null, Messages.getMessage(Messages.Name.IMPORT_CHECKLISTS_TITLE), new FileFilter(){

            @Override
            public String getDescription() {
                return Messages.getMessage(Messages.Name.SCYTHEBILL_CHECKLISTS);
            }

            @Override
            public boolean accept(File file) {
                return file.getName().endsWith(".csv");
            }
        }, FilePreferences.FileType.OTHER);
        this.importFiles(files);
    }

    public boolean isClementsChecklist(File file) {
        return ClementsChecklistReader.isClementsChecklist(file);
    }

    public void importFiles(File[] files) {
        ClementsChecklistReader reader = new ClementsChecklistReader(this.taxonomy, this.predefinedLocations, this.taxonomyMappings);
        ArrayList<ClementsChecklistReader.ChecklistAndLocation> list = Lists.newArrayList();
        for (File file : files) {
            try {
                list.add(reader.read(this.reportSet, file));
            }
            catch (CsvValidationException | IOException | IllegalArgumentException e) {
                this.alerts.showError(null, Messages.Name.COULDNT_READ_CHECKLIST, Messages.Name.NOT_VALID_CHECKLIST_FORMAT, HtmlResponseWriter.htmlEscape(file.getName()));
            }
            catch (ClementsChecklistReader.InvalidTaxonomyException e) {
                this.alerts.showError(null, Messages.Name.COULDNT_READ_CHECKLIST, Messages.Name.CHECKLIST_TAXONOMY_OBSOLETE, HtmlResponseWriter.htmlEscape(file.getName()));
            }
        }
        int countThatAlreadyExist = 0;
        for (ClementsChecklistReader.ChecklistAndLocation checklistAndLocation : list) {
            if (this.reportSet.getChecklist(checklistAndLocation.location) == null) continue;
            ++countThatAlreadyExist;
        }
        if (countThatAlreadyExist > 0) {
            Messages.Name message = countThatAlreadyExist == list.size() ? (countThatAlreadyExist == 1 ? Messages.Name.OVERWRITE_SINGLE_CHECKLIST : Messages.Name.OVERWRITE_MULTIPLE_CHECKLISTS) : Messages.Name.OVERWRITE_SOME_CHECKLISTS;
            if (this.alerts.showOkCancel(null, Messages.Name.OVERWRITE_CHECKLISTS_TITLE, message, new Object[0]) != 0) {
                return;
            }
        }
        for (ClementsChecklistReader.ChecklistAndLocation checklistAndLocation : list) {
            this.reportSet.getLocations().ensureAdded(checklistAndLocation.location);
            this.reportSet.setChecklist(checklistAndLocation.location, checklistAndLocation.checklist);
        }
        if (!list.isEmpty()) {
            if (list.size() == 1) {
                this.alerts.showMessage(null, Messages.Name.ADDED_CHECKLIST_TITLE, Messages.Name.ADDED_CHECKLIST_FORMAT, ((ClementsChecklistReader.ChecklistAndLocation)list.get((int)0)).location.getDisplayName());
            } else {
                this.alerts.showMessage(null, Messages.Name.ADDED_CHECKLISTS_TITLE, Messages.Name.ADDED_CHECKLISTS_FORMAT, list.size());
            }
        }
    }
}

