/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.actions;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.ListMultimap;
import com.google.inject.Inject;
import com.scythebill.birdlist.model.checklist.Checklist;
import com.scythebill.birdlist.model.checklist.Checklists;
import com.scythebill.birdlist.model.checklist.ExtendedTaxonomyChecklists;
import com.scythebill.birdlist.model.io.HtmlResponseWriter;
import com.scythebill.birdlist.model.sighting.Location;
import com.scythebill.birdlist.model.sighting.Locations;
import com.scythebill.birdlist.model.sighting.ReportSet;
import com.scythebill.birdlist.model.sighting.Sighting;
import com.scythebill.birdlist.model.sighting.SightingInfo;
import com.scythebill.birdlist.model.sighting.SightingTaxon;
import com.scythebill.birdlist.model.taxa.Species;
import com.scythebill.birdlist.model.taxa.Taxon;
import com.scythebill.birdlist.model.taxa.TaxonUtils;
import com.scythebill.birdlist.model.taxa.Taxonomy;
import com.scythebill.birdlist.model.util.ResolvedComparator;
import com.scythebill.birdlist.ui.events.TaxonomyStore;
import com.scythebill.birdlist.ui.guice.CurrentVersion;
import com.scythebill.birdlist.ui.messages.Messages;
import com.scythebill.birdlist.ui.util.Alerts;
import com.scythebill.birdlist.ui.util.DesktopUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import javax.annotation.Nullable;
import javax.swing.AbstractAction;

public class IdentifySpeciesMissingFromChecklistsAction
extends AbstractAction {
    private final ReportSet reportSet;
    private final Checklists checklists;
    private final Alerts alerts;
    private final TaxonomyStore taxonomyStore;
    private final String versionInfo;
    private static final ImmutableSet<String> CODES_WITH_MULTIPLE_REGIONS = ImmutableSet.of("XX", "RU", "ID");

    @Inject
    IdentifySpeciesMissingFromChecklistsAction(TaxonomyStore taxonomyStore, ReportSet reportSet, Checklists checklists, Alerts alerts, @Nullable @CurrentVersion String versionInfo) {
        this.reportSet = reportSet;
        this.checklists = checklists;
        this.alerts = alerts;
        this.taxonomyStore = taxonomyStore;
        this.versionInfo = versionInfo;
    }

    @Override
    public void actionPerformed(ActionEvent action) {
        ExtendedTaxonomyChecklists extendedTaxonomyChecklists;
        if (!this.taxonomyStore.isBirdTaxonomy() && ((extendedTaxonomyChecklists = this.reportSet.getExtendedTaxonomyChecklist(this.taxonomyStore.getTaxonomy().getId())) == null || extendedTaxonomyChecklists.getChecklists() == null || extendedTaxonomyChecklists.getChecklists().isEmpty())) {
            throw new IllegalStateException("Only supported for taxonomies with checklists.");
        }
        LinkedHashMultimap<Object, SightingTaxon> sightingsByLocationWithChecklist = LinkedHashMultimap.create();
        for (Sighting sighting : this.reportSet.getSightings(this.taxonomyStore.getTaxonomy())) {
            if (sighting.getLocationId() == null) continue;
            if (sighting.getSightingInfo().getSightingStatus() == SightingInfo.SightingStatus.INTRODUCED_NOT_ESTABLISHED || sighting.getSightingInfo().getSightingStatus() == SightingInfo.SightingStatus.ID_UNCERTAIN || sighting.getSightingInfo().getSightingStatus() == SightingInfo.SightingStatus.DOMESTIC || sighting.getSightingInfo().getSightingStatus() == SightingInfo.SightingStatus.RECORD_NOT_ACCEPTED) continue;
            for (Object location = this.reportSet.getLocations().getLocation(sighting.getLocationId()); location != null; location = ((Location)location).getParent()) {
                if (!this.checklists.hasChecklist(this.taxonomyStore.getTaxonomy(), this.reportSet, (Location)location)) continue;
                sightingsByLocationWithChecklist.put(location, sighting.getTaxon());
            }
        }
        Taxonomy taxonomy = this.taxonomyStore.getTaxonomy();
        ArrayListMultimap<Location, SightingTaxon.Resolved> missingSightings = ArrayListMultimap.create();
        for (Location location : sightingsByLocationWithChecklist.keySet()) {
            Checklist checklist = this.checklists.getChecklist(this.reportSet, this.taxonomyStore.getTaxonomy(), location);
            if (checklist.isSynthetic()) continue;
            for (SightingTaxon taxon : sightingsByLocationWithChecklist.get((Object)location)) {
                Checklist.Status status;
                SightingTaxon.Resolved resolved = taxon.resolve(taxonomy);
                if (resolved.getSmallestTaxonType() != Taxon.Type.species) {
                    resolved = resolved.getParentOfAtLeastType(Taxon.Type.species).resolveInternal(taxonomy);
                }
                if (resolved.getType() != SightingTaxon.Type.SINGLE && resolved.getType() != SightingTaxon.Type.SINGLE_WITH_SECONDARY_SUBSPECIES || !this.statusIsReportable(status = checklist.getStatus(taxonomy, resolved.getSightingTaxon()))) continue;
                missingSightings.put(location, resolved);
            }
        }
        if (missingSightings.isEmpty()) {
            this.showNoSightingsFound(this.alerts, (Component)action.getSource());
        } else {
            try {
                File temp = File.createTempFile("ChecklistIssues", ".html");
                BufferedWriter out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(temp), StandardCharsets.UTF_8));
                HtmlResponseWriter rw = new HtmlResponseWriter(out, StandardCharsets.UTF_8.name());
                rw.startDocument();
                rw.startElement("html");
                rw.startElement("head");
                rw.startElement("meta");
                rw.writeAttribute("http-equiv", "Content-Type");
                rw.writeAttribute("content", "text/html; charset=UTF-8");
                rw.endElement("meta");
                rw.startElement("title");
                rw.writeText(Messages.getMessage(this.title()));
                rw.endElement("title");
                rw.endElement("head");
                rw.startElement("body");
                rw.startElement("p");
                rw.writeText(Messages.getMessage(this.description()));
                rw.endElement("p");
                for (Location location : this.reportSet.getLocations().rootLocations()) {
                    this.outputChecklistIssues(missingSightings, rw, location);
                }
                rw.startElement("p");
                rw.writeText(Messages.getFormattedMessage(Messages.Name.TAXONOMY_WITH_NAME, taxonomy.getName()));
                rw.endElement("p");
                if (this.versionInfo != null) {
                    rw.startElement("p");
                    rw.writeText(Messages.getFormattedMessage(Messages.Name.SCYTHEBILL_VERSION, this.versionInfo));
                    rw.endElement("p");
                }
                rw.endElement("body");
                rw.endElement("html");
                rw.endDocument();
                rw.close();
                DesktopUtils.openHtmlFileInBrowser(temp);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private void outputChecklistIssues(ListMultimap<Location, SightingTaxon.Resolved> missingSightings, HtmlResponseWriter rw, Location location) throws IOException {
        if (missingSightings.containsKey(location)) {
            Checklist checklist = this.checklists.getChecklist(this.reportSet, this.taxonomyStore.getTaxonomy(), location);
            Collection list = missingSightings.get((Object)location);
            rw.startElement("h2");
            String locationName = CODES_WITH_MULTIPLE_REGIONS.contains(Locations.getLocationCode(location)) ? String.format("%s (%s)", location.getDisplayName(), location.getParent().getDisplayName()) : location.getDisplayName();
            if (!checklist.isBuiltIn()) {
                rw.writeText(Messages.getFormattedMessage(Messages.Name.CUSTOM_CHECKLIST_FORMAT, locationName));
            } else {
                rw.writeText(locationName);
            }
            rw.endElement("h2");
            rw.startElement("ul");
            ImmutableSortedSet<SightingTaxon.Resolved> sorted = ImmutableSortedSet.copyOf(new ResolvedComparator(), list);
            for (SightingTaxon.Resolved resolved : sorted) {
                rw.startElement("li");
                rw.writeText(String.format("%s (%s)", resolved.getCommonName(), resolved.getFullName()));
                if (resolved.getTaxon() instanceof Species) {
                    rw.startElement("br");
                    rw.endElement("br");
                    String range = TaxonUtils.getRange((Species)resolved.getTaxon());
                    if (range != null) {
                        rw.writeText(Messages.getFormattedMessage(Messages.Name.EXPECTED_RANGE_FORMAT, range));
                    }
                }
                rw.endElement("li");
            }
            rw.endElement("ul");
        }
        for (Location child : location.contents()) {
            this.outputChecklistIssues(missingSightings, rw, child);
        }
    }

    protected boolean statusIsReportable(Checklist.Status status) {
        return status == null;
    }

    protected Messages.Name description() {
        return Messages.Name.CHECKLIST_ISSUES_DESCRIPTION;
    }

    protected Messages.Name title() {
        return Messages.Name.CHECKLIST_ISSUES;
    }

    protected void showNoSightingsFound(Alerts alerts, Component source) {
        alerts.showMessage((Object)source, Messages.Name.NO_ISSUES_FOUND, Messages.Name.ALL_SIGHTINGS_CONFORM, new Object[0]);
    }
}

