/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.actions;

import com.google.inject.Inject;
import com.scythebill.birdlist.model.checklist.Checklist;
import com.scythebill.birdlist.model.checklist.Checklists;
import com.scythebill.birdlist.model.sighting.ReportSet;
import com.scythebill.birdlist.ui.actions.IdentifySpeciesMissingFromChecklistsAction;
import com.scythebill.birdlist.ui.events.TaxonomyStore;
import com.scythebill.birdlist.ui.guice.CurrentVersion;
import com.scythebill.birdlist.ui.messages.Messages;
import com.scythebill.birdlist.ui.util.Alerts;
import java.awt.Component;
import javax.annotation.Nullable;

public class IdentifyRaritySightingsAction
extends IdentifySpeciesMissingFromChecklistsAction {
    @Inject
    IdentifyRaritySightingsAction(TaxonomyStore taxonomyStore, ReportSet reportSet, Checklists checklists, Alerts alerts, @Nullable @CurrentVersion String versionInfo) {
        super(taxonomyStore, reportSet, checklists, alerts, versionInfo);
    }

    @Override
    protected boolean statusIsReportable(Checklist.Status status) {
        return status == Checklist.Status.RARITY || status == Checklist.Status.RARITY_FROM_INTRODUCED;
    }

    @Override
    protected void showNoSightingsFound(Alerts alerts, Component source) {
        alerts.showMessage((Object)source, Messages.Name.NO_RARITIES_FOUND, Messages.Name.NO_SIGHTINGS_ARE_RARITIES, new Object[0]);
    }

    @Override
    protected Messages.Name description() {
        return Messages.Name.CHECKLIST_RARITIES_DESCRIPTION;
    }

    @Override
    protected Messages.Name title() {
        return Messages.Name.CHECKLIST_RARITIES_TITLE;
    }
}

