/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.actions;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.common.io.Resources;
import com.google.inject.Inject;
import com.scythebill.birdlist.model.checklist.Checklist;
import com.scythebill.birdlist.model.checklist.TransposedChecklist;
import com.scythebill.birdlist.model.checklist.TransposedChecklists;
import com.scythebill.birdlist.model.sighting.Location;
import com.scythebill.birdlist.model.sighting.LocationSet;
import com.scythebill.birdlist.model.sighting.PredefinedLocations;
import com.scythebill.birdlist.model.sighting.ReportSet;
import com.scythebill.birdlist.model.sighting.Sighting;
import com.scythebill.birdlist.model.sighting.SightingTaxon;
import com.scythebill.birdlist.model.taxa.Species;
import com.scythebill.birdlist.model.taxa.Taxon;
import com.scythebill.birdlist.model.taxa.TaxonUtils;
import com.scythebill.birdlist.model.taxa.TaxonVisitor;
import com.scythebill.birdlist.model.taxa.Taxonomy;
import com.scythebill.birdlist.ui.events.TaxonomyStore;
import com.scythebill.birdlist.ui.panels.reports.QueryPreferences;
import com.scythebill.birdlist.ui.util.DesktopUtils;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.text.StringEscapeUtils;

public class IdentifyLifersFromChecklistsAction {
    private final ReportSet reportSet;
    private final TaxonomyStore taxonomyStore;
    private final PredefinedLocations predefinedLocations;
    private final QueryPreferences queryPreferences;
    private final ImmutableMap<String, String> EBIRD_LOCATIONS_NOT_IN_GOOGLE = ImmutableBiMap.of("UM-71", "US-HI", "BQ-BO", "BQ");
    private final ImmutableBiMap<String, String> EBIRD_TO_GOOGLE_COUNTRIES = ImmutableBiMap.of("FI-01", "AX");
    private final ImmutableMap<String, String> STATE_TO_COUNTRY_CODE = ImmutableMap.of("CW", "BQ");

    @Inject
    IdentifyLifersFromChecklistsAction(TaxonomyStore taxonomyStore, ReportSet reportSet, PredefinedLocations predefinedLocations, QueryPreferences queryPreferences) {
        this.reportSet = reportSet;
        this.taxonomyStore = taxonomyStore;
        this.predefinedLocations = predefinedLocations;
        this.queryPreferences = queryPreferences;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void showMap(final Taxon.Type taxonType) {
        Preconditions.checkArgument(taxonType == Taxon.Type.species || taxonType == Taxon.Type.family);
        Taxonomy taxonomy = this.taxonomyStore.getTaxonomy();
        final HashSet<String> recordedTaxa = Sets.newHashSet();
        Predicate<Sighting> countablePredicate = this.queryPreferences.getCountablePredicate(taxonomy, false, null);
        for (Sighting sighting : this.reportSet.getSightings(taxonomy)) {
            SightingTaxon.Resolved resolved;
            SightingTaxon taxon;
            if (!countablePredicate.apply(sighting) || (taxon = (resolved = sighting.getTaxon().resolve(taxonomy)).getParentOfAtLeastType(taxonType)).getType() != SightingTaxon.Type.SINGLE && taxon.getType() != SightingTaxon.Type.SINGLE_WITH_SECONDARY_SUBSPECIES) continue;
            recordedTaxa.add(taxon.getId());
        }
        final TransposedChecklist transposed = TransposedChecklists.instance().getTransposedChecklist(this.reportSet, taxonomy);
        if (transposed == null) {
            throw new IllegalArgumentException("No transposed checklists for " + taxonomy.getId());
        }
        final ImmutableSet<Checklist.Status> allowedStatuses = this.queryPreferences.countIntroduced ? ImmutableSet.of(Checklist.Status.ENDEMIC, Checklist.Status.NATIVE, Checklist.Status.INTRODUCED) : ImmutableSet.of(Checklist.Status.ENDEMIC, Checklist.Status.NATIVE);
        final HashMultimap countryCounts = HashMultimap.create();
        TaxonUtils.visitTaxa(taxonomy, new TaxonVisitor(){

            @Override
            public boolean visitTaxon(Taxon taxon) {
                if (taxon.getType() != Taxon.Type.species) {
                    return true;
                }
                Taxon elevatedTaxon = TaxonUtils.getParentOfType(taxon, taxonType);
                if (recordedTaxa.contains(elevatedTaxon.getId())) {
                    return false;
                }
                if (!IdentifyLifersFromChecklistsAction.this.queryPreferences.countUndescribed && taxon.getStatus() == Species.Status.UN) {
                    return false;
                }
                for (String location : this.normalizeCountries(transposed.locationsWithStatuses(taxon, (ImmutableSet<Checklist.Status>)allowedStatuses))) {
                    countryCounts.put(location, elevatedTaxon.getId());
                }
                return false;
            }

            private Set<String> normalizeCountries(Iterable<String> values) {
                HashSet<String> set = Sets.newHashSet();
                for (String value : values) {
                    if (IdentifyLifersFromChecklistsAction.this.EBIRD_TO_GOOGLE_COUNTRIES.containsKey(value)) {
                        value = (String)IdentifyLifersFromChecklistsAction.this.EBIRD_TO_GOOGLE_COUNTRIES.get(value);
                    } else if (IdentifyLifersFromChecklistsAction.this.EBIRD_LOCATIONS_NOT_IN_GOOGLE.containsKey(value)) {
                        value = IdentifyLifersFromChecklistsAction.this.EBIRD_LOCATIONS_NOT_IN_GOOGLE.get(value);
                    }
                    int indexOf = value.indexOf(45);
                    if (indexOf < 0) {
                        set.add(value);
                        continue;
                    }
                    set.add(value.substring(0, indexOf));
                }
                return set;
            }
        });
        try {
            String startTemplate = Resources.toString(Resources.getResource(this.getClass(), "lifer.start.html.template"), StandardCharsets.UTF_8);
            String endTemplate = Resources.toString(Resources.getResource(this.getClass(), "lifer.end.html.template"), StandardCharsets.UTF_8);
            File file = File.createTempFile("lifers", ".html");
            try (FileWriter writer = new FileWriter(file);){
                writer.write(String.format(startTemplate, taxonomy.getName()));
                for (String country : countryCounts.keys()) {
                    String countryName = this.getCountryName(country);
                    writer.write(String.format("[{v:\"%s\",f:\"%s\"}, %d],", country, StringEscapeUtils.escapeJson(countryName), countryCounts.get(country).size()));
                }
                writer.write(endTemplate);
            }
            DesktopUtils.openHtmlFileInBrowser(file);
        }
        catch (IOException e) {
            throw new IllegalStateException("Couldn't write", e);
        }
    }

    private String getCountryName(String country) {
        Collection<Object> possibleLocations;
        LocationSet locations;
        Location location;
        if (this.EBIRD_TO_GOOGLE_COUNTRIES.containsValue(country)) {
            country = (String)((ImmutableMap)((Object)this.EBIRD_TO_GOOGLE_COUNTRIES.inverse())).get(country);
        }
        if ((location = (locations = this.reportSet.getLocations()).getLocationByCode(country)) != null) {
            return location.getDisplayName();
        }
        int hyphen = country.indexOf(45);
        if (hyphen > 0) {
            String justCountry = country.substring(0, hyphen);
            possibleLocations = locations.getLocationsByCode(justCountry);
        } else if (this.STATE_TO_COUNTRY_CODE.containsKey(country)) {
            String actualCountry = this.STATE_TO_COUNTRY_CODE.get(country);
            possibleLocations = locations.getLocationsByCode(actualCountry);
        } else {
            possibleLocations = ImmutableList.of();
        }
        for (Location possibleLocation : possibleLocations) {
            PredefinedLocations.PredefinedLocation predefinedChild = this.predefinedLocations.getPredefinedLocationChildByCode(possibleLocation, country);
            if (predefinedChild == null) continue;
            return predefinedChild.getName();
        }
        return country;
    }
}

