/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.actions;

import com.google.common.base.Predicates;
import com.google.common.io.ByteSink;
import com.google.common.io.FileWriteMode;
import com.google.common.io.Files;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import com.scythebill.birdlist.model.export.FullReportExport;
import com.scythebill.birdlist.model.io.PartialIO;
import com.scythebill.birdlist.model.query.QueryProcessor;
import com.scythebill.birdlist.model.query.QueryResults;
import com.scythebill.birdlist.model.sighting.ReportSet;
import com.scythebill.birdlist.model.taxa.Taxon;
import com.scythebill.birdlist.ui.events.TaxonomyStore;
import com.scythebill.birdlist.ui.messages.Messages;
import com.scythebill.birdlist.ui.panels.FilePreferences;
import com.scythebill.birdlist.ui.util.Alerts;
import com.scythebill.birdlist.ui.util.FileDialogs;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import javax.swing.AbstractAction;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.joda.time.LocalDate;
import org.joda.time.chrono.GJChronology;

public class FullExportAction
extends AbstractAction {
    private final FileDialogs fileDialogs;
    private final ReportSet reportSet;
    private final TaxonomyStore taxonomyStore;
    private final Alerts alerts;
    private final String reportSetFileName;

    @Inject
    public FullExportAction(FileDialogs fileDialogs, ReportSet reportSet, @Named(value="com.adamwiner.birdlist.ui.reportFile") String reportSetFileName, TaxonomyStore taxonomyStore, Alerts alerts) {
        this.fileDialogs = fileDialogs;
        this.reportSet = reportSet;
        this.reportSetFileName = reportSetFileName;
        this.taxonomyStore = taxonomyStore;
        this.alerts = alerts;
    }

    private static Frame getParentFrame(Object object) {
        for (Component c = (Component)object; c != null; c = c.getParent()) {
            if (!(c instanceof Frame)) continue;
            return (Frame)c;
        }
        return null;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        String today = PartialIO.toString(new LocalDate(GJChronology.getInstance()));
        String exportFileName = String.format("export-%s-%s.csv", this.reportSetFileName, today);
        File file = this.fileDialogs.saveFile(FullExportAction.getParentFrame(event.getSource()), Messages.getMessage(Messages.Name.PICK_FILE_TITLE), exportFileName, new FileNameExtensionFilter(Messages.getMessage(Messages.Name.CSV_FILES), "csv"), FilePreferences.FileType.OTHER);
        if (file != null) {
            QueryProcessor queryProcessor = new QueryProcessor(this.reportSet, this.taxonomyStore.getTaxonomy());
            QueryResults queryResults = queryProcessor.runQuery(Predicates.alwaysTrue(), Predicates.alwaysTrue(), Taxon.Type.subspecies);
            ByteSink outSupplier = Files.asByteSink(file, new FileWriteMode[0]);
            try {
                new FullReportExport().exportReportSet(outSupplier, this.reportSet, this.taxonomyStore.getTaxonomy(), queryResults);
            }
            catch (IOException e) {
                this.alerts.reportError(e);
            }
        }
    }
}

