/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.actions;

import com.google.inject.Inject;
import com.scythebill.birdlist.ui.actions.ActionBroker;
import com.scythebill.birdlist.ui.actions.DownloadLatestAction;
import com.scythebill.birdlist.ui.actions.MinimalMenuConfiguration;
import com.scythebill.birdlist.ui.actions.NewReportSetAction;
import com.scythebill.birdlist.ui.actions.OpenAction;
import com.scythebill.birdlist.ui.actions.OpenSourceLicensesAction;
import com.scythebill.birdlist.ui.actions.QuitAction;
import com.scythebill.birdlist.ui.actions.ReportIssueAction;
import com.scythebill.birdlist.ui.actions.ShowEMailGroupAction;
import com.scythebill.birdlist.ui.actions.ShowManualAction;
import com.scythebill.birdlist.ui.fonts.DecreaseFontSizeAction;
import com.scythebill.birdlist.ui.fonts.IncreaseFontSizeAction;
import com.scythebill.birdlist.ui.messages.Messages;
import com.scythebill.birdlist.ui.panels.AboutFrame;
import com.scythebill.birdlist.ui.panels.PrivacyPolicyFrame;
import com.scythebill.birdlist.ui.util.Alerts;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;

public class DefaultMenuConfiguration
extends MinimalMenuConfiguration {
    private final QuitAction quitAction;
    private final AboutFrame aboutFrame;
    private final PrivacyPolicyFrame privacyPolicyFrame;
    private final Alerts alerts;

    @Inject
    public DefaultMenuConfiguration(ActionBroker actionBroker, OpenAction openAction, NewReportSetAction newAction, IncreaseFontSizeAction increaseFontSizeAction, DecreaseFontSizeAction decreaseFontSizeAction, QuitAction quitAction, AboutFrame aboutFrame, PrivacyPolicyFrame privacyPolicyFrame, Alerts alerts) {
        super(actionBroker, openAction, newAction, increaseFontSizeAction, decreaseFontSizeAction, privacyPolicyFrame, alerts);
        this.quitAction = quitAction;
        this.aboutFrame = aboutFrame;
        this.privacyPolicyFrame = privacyPolicyFrame;
        this.alerts = alerts;
    }

    @Override
    public JMenu getFileMenu() {
        JMenu menu = super.getFileMenu();
        menu.addSeparator();
        int keyModifier = Toolkit.getDefaultToolkit().getMenuShortcutKeyMaskEx();
        JMenuItem quitItem = new JMenuItem();
        quitItem.setAction(this.quitAction);
        quitItem.setText(Messages.getMessage(Messages.Name.QUIT_MENU));
        quitItem.setAccelerator(KeyStroke.getKeyStroke(115, keyModifier));
        menu.add(quitItem);
        return menu;
    }

    @Override
    public JMenu getHelpMenu() {
        JMenu menu = new JMenu();
        menu.setText(Messages.getMessage(Messages.Name.HELP_MENU));
        JMenuItem aboutItem = new JMenuItem();
        aboutItem.setAction(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent event) {
                DefaultMenuConfiguration.this.aboutFrame.show();
            }
        });
        aboutItem.setText(Messages.getMessage(Messages.Name.ABOUT_SCYTHEBILL));
        menu.add(aboutItem);
        JMenuItem showManualItem = new JMenuItem();
        showManualItem.setAction(new ShowManualAction(this.alerts));
        showManualItem.setText(Messages.getMessage(Messages.Name.SCYTHEBILL_MANUAL));
        menu.add(showManualItem);
        JMenuItem emailGroup = new JMenuItem();
        emailGroup.setAction(new ShowEMailGroupAction(this.alerts));
        emailGroup.setText(Messages.getMessage(Messages.Name.SCYTHEBILL_EMAIL_GROUP));
        menu.add(emailGroup);
        JMenuItem downloadLatest = new JMenuItem();
        downloadLatest.setAction(new DownloadLatestAction(this.alerts));
        downloadLatest.setText(Messages.getMessage(Messages.Name.DOWNLOAD_LATEST));
        menu.add(downloadLatest);
        JMenuItem reportIssueItem = new JMenuItem();
        reportIssueItem.setAction(new ReportIssueAction(this.alerts));
        reportIssueItem.setText(Messages.getMessage(Messages.Name.REPORT_ISSUE));
        menu.add(reportIssueItem);
        JMenuItem openSourceItem = new JMenuItem();
        openSourceItem.setAction(new OpenSourceLicensesAction());
        openSourceItem.setText(Messages.getMessage(Messages.Name.OPEN_SOURCE_LICENSES));
        menu.add(openSourceItem);
        JMenuItem privacyPolicyItem = new JMenuItem();
        privacyPolicyItem.setAction(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DefaultMenuConfiguration.this.privacyPolicyFrame.show();
            }
        });
        privacyPolicyItem.setText(Messages.getMessage(Messages.Name.PRIVACY_POLICY_MENU));
        menu.add(privacyPolicyItem);
        return menu;
    }
}

