/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.ui.actions;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.scythebill.birdlist.ui.actions.DelegatedAction;
import java.util.Map;
import javax.swing.Action;

@Singleton
public class ActionBroker {
    public static final String CUT = "cut";
    public static final String COPY = "copy";
    public static final String PASTE = "paste";
    public static final String SAVE = "save";
    public static final String SAVE_A_COPY_AS = "saveACopyAs";
    public static final String CLOSE = "close";
    public static final String PRINT = "print";
    public static final String EXPORT = "export";
    public static final String OPEN_CONTAINING = "openContaining";
    public static final String IMPORT = "import";
    public static final String MANAGE_TAXONOMIES = "manageTaxonomies";
    public static final String IDENTIFY_CHECKLIST_ERRORS = "identifyChecklistErrors";
    public static final String IDENTIFY_CHECKLIST_RARITIES = "identifyChecklistRarities";
    public static final String RECONCILE_AGAINST_CHECKLISTS = "recocileAgainstChecklists";
    public static final String IMPORT_CHECKLISTS = "importChecklists";
    public static final String FULL_EXPORT = "fullExport";
    public static final String PREFERENCES = "preferences";
    private final Map<String, DelegatedAction> actions = Maps.newHashMap();

    @Inject
    public ActionBroker() {
    }

    public Action createAction(String name) {
        if (this.actions.containsKey(name)) {
            return this.actions.get(name);
        }
        Preconditions.checkState(!this.actions.containsKey(name));
        DelegatedAction action = new DelegatedAction();
        this.actions.put(name, action);
        return action;
    }

    public void publishAction(String name, Action delegateTo) {
        DelegatedAction action = this.actions.get(name);
        if (action != null) {
            action.setDelegate(delegateTo);
        }
    }

    public void unpublishAction(String name, Action delegateTo) {
        DelegatedAction action = this.actions.get(name);
        if (action != null && action.getDelegate() == delegateTo) {
            action.setDelegate(null);
        }
    }
}

