/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.model.xml;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.scythebill.birdlist.model.sighting.SightingTaxon;
import com.scythebill.birdlist.model.sighting.SightingTaxons;
import com.scythebill.birdlist.model.taxa.MappedTaxonomy;
import com.scythebill.birdlist.model.taxa.Species;
import com.scythebill.birdlist.model.taxa.SpeciesImpl;
import com.scythebill.birdlist.model.taxa.Taxon;
import com.scythebill.birdlist.model.taxa.TaxonImpl;
import com.scythebill.birdlist.model.taxa.Taxonomy;
import com.scythebill.birdlist.model.taxa.TaxonomyImpl;
import com.scythebill.birdlist.model.xml.ExtendedTaxonomyNodeParser;
import com.scythebill.xml.BaseNodeParser;
import com.scythebill.xml.NodeParser;
import com.scythebill.xml.ParseContext;
import com.scythebill.xml.ParseContextImpl;
import com.scythebill.xml.ParserFactory;
import com.scythebill.xml.ParserManager;
import com.scythebill.xml.StringParser;
import com.scythebill.xml.TreeBuilder;
import java.io.IOException;
import java.io.Reader;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XmlTaxonImport {
    private static final ParserManager PARSER_MANAGER = XmlTaxonImport.createParserManager();
    private static final Map<String, Taxon.Type> TAXON_TYPES_BY_NAME = ImmutableMap.builder().put("class", Taxon.Type.classTaxon).put("family", Taxon.Type.family).put("genus", Taxon.Type.genus).put("order", Taxon.Type.order).put("species", Taxon.Type.species).put("subspecies", Taxon.Type.subspecies).put("group", Taxon.Type.group).put("phylum", Taxon.Type.phylum).build();
    private static final Object MAPPED_TAXONOMY_MAPPINGS_KEY = new Object();

    public Taxonomy importTaxa(Reader in) throws IOException, SAXException {
        TreeBuilder<Taxonomy> builder = new TreeBuilder<Taxonomy>(PARSER_MANAGER, Taxonomy.class);
        return builder.parse(new InputSource(in));
    }

    public MappedTaxonomy importMappedTaxa(Reader in, Taxonomy base) throws IOException, SAXException {
        TreeBuilder<MappedTaxonomy> builder = new TreeBuilder<MappedTaxonomy>(PARSER_MANAGER, MappedTaxonomy.class);
        ParseContextImpl parseContextImpl = new ParseContextImpl();
        parseContextImpl.setProperty(Taxonomy.class, base);
        IdentityHashMap mappings = Maps.newIdentityHashMap();
        parseContextImpl.setProperty(MAPPED_TAXONOMY_MAPPINGS_KEY, mappings);
        MappedTaxonomy mappedTaxonomy = builder.parse(new InputSource(in), parseContextImpl);
        MappedTaxonomy.MappingBuilder mappingBuilder = new MappedTaxonomy.MappingBuilder();
        for (Map.Entry mapping : mappings.entrySet()) {
            mappingBuilder.registerTaxonMapping((Taxon)mapping.getKey(), (SightingTaxon)mapping.getValue());
        }
        mappedTaxonomy.setMappings(mappingBuilder);
        this.disableUnmappedTaxa(mappedTaxonomy, mappedTaxonomy.getRoot());
        return mappedTaxonomy;
    }

    private boolean disableUnmappedTaxa(MappedTaxonomy mappedTaxonomy, Taxon taxon) {
        boolean foundMapping = false;
        for (Taxon child : taxon.getContents()) {
            foundMapping = this.disableUnmappedTaxa(mappedTaxonomy, child) || foundMapping;
        }
        if (!foundMapping) {
            if (mappedTaxonomy.getExactMapping(taxon) != null) {
                foundMapping = true;
            } else {
                taxon.setDisabled(true);
            }
        }
        return foundMapping;
    }

    private static IdentityHashMap<Taxon, SightingTaxon> taxonMappings(ParseContext context) {
        return (IdentityHashMap)context.getProperty(MAPPED_TAXONOMY_MAPPINGS_KEY);
    }

    private static ParserManager createParserManager() {
        ParserManager pm = new ParserManager();
        pm.registerFactory(MappedTaxonomy.class, "http://www.adamwiner.com/checklist/1.0", new MappedTaxonomyFactory());
        pm.registerFactory(Taxonomy.class, "http://www.adamwiner.com/checklist/1.0", new TaxonomyFactory());
        pm.registerFactory(Taxon.class, "http://www.adamwiner.com/checklist/1.0", new TaxonFactory());
        return pm;
    }

    private static TaxonomyImpl _getTaxonomy(ParseContext context) {
        return (TaxonomyImpl)context.getProperty(TaxonomyImpl.class);
    }

    private static void setTaxonomy(ParseContext context, TaxonomyImpl taxonomy) {
        context.setProperty(TaxonomyImpl.class, taxonomy);
    }

    private static class MappedTaxonomyFactory
    implements ParserFactory {
        private MappedTaxonomyFactory() {
        }

        @Override
        public NodeParser getParser(ParseContext context, String namespaceURI, String localName) {
            return new MappedTaxonomyImplParser((Taxonomy)context.getProperty(Taxonomy.class));
        }
    }

    static class TaxonomyFactory
    implements ParserFactory {
        TaxonomyFactory() {
        }

        @Override
        public NodeParser getParser(ParseContext context, String namespaceURI, String localName) {
            return new TaxonomyImplParser();
        }
    }

    private static class TaxonFactory
    implements ParserFactory {
        static ParserFactory INSTANCE = new TaxonFactory();

        private TaxonFactory() {
        }

        @Override
        public NodeParser getParser(ParseContext context, String namespaceURI, String localName) {
            Taxon.Type type = TAXON_TYPES_BY_NAME.get(localName);
            if (type == null) {
                return null;
            }
            if (type == Taxon.Type.species || type == Taxon.Type.subspecies || type == Taxon.Type.group) {
                return new SpeciesParser(type);
            }
            return new TaxonParser(type);
        }
    }

    private static class TaxonParser
    extends BaseNodeParser {
        private final Taxon.Type type;
        private TaxonImpl taxon;
        protected String id;

        public TaxonParser(Taxon.Type type) {
            this.type = type;
        }

        @Override
        public void addCompletedChild(ParseContext context, String namespaceURI, String localName, Object child) throws SAXParseException {
            if ("common-name".equals(localName)) {
                this.taxon.setCommonName((String)child);
            } else if (child instanceof Taxon) {
                this.taxon.getContents().add((Taxon)child);
                ((TaxonImpl)child).setParent(this.taxon);
            }
            super.addCompletedChild(context, namespaceURI, localName, child);
        }

        @Override
        public Object endElement(ParseContext context, String namespaceURI, String localName) throws SAXParseException {
            return this.taxon;
        }

        @Override
        public NodeParser startChildElement(ParseContext context, String namespaceURI, String localName, Attributes attrs) throws SAXParseException {
            if ("common-name".equals(localName)) {
                return new StringParser();
            }
            return TaxonFactory.INSTANCE.getParser(context, namespaceURI, localName);
        }

        @Override
        public void startElement(ParseContext context, String namespaceURI, String localName, Attributes attrs) throws SAXParseException {
            String conceptId;
            String accountId;
            TaxonomyImpl taxonomy = XmlTaxonImport._getTaxonomy(context);
            this.taxon = this.createTaxon(this.type, taxonomy);
            this.taxon.setName(this.getRequiredAttribute(context, attrs, "name"));
            this.id = this.getRequiredAttribute(context, attrs, "id");
            if (this.id != null) {
                taxonomy.register(this.taxon, this.id);
            }
            if ((accountId = attrs.getValue("accountId")) != null) {
                this.taxon.setAccountId(accountId);
            }
            if ((conceptId = attrs.getValue("conceptId")) != null) {
                this.taxon.setConceptId(conceptId);
            }
        }

        protected TaxonImpl createTaxon(Taxon.Type type, Taxonomy taxonomy) {
            return new TaxonImpl(type, taxonomy);
        }
    }

    private static class SpeciesParser
    extends TaxonParser {
        private boolean hasMetadata;
        private SpeciesImpl species;
        private ImmutableList.Builder<String> alternateNames;
        private ImmutableList.Builder<String> alternateCommonNames;

        public SpeciesParser(Taxon.Type type) {
            super(type);
        }

        @Override
        public NodeParser startChildElement(ParseContext context, String namespaceURI, String localName, Attributes attrs) throws SAXParseException {
            if (this.hasMetadata) {
                if ("alternate-names".equals(localName) || "alternate-common-names".equals(localName) || "range".equals(localName) || "miscellaneous".equals(localName) || "status".equals(localName) || "taxonomy".equals(localName)) {
                    return new StringParser();
                }
                return null;
            }
            if ("metadata".equals(localName)) {
                this.hasMetadata = true;
                return this;
            }
            if ("map".equals(localName) || "spmap".equals(localName) || "sspmap".equals(localName)) {
                return new StringParser();
            }
            if ("nomap".equals(localName)) {
                return BaseNodeParser.getIgnoreParser();
            }
            if ("checklists".equals(localName) && ExtendedTaxonomyNodeParser.canParseChecklists(context)) {
                return new StringParser();
            }
            return super.startChildElement(context, namespaceURI, localName, attrs);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void addCompletedChild(ParseContext context, String namespaceURI, String localName, Object child) throws SAXParseException {
            if (this.hasMetadata) {
                String s = (String)child;
                if ("alternate-names".equals(localName)) {
                    if (this.alternateNames == null) {
                        this.alternateNames = ImmutableList.builder();
                    }
                    this.alternateNames.add((Object)s);
                    return;
                } else if ("alternate-common-names".equals(localName)) {
                    if (this.alternateCommonNames == null) {
                        this.alternateCommonNames = ImmutableList.builder();
                    }
                    this.alternateCommonNames.add((Object)s);
                    return;
                } else if ("miscellaneous".equals(localName)) {
                    this.species.setMiscellaneousInfo(s);
                    return;
                } else if ("taxonomy".equals(localName)) {
                    this.species.setTaxonomicInfo(s);
                    return;
                } else if ("range".equals(localName)) {
                    this.species.setRange(s);
                    return;
                } else {
                    if (!"status".equals(localName)) throw new SAXParseException("Unexpected metadata: " + localName, context.getLocator());
                    this.species.setStatus(Enum.valueOf(Species.Status.class, s.trim()));
                }
                return;
            } else if ("map".equals(localName)) {
                IdentityHashMap<Taxon, SightingTaxon> taxonMappings = XmlTaxonImport.taxonMappings(context);
                if (taxonMappings == null) return;
                taxonMappings.put(this.species, SightingTaxons.newSightingTaxon((String)child));
                return;
            } else if ("spmap".equals(localName)) {
                ImmutableList<String> ids = ImmutableList.copyOf(Splitter.on(',').split((String)child));
                IdentityHashMap<Taxon, SightingTaxon> taxonMappings = XmlTaxonImport.taxonMappings(context);
                if (taxonMappings == null) return;
                try {
                    taxonMappings.put(this.species, SightingTaxons.newSpTaxon(ids));
                    return;
                }
                catch (IllegalStateException e) {
                    SAXParseException saxE = new SAXParseException("Could not parse SP mapping", context.getLocator());
                    saxE.initCause(e);
                    throw saxE;
                }
            } else if ("sspmap".equals(localName)) {
                IdentityHashMap<Taxon, SightingTaxon> taxonMappings = XmlTaxonImport.taxonMappings(context);
                if (taxonMappings == null) return;
                SightingTaxon sightingTaxon = XmlTaxonImport.taxonMappings(context).get(this.species);
                if (sightingTaxon == null || sightingTaxon.getType() != SightingTaxon.Type.SINGLE) {
                    throw new SAXParseException("Unexpected spp mapping " + child, context.getLocator());
                }
                if (taxonMappings == null) return;
                taxonMappings.put(this.species, SightingTaxons.newSightingTaxonWithSecondarySubspecies(sightingTaxon.getId(), (String)child));
                return;
            } else if ("checklists".equals(localName)) {
                String s = (String)child;
                List<String> codes = Splitter.on(',').splitToList(s);
                if (codes.isEmpty()) return;
                ExtendedTaxonomyNodeParser.addChecklistElements(context, SightingTaxons.newSightingTaxon(this.id), this.species.getStatus(), codes);
                return;
            } else {
                super.addCompletedChild(context, namespaceURI, localName, child);
            }
        }

        @Override
        public void endChildElement(ParseContext context, String namespaceURI, String localName) throws SAXParseException {
            if ("metadata".equals(localName)) {
                this.hasMetadata = false;
            }
        }

        @Override
        protected TaxonImpl createTaxon(Taxon.Type type, Taxonomy taxonomy) {
            this.species = new SpeciesImpl(type, null);
            return this.species;
        }

        @Override
        public Object endElement(ParseContext context, String namespaceURI, String localName) throws SAXParseException {
            if (this.alternateNames != null) {
                this.species.setAlternateNames((List<String>)((Object)this.alternateNames.build()));
            }
            if (this.alternateCommonNames != null) {
                this.species.setAlternateCommonNames((List<String>)((Object)this.alternateCommonNames.build()));
            }
            return super.endElement(context, namespaceURI, localName);
        }
    }

    static class TaxonomyImplParser
    extends BaseNodeParser {
        private TaxonomyImpl taxonomy;

        @Override
        public void addCompletedChild(ParseContext context, String namespaceURI, String localName, Object child) throws SAXParseException {
            if ("additional-credit".equals(localName)) {
                this.taxonomy.addAdditionalCredit((String)child);
            } else {
                this.taxonomy.setRoot((Taxon)child);
            }
        }

        @Override
        public Object endElement(ParseContext context, String namespaceURI, String localName) throws SAXParseException {
            XmlTaxonImport.setTaxonomy(context, null);
            return this.taxonomy;
        }

        @Override
        public NodeParser startChildElement(ParseContext context, String namespaceURI, String localName, Attributes attrs) throws SAXParseException {
            if ("additional-credit".equals(localName)) {
                return new StringParser();
            }
            return TaxonFactory.INSTANCE.getParser(context, namespaceURI, localName);
        }

        @Override
        public void startElement(ParseContext context, String namespaceURI, String localName, Attributes attrs) throws SAXParseException {
            String id = this.getRequiredAttribute(context, attrs, "id");
            String name = this.getRequiredAttribute(context, attrs, "name");
            String accountUrlFormat = attrs.getValue("accountUrlFormat");
            String accountLinkTitle = attrs.getValue("accountLinkTitle");
            this.taxonomy = this.newTaxonomy(id, name, accountUrlFormat, accountLinkTitle);
            XmlTaxonImport.setTaxonomy(context, this.taxonomy);
        }

        protected TaxonomyImpl newTaxonomy(String id, String name, String accountUrlFormat, String accountUrlTitle) {
            return new TaxonomyImpl(id, name, accountUrlFormat, accountUrlTitle);
        }
    }

    private static class MappedTaxonomyImplParser
    extends TaxonomyImplParser {
        private final Taxonomy base;

        public MappedTaxonomyImplParser(Taxonomy base) {
            this.base = Preconditions.checkNotNull(base);
        }

        @Override
        protected TaxonomyImpl newTaxonomy(String id, String name, String accountIdFormat, String accountLinkTitle) {
            return new MappedTaxonomy(this.base, id, name);
        }
    }
}

