/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.model.xml;

import com.google.common.base.CharMatcher;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.primitives.Floats;
import com.google.common.primitives.Ints;
import com.opencsv.exceptions.CsvValidationException;
import com.scythebill.birdlist.model.checklist.Checklist;
import com.scythebill.birdlist.model.checklist.ClementsChecklist;
import com.scythebill.birdlist.model.checklist.ExtendedTaxonomyChecklists;
import com.scythebill.birdlist.model.io.PartialIO;
import com.scythebill.birdlist.model.io.TimeIO;
import com.scythebill.birdlist.model.sighting.ApproximateNumber;
import com.scythebill.birdlist.model.sighting.Area;
import com.scythebill.birdlist.model.sighting.Distance;
import com.scythebill.birdlist.model.sighting.LatLongCoordinates;
import com.scythebill.birdlist.model.sighting.Link;
import com.scythebill.birdlist.model.sighting.Location;
import com.scythebill.birdlist.model.sighting.LocationSet;
import com.scythebill.birdlist.model.sighting.Photo;
import com.scythebill.birdlist.model.sighting.ReportSet;
import com.scythebill.birdlist.model.sighting.Sighting;
import com.scythebill.birdlist.model.sighting.SightingInfo;
import com.scythebill.birdlist.model.sighting.SightingTaxon;
import com.scythebill.birdlist.model.sighting.SightingTaxons;
import com.scythebill.birdlist.model.sighting.Trip;
import com.scythebill.birdlist.model.sighting.Trips;
import com.scythebill.birdlist.model.sighting.VisitInfo;
import com.scythebill.birdlist.model.sighting.VisitInfoKey;
import com.scythebill.birdlist.model.taxa.MappedTaxonomy;
import com.scythebill.birdlist.model.taxa.Taxon;
import com.scythebill.birdlist.model.taxa.Taxonomy;
import com.scythebill.birdlist.model.taxa.TaxonomyMappings;
import com.scythebill.birdlist.model.taxa.UpgradeTracker;
import com.scythebill.birdlist.model.user.User;
import com.scythebill.birdlist.model.user.UserSet;
import com.scythebill.birdlist.model.util.Versions;
import com.scythebill.birdlist.model.xml.ExtendedTaxonomyNodeParser;
import com.scythebill.birdlist.model.xml.VersionTooNewException;
import com.scythebill.birdlist.model.xml.XmlReportSetExport;
import com.scythebill.xml.BaseNodeParser;
import com.scythebill.xml.NodeParser;
import com.scythebill.xml.ParseContext;
import com.scythebill.xml.StringParser;
import com.scythebill.xml.TreeBuilder;
import java.io.IOException;
import java.io.Reader;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.joda.time.DateTimeFieldType;
import org.joda.time.Duration;
import org.joda.time.LocalTime;
import org.joda.time.Partial;
import org.joda.time.ReadablePartial;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XmlReportSetImport {
    private static final ImmutableMap<String, Checklist.Status> STATUS_TEXT;
    private static final Logger logger;
    public static final String REPORT_SET_SUFFIX = ".bsxm";

    public ReportSet importReportSet(Reader in, Taxonomy taxonomy, Optional<MappedTaxonomy> optionalMappedTaxonomy, TaxonomyMappings mappings) throws IOException, SAXException {
        TreeBuilder<ReportSet> builder = new TreeBuilder<ReportSet>(null, ReportSet.class);
        return builder.parse(new InputSource(in), new ReportSetParser(taxonomy, optionalMappedTaxonomy, mappings));
    }

    private static NodeParser getLocationParser(String localName, Location parent, LocationSet.Builder builder) {
        Location.Type type;
        if (localName.equals("description")) {
            return new StringParser();
        }
        if (localName.equals("country")) {
            type = Location.Type.country;
        } else if (localName.equals("town")) {
            type = Location.Type.town;
        } else if (localName.equals("park")) {
            type = Location.Type.park;
        } else if (localName.equals("city")) {
            type = Location.Type.city;
        } else if (localName.equals("county")) {
            type = Location.Type.county;
        } else if (localName.equals("state")) {
            type = Location.Type.state;
        } else if (localName.equals("region")) {
            type = Location.Type.region;
        } else if (localName.equals("location")) {
            type = null;
        } else {
            return null;
        }
        return new LocationParser(type, parent, builder);
    }

    private static ReadablePartial dateFromStringWithCenturyFix(String dateStr) {
        ReadablePartial datePartial = PartialIO.fromString(dateStr);
        if (datePartial.isSupported(DateTimeFieldType.year())) {
            int year = datePartial.get(DateTimeFieldType.year());
            if (year < 100) {
                year = year < 50 ? (year += 2000) : (year += 1900);
            }
            datePartial = new Partial(datePartial).with(DateTimeFieldType.year(), year);
        }
        return datePartial;
    }

    static {
        logger = Logger.getLogger(XmlReportSetImport.class.getName());
        ImmutableMap.Builder<String, Checklist.Status> builder = ImmutableMap.builder();
        for (Checklist.Status status : Checklist.Status.values()) {
            if (status.text() == null) continue;
            builder.put(status.text(), status);
        }
        STATUS_TEXT = builder.build();
    }

    private static class ReportSetParser
    extends BaseNodeParser {
        private final Taxonomy taxonomy;
        private final Optional<MappedTaxonomy> optionalMappedTaxonomy;
        private LocationSet locations;
        private Trips trips;
        private List<Sighting> sightings;
        private final Map<Location, Checklist> checklists = Maps.newLinkedHashMap();
        private final Map<VisitInfoKey, VisitInfo> visitInfos = Maps.newLinkedHashMap();
        private final Map<String, Taxonomy> extendedTaxonomies = Maps.newLinkedHashMap();
        private final Map<String, ExtendedTaxonomyChecklists> extendedTaxonomyChecklists = Maps.newLinkedHashMap();
        private final LoadingCache<String, ImmutableSet<User>> usersCache = CacheBuilder.newBuilder().build(new CacheLoader<String, ImmutableSet<User>>(){

            @Override
            public ImmutableSet<User> load(String usersString) throws Exception {
                return this.usersStringToUserSet(usersString);
            }
        });
        private final TaxonomyMappings mappings;
        private UpgradeTracker taxonomyTracker;
        private String version;
        private String prefs;
        private UserSet userSet;
        private final ImmutableSet.Builder<String> oneTimeUpgrades = ImmutableSet.builder();

        public ReportSetParser(Taxonomy taxonomy, Optional<MappedTaxonomy> optionalMappedTaxonomy, TaxonomyMappings mappings) {
            this.taxonomy = taxonomy;
            this.optionalMappedTaxonomy = optionalMappedTaxonomy;
            this.mappings = mappings;
        }

        @Override
        public void addCompletedChild(ParseContext context, String namespaceURI, String localName, Object child) throws SAXParseException {
            if (child instanceof LocationSet) {
                this.locations = (LocationSet)child;
            } else if (child instanceof Sighting) {
                this.sightings.add((Sighting)child);
            } else if (child instanceof ChecklistAndLocation) {
                ChecklistAndLocation checklistAndLocation = (ChecklistAndLocation)child;
                this.checklists.put(checklistAndLocation.location, checklistAndLocation.checklist);
            } else if (child instanceof VisitInfoAndKey) {
                VisitInfoAndKey visitInfoAndKey = (VisitInfoAndKey)child;
                this.visitInfos.put(visitInfoAndKey.key, visitInfoAndKey.visitInfo);
            } else if ("prefs".equals(localName)) {
                this.prefs = (String)child;
            } else if ("one-time-upgrade".equals(localName)) {
                this.oneTimeUpgrades.add((Object)((String)child));
            } else if (child instanceof Taxonomy) {
                Taxonomy childTaxonomy = (Taxonomy)child;
                ExtendedTaxonomyChecklists parsedChecklists = ExtendedTaxonomyNodeParser.endChecklistParsing(context);
                this.extendedTaxonomies.put(childTaxonomy.getId(), childTaxonomy);
                this.extendedTaxonomyChecklists.put(childTaxonomy.getId(), parsedChecklists);
            }
        }

        @Override
        public Object endElement(ParseContext context, String namespaceURI, String localName) throws SAXParseException {
            if (this.trips == null) {
                this.trips = new Trips(this.locations);
            }
            ReportSet reportSet = new ReportSet(this.locations, this.trips, this.sightings, this.taxonomy);
            reportSet.setPreferencesJson(this.prefs, false);
            reportSet.setCompletedUpgrade(this.taxonomyTracker == null ? null : this.taxonomyTracker.getCompletedUpgrade());
            if (this.version != null) {
                reportSet.setLoadedVersion(this.version);
            }
            for (Taxonomy taxonomy : this.extendedTaxonomies.values()) {
                reportSet.addExtendedTaxonomy(taxonomy, this.extendedTaxonomyChecklists.get(taxonomy.getId()));
            }
            for (Map.Entry entry : this.checklists.entrySet()) {
                reportSet.setChecklist((Location)entry.getKey(), (Checklist)entry.getValue());
            }
            for (Map.Entry entry : this.visitInfos.entrySet()) {
                reportSet.putVisitInfo((VisitInfoKey)entry.getKey(), (VisitInfo)entry.getValue());
            }
            if (this.userSet != null) {
                reportSet.setUserSet(this.userSet);
            }
            reportSet.setOneTimeUpgrades(this.oneTimeUpgrades.build());
            reportSet.clearDirty();
            return reportSet;
        }

        @Override
        public NodeParser startChildElement(ParseContext context, String namespaceURI, String localName, Attributes attrs) throws SAXParseException {
            if ("locations".equals(localName)) {
                if (this.locations != null) {
                    throw new SAXParseException("Duplicate <locations> elements", context.getLocator());
                }
                return new LocationSetParser();
            }
            if ("trip".equals(localName)) {
                if (this.locations == null) {
                    throw new SAXParseException("Trips must come after locations", context.getLocator());
                }
                if (this.trips == null) {
                    this.trips = new Trips(this.locations);
                }
                return new TripParser(this.trips);
            }
            if ("sighting".equals(localName)) {
                if (this.locations == null) {
                    throw new SAXParseException("No <locations> element, or <sighting> element before <locations>", context.getLocator());
                }
                return new SightingsParser();
            }
            if ("checklist".equals(localName)) {
                return new ChecklistParser();
            }
            if ("prefs".equals(localName)) {
                return new StringParser();
            }
            if ("one-time-upgrade".equals(localName)) {
                return new StringParser();
            }
            if ("visit-info".equals(localName)) {
                return new VisitInfoParser();
            }
            if ("user".equals(localName)) {
                if (this.userSet == null) {
                    this.userSet = new UserSet();
                }
                return new UserParser();
            }
            if ("taxonomy".equals(localName)) {
                ExtendedTaxonomyNodeParser.startChecklistParsing(context);
                return new ExtendedTaxonomyNodeParser();
            }
            return null;
        }

        @Override
        public void startElement(ParseContext context, String namespaceURI, String localName, Attributes attrs) throws SAXParseException {
            String version = attrs.getValue("version");
            if (version != null && !Versions.versionOrdering().max(version, "19.0.0").equals("19.0.0")) {
                throw new VersionTooNewException(version);
            }
            this.version = version;
            this.sightings = new ArrayList<Sighting>(5000);
            String taxonomyId = attrs.getValue("taxonomy");
            if (taxonomyId == null) {
                taxonomyId = "clements6_4";
            }
            if (this.taxonomy.getId().equals(taxonomyId)) {
                this.taxonomyTracker = null;
            } else {
                try {
                    Preconditions.checkState(this.optionalMappedTaxonomy.isPresent(), "IOC taxonomy must be present during upgrades");
                    this.taxonomyTracker = this.mappings.getTracker(taxonomyId, this.optionalMappedTaxonomy.get());
                }
                catch (CsvValidationException | IOException e) {
                    throw new SAXParseException("Failed to load taxonomy updater", context.getLocator(), e);
                }
            }
        }

        SightingTaxon parseSightingTaxon(ParseContext context, Attributes attrs, ParseBehavior parseBehavior, Location location, Taxonomy sightingTaxonomy) throws SAXParseException {
            SightingTaxon sightingTaxon;
            boolean shouldWarn;
            boolean isCoreTaxonomy = sightingTaxonomy == this.taxonomy;
            String taxonId = attrs.getValue("taxon");
            boolean bl = shouldWarn = parseBehavior == ParseBehavior.WARN;
            if (taxonId != null) {
                if (isCoreTaxonomy && this.taxonomyTracker != null) {
                    sightingTaxon = this.taxonomyTracker.getTaxonId(taxonId, shouldWarn);
                    if (sightingTaxon.resolve(this.taxonomy) == null) {
                        throw new SAXParseException("Invalid mapping " + sightingTaxon, context.getLocator());
                    }
                    if (parseBehavior == ParseBehavior.DONT_WARN_AND_AGGRESSIVELY_RESOLVE && sightingTaxon.getType() == SightingTaxon.Type.SP) {
                        sightingTaxon = this.taxonomyTracker.getChecklistResolvedTaxonId(this.taxonomy, taxonId, location);
                    }
                } else {
                    Taxon taxon = sightingTaxonomy.getTaxon(taxonId);
                    if (taxon == null && "sspCarpo3davwal".equals(taxonId)) {
                        taxonId = "sspCarpo3eoswal";
                        taxon = this.taxonomy.getTaxon(taxonId);
                    }
                    if (taxon == null) {
                        throw new SAXParseException("Could not find taxon id " + taxonId, context.getLocator());
                    }
                    sightingTaxon = SightingTaxons.newSightingTaxon(taxonId);
                }
            } else {
                String uncertain = attrs.getValue("sp");
                if (uncertain == null) {
                    String hybrid = attrs.getValue("hybrid");
                    if (hybrid == null) {
                        String withSsp = attrs.getValue("taxonSsp");
                        if (withSsp == null) {
                            throw new SAXParseException("None of taxon, sp, hybrid, taxonWithSsp attributes found", context.getLocator());
                        }
                        ImmutableList<String> taxa = ImmutableList.copyOf(XmlReportSetExport.TAXON_WITH_SSP_SPLITTER.split(withSsp));
                        if (taxa.size() != 2) {
                            throw new SAXParseException("Invalid taxonWithSsp attribute: " + withSsp, context.getLocator());
                        }
                        sightingTaxon = SightingTaxons.newSightingTaxonWithSecondarySubspecies((String)taxa.get(0), (String)taxa.get(1));
                        if (isCoreTaxonomy && this.taxonomyTracker != null) {
                            sightingTaxon = this.taxonomyTracker.getTaxonIdOfSightingWithSsp(sightingTaxon, shouldWarn);
                        }
                    } else {
                        Iterable<String> mappedTaxa;
                        Iterable<String> taxa = XmlReportSetExport.HYBRID_SPLITTER.split(hybrid);
                        sightingTaxon = isCoreTaxonomy && this.taxonomyTracker != null ? (Iterables.size(mappedTaxa = this.taxonomyTracker.getTaxonId(this.taxonomy, taxa, shouldWarn)) == 1 ? SightingTaxons.newSightingTaxon(Iterables.getOnlyElement(mappedTaxa)) : SightingTaxons.newHybridTaxon(mappedTaxa)) : SightingTaxons.newHybridTaxon(taxa);
                    }
                } else {
                    Iterable<String> mappedTaxa;
                    Iterable<String> taxa = XmlReportSetExport.SP_SPLITTER.split(uncertain);
                    sightingTaxon = isCoreTaxonomy && this.taxonomyTracker != null ? (Iterables.size(mappedTaxa = this.taxonomyTracker.getTaxonId(this.taxonomy, taxa, shouldWarn)) == 1 ? SightingTaxons.newSightingTaxon(Iterables.getOnlyElement(mappedTaxa)) : SightingTaxons.newSpTaxon(mappedTaxa)) : SightingTaxons.newSpTaxon(taxa);
                }
            }
            return sightingTaxon;
        }

        Taxonomy findSightingTaxonomy(ParseContext context, Attributes attrs) throws SAXParseException {
            Taxonomy sightingTaxonomy;
            String taxonomyId = attrs.getValue("taxonomy");
            if (taxonomyId == null) {
                sightingTaxonomy = this.taxonomy;
            } else {
                sightingTaxonomy = this.extendedTaxonomies.get(taxonomyId);
                if (sightingTaxonomy == null) {
                    throw new SAXParseException("Invalid taxonomyId " + taxonomyId, context.getLocator());
                }
            }
            return sightingTaxonomy;
        }

        UserSet getUserSet() {
            if (this.userSet == null) {
                this.userSet = new UserSet();
            }
            return this.userSet;
        }

        private ImmutableSet<User> usersStringToUserSet(String usersString) {
            ImmutableSet.Builder users = ImmutableSet.builder();
            for (String userId : XmlReportSetExport.USER_SPLITTER.split(usersString)) {
                User user;
                try {
                    user = this.getUserSet().userById(userId);
                }
                catch (IllegalArgumentException e) {
                    user = this.getUserSet().addUser(this.getUserSet().newUserBuilderFromStorage(userId).setAbbreviation(userId));
                }
                users.add(user);
            }
            return users.build();
        }

        private Location getOrRestoreLocation(String locationId) {
            Location location;
            if (locationId == null) {
                location = null;
            } else {
                location = this.locations.getLocation(locationId);
                if (location == null) {
                    location = Location.builder().setName("RESTORED LOCATION \"" + locationId + "\"").build();
                    this.locations.addRestoredLocation(locationId, location);
                }
            }
            return location;
        }

        static class ChecklistAndLocation {
            public final Checklist checklist;
            public final Location location;

            public ChecklistAndLocation(Checklist checklist, Location location) {
                this.checklist = Preconditions.checkNotNull(checklist);
                this.location = Preconditions.checkNotNull(location);
            }
        }

        static class VisitInfoAndKey {
            final VisitInfo visitInfo;
            final VisitInfoKey key;

            public VisitInfoAndKey(VisitInfo visitInfo, VisitInfoKey key) {
                this.visitInfo = visitInfo;
                this.key = key;
            }
        }

        class TripParser
        extends BaseNodeParser {
            private final Trips.TripBuilder tripBuilder;
            private final ImmutableList.Builder<Link> links = ImmutableList.builder();

            public TripParser(Trips trips) {
                this.tripBuilder = trips.newTripBuilder();
            }

            @Override
            public void startElement(ParseContext context, String namespaceURI, String localName, Attributes attrs) throws SAXParseException {
                String name;
                String id = this.getRequiredAttribute(context, attrs, "id");
                this.tripBuilder.withId(id);
                String locationId = attrs.getValue("loc");
                if (!Strings.isNullOrEmpty(locationId)) {
                    ReportSetParser.this.getOrRestoreLocation(locationId);
                    this.tripBuilder.withLocationId(locationId);
                }
                String startDateStr = this.getRequiredAttribute(context, attrs, "startDate");
                this.tripBuilder.withStartDate(PartialIO.fromString(startDateStr));
                String startTimeStr = attrs.getValue("startTime");
                if (!Strings.isNullOrEmpty(startTimeStr)) {
                    this.tripBuilder.withStartTime(TimeIO.fromString(startTimeStr));
                }
                String endDateStr = this.getRequiredAttribute(context, attrs, "endDate");
                this.tripBuilder.withEndDate(PartialIO.fromString(endDateStr));
                String endTimeStr = attrs.getValue("endTime");
                if (!Strings.isNullOrEmpty(endTimeStr)) {
                    this.tripBuilder.withStartTime(TimeIO.fromString(endTimeStr));
                }
                if (!Strings.isNullOrEmpty(name = attrs.getValue("name"))) {
                    this.tripBuilder.withName(name);
                }
            }

            @Override
            public NodeParser startChildElement(ParseContext context, String namespaceURI, String localName, Attributes attrs) throws SAXParseException {
                if (localName.equals("notes")) {
                    return new StringParser();
                }
                if (localName.equals("link")) {
                    return new LinkParser();
                }
                return BaseNodeParser.getIgnoreParser();
            }

            @Override
            public void addCompletedChild(ParseContext context, String namespaceURI, String localName, Object child) throws SAXParseException {
                if (child instanceof String) {
                    String s = (String)child;
                    this.tripBuilder.withNotes(s);
                } else if (child instanceof Link) {
                    Link link = (Link)child;
                    this.links.add((Object)link);
                }
            }

            @Override
            public Object endElement(ParseContext context, String namespaceURI, String localName) throws SAXParseException {
                return this.tripBuilder.withLinks(this.links.build()).build();
            }
        }

        public class SightingsParser
        extends BaseNodeParser {
            private Sighting sighting;
            private StringBuilder description;
            private List<Photo> photos;

            @Override
            public void addText(ParseContext context, char[] text, int start, int length) throws SAXParseException {
                if (this.description == null) {
                    this.description = new StringBuilder();
                }
                this.description.append(text, start, length);
            }

            @Override
            public Object endElement(ParseContext context, String namespaceURI, String localName) throws SAXParseException {
                if (this.description != null) {
                    this.sighting.getSightingInfo().setDescription(CharMatcher.whitespace().trimTrailingFrom(this.description.toString()));
                }
                if (this.photos != null) {
                    this.sighting.getSightingInfo().setPhotos(this.photos);
                }
                return this.sighting;
            }

            @Override
            public void startElement(ParseContext context, String namespaceURI, String localName, Attributes attrs) throws SAXParseException {
                String users;
                String breedingId;
                String sightingStatusId;
                ApproximateNumber number;
                String countStr;
                String tripId;
                String timeStr;
                String dateStr;
                String locationId = attrs.getValue("loc");
                Location location = ReportSetParser.this.getOrRestoreLocation(locationId);
                Taxonomy sightingTaxonomy = ReportSetParser.this.findSightingTaxonomy(context, attrs);
                SightingTaxon sightingTaxon = ReportSetParser.this.parseSightingTaxon(context, attrs, ParseBehavior.WARN, location, sightingTaxonomy);
                Sighting.Builder sighting = Sighting.newBuilder().setTaxonomy(sightingTaxonomy).setTaxon(sightingTaxon);
                if (location != null) {
                    sighting.setLocation(location);
                }
                if ((dateStr = attrs.getValue("date")) != null) {
                    try {
                        ReadablePartial datePartial = XmlReportSetImport.dateFromStringWithCenturyFix(dateStr);
                        sighting.setDate(datePartial);
                    }
                    catch (IllegalArgumentException iae) {
                        this.logError(context, "Could not parse date " + dateStr, iae);
                    }
                }
                if ((timeStr = attrs.getValue("time")) != null) {
                    try {
                        LocalTime timePartial = TimeIO.fromString(timeStr);
                        sighting.setTime(timePartial);
                    }
                    catch (IllegalArgumentException iae) {
                        this.logError(context, "Could not parse time " + timeStr, iae);
                    }
                }
                if ((tripId = attrs.getValue("trip")) != null) {
                    Trip trip = ReportSetParser.this.trips.get(tripId);
                    if (trip == null) {
                        this.logWarning(context, "Could not find trip " + tripId);
                    } else {
                        sighting.setTrip(trip);
                    }
                }
                if ((countStr = attrs.getValue("count")) != null && (number = ApproximateNumber.tryParse(countStr)) != null) {
                    sighting.getSightingInfo().setNumber(number);
                }
                if ("true".equals(attrs.getValue("male"))) {
                    sighting.getSightingInfo().setMale(true);
                }
                if ("true".equals(attrs.getValue("female"))) {
                    sighting.getSightingInfo().setFemale(true);
                }
                if ("true".equals(attrs.getValue("immature"))) {
                    sighting.getSightingInfo().setImmature(true);
                }
                if ("true".equals(attrs.getValue("adult"))) {
                    sighting.getSightingInfo().setAdult(true);
                }
                if ("true".equals(attrs.getValue("photo"))) {
                    sighting.getSightingInfo().setPhotographed(true);
                }
                if ("true".equals(attrs.getValue("heardOnly"))) {
                    sighting.getSightingInfo().setHeardOnly(true);
                }
                if ((sightingStatusId = attrs.getValue("popStatus")) != null) {
                    SightingInfo.SightingStatus sightingStatus = SightingInfo.SightingStatus.forId(sightingStatusId);
                    if (sightingStatus == null) {
                        this.logWarning(context, "Invalid sighting status: " + sightingStatusId);
                    } else {
                        sighting.getSightingInfo().setSightingStatus(sightingStatus);
                    }
                }
                if ((breedingId = attrs.getValue("breeding")) != null) {
                    SightingInfo.BreedingBirdCode breedingCode = SightingInfo.BreedingBirdCode.forId(breedingId);
                    if (breedingCode == null) {
                        this.logWarning(context, "Invalid breeding code: " + breedingId);
                    } else {
                        sighting.getSightingInfo().setBreedingBirdCode(breedingCode);
                    }
                }
                if ((users = attrs.getValue("users")) != null) {
                    ImmutableSet<User> usersSet = ReportSetParser.this.usersCache.getUnchecked(users);
                    sighting.getSightingInfo().setUsers(usersSet);
                }
                this.sighting = sighting.build();
            }

            @Override
            public NodeParser startChildElement(ParseContext context, String namespaceURI, String localName, Attributes attrs) throws SAXParseException {
                if ("photo".equals(localName)) {
                    return new PhotoParser();
                }
                return super.startChildElement(context, namespaceURI, localName, attrs);
            }

            @Override
            public void addCompletedChild(ParseContext context, String namespaceURI, String localName, Object child) throws SAXParseException {
                if (child instanceof Photo) {
                    if (this.photos == null) {
                        this.photos = Lists.newArrayListWithCapacity(2);
                    }
                    this.photos.add((Photo)child);
                }
            }
        }

        class ChecklistParser
        extends BaseNodeParser {
            private final Map<SightingTaxon, Checklist.Status> taxa = Maps.newLinkedHashMap();
            private Location location;

            ChecklistParser() {
            }

            @Override
            public void startElement(ParseContext context, String namespaceURI, String localName, Attributes attrs) throws SAXParseException {
                String locId = this.getRequiredAttribute(context, attrs, "loc");
                this.location = ReportSetParser.this.locations.getLocation(locId);
                if (this.location == null) {
                    logger.warning("Unknown location " + locId + ";  can't parse checklist");
                }
            }

            @Override
            public Object endElement(ParseContext context, String namespaceURI, String localName) throws SAXParseException {
                if (this.location == null) {
                    return null;
                }
                ClementsChecklist clementsChecklist = new ClementsChecklist(this.taxa);
                return new ChecklistAndLocation(clementsChecklist, this.location);
            }

            @Override
            public NodeParser startChildElement(ParseContext context, String namespaceURI, String localName, Attributes attrs) throws SAXParseException {
                if ("entry".equals(localName)) {
                    Taxonomy sightingTaxonomy = ReportSetParser.this.findSightingTaxonomy(context, attrs);
                    SightingTaxon sightingTaxon = ReportSetParser.this.parseSightingTaxon(context, attrs, ParseBehavior.DONT_WARN_AND_AGGRESSIVELY_RESOLVE, this.location, sightingTaxonomy);
                    Checklist.Status status = Checklist.Status.NATIVE;
                    String statusText = attrs.getValue("status");
                    if (statusText != null && STATUS_TEXT.containsKey(statusText)) {
                        status = STATUS_TEXT.get(statusText);
                    }
                    this.taxa.put(sightingTaxon, status);
                    return BaseNodeParser.getIgnoreParser();
                }
                return super.startChildElement(context, namespaceURI, localName, attrs);
            }
        }

        class VisitInfoParser
        extends BaseNodeParser {
            private VisitInfoKey key;
            private VisitInfo.Builder visitInfo;
            private ImmutableList.Builder<Photo> photos;

            VisitInfoParser() {
            }

            @Override
            public void startElement(ParseContext context, String namespaceURI, String localName, Attributes attrs) throws SAXParseException {
                String locId = this.getRequiredAttribute(context, attrs, "loc");
                Location location = ReportSetParser.this.locations.getLocation(locId);
                if (location == null) {
                    logger.warning("Unknown location " + locId + ";  can't parse checklist");
                }
                String dateStr = this.getRequiredAttribute(context, attrs, "date");
                ReadablePartial date = XmlReportSetImport.dateFromStringWithCenturyFix(dateStr);
                String timeStr = attrs.getValue("time");
                LocalTime time = Strings.isNullOrEmpty(timeStr) ? null : TimeIO.fromString(timeStr);
                this.key = new VisitInfoKey(locId, date, time);
                this.visitInfo = VisitInfo.builder();
                String observationTypeStr = this.getRequiredAttribute(context, attrs, "observationType");
                VisitInfo.ObservationType observationType = VisitInfo.ObservationType.fromId(observationTypeStr);
                if (observationType == null) {
                    logger.warning("Unknown observationType " + observationTypeStr);
                    observationType = VisitInfo.ObservationType.HISTORICAL;
                }
                if (!this.key.startTime().isPresent() && observationType.getRequiredFields().contains((Object)VisitInfo.VisitField.START_TIME)) {
                    observationType = VisitInfo.ObservationType.HISTORICAL;
                }
                this.visitInfo.withObservationType(observationType);
            }

            @Override
            public Object endElement(ParseContext context, String namespaceURI, String localName) throws SAXParseException {
                VisitInfo built;
                if (this.visitInfo == null) {
                    return null;
                }
                if (this.photos != null) {
                    this.visitInfo.withPhotos(this.photos.build());
                }
                try {
                    built = this.visitInfo.build();
                }
                catch (IllegalStateException e) {
                    logger.log(Level.WARNING, "Couldn't build visit info; using historical", e);
                    this.visitInfo.withObservationType(VisitInfo.ObservationType.HISTORICAL);
                    built = this.visitInfo.build();
                }
                return new VisitInfoAndKey(built, this.key);
            }

            @Override
            public NodeParser startChildElement(ParseContext context, String namespaceURI, String localName, Attributes attrs) throws SAXParseException {
                if (this.visitInfo == null) {
                    return BaseNodeParser.getIgnoreParser();
                }
                if ("area".equals(localName)) {
                    return new StringParser();
                }
                if ("distance".equals(localName)) {
                    return new StringParser();
                }
                if ("duration".equals(localName)) {
                    return new StringParser();
                }
                if ("partySize".equals(localName)) {
                    return new StringParser();
                }
                if ("comments".equals(localName)) {
                    return new StringParser();
                }
                if ("complete".equals(localName)) {
                    this.visitInfo.withCompleteChecklist(true);
                    return BaseNodeParser.getIgnoreParser();
                }
                if ("photo".equals(localName)) {
                    return new PhotoParser();
                }
                return super.startChildElement(context, namespaceURI, localName, attrs);
            }

            @Override
            public void addCompletedChild(ParseContext context, String namespaceURI, String localName, Object child) throws SAXParseException {
                if (this.visitInfo == null) {
                    return;
                }
                if (child instanceof Photo) {
                    Photo photo = (Photo)child;
                    if (this.photos == null) {
                        this.photos = ImmutableList.builder();
                    }
                    this.photos.add((Object)photo);
                    return;
                }
                String string = (String)child;
                if (string != null) {
                    string = CharMatcher.whitespace().trimFrom(string);
                }
                if ("area".equals(localName)) {
                    Float parsed = Floats.tryParse(string);
                    if (parsed != null && parsed.floatValue() > 0.0f) {
                        this.visitInfo.withArea(Area.inHectares(parsed.floatValue()));
                    }
                } else if ("distance".equals(localName)) {
                    Float parsed = Floats.tryParse(string);
                    if (parsed != null && parsed.floatValue() > 0.0f) {
                        this.visitInfo.withDistance(Distance.inKilometers(parsed.floatValue()));
                    }
                } else if ("duration".equals(localName)) {
                    Integer parsed = Ints.tryParse(string);
                    if (parsed != null && parsed > 0) {
                        this.visitInfo.withDuration(Duration.standardMinutes(parsed.intValue()));
                    }
                } else if ("partySize".equals(localName)) {
                    Integer parsed = Ints.tryParse(string);
                    if (parsed != null && parsed > 0) {
                        this.visitInfo.withPartySize(parsed);
                    }
                } else if ("comments".equals(localName) && !string.isEmpty()) {
                    this.visitInfo.withComments(string);
                }
            }
        }

        class UserParser
        extends BaseNodeParser {
            private User.Builder builder;

            UserParser() {
            }

            @Override
            public void startElement(ParseContext context, String namespaceURI, String localName, Attributes attrs) throws SAXParseException {
                String abbreviation;
                String id = this.getRequiredAttribute(context, attrs, "id");
                this.builder = ReportSetParser.this.getUserSet().newUserBuilderFromStorage(id);
                String name = attrs.getValue("name");
                if (name != null) {
                    this.builder.setName(name);
                }
                if ((abbreviation = attrs.getValue("abbrev")) != null) {
                    this.builder.setAbbreviation(abbreviation);
                }
            }

            @Override
            public Object endElement(ParseContext context, String namespaceURI, String localName) throws SAXParseException {
                ReportSetParser.this.getUserSet().addUser(this.builder);
                return null;
            }
        }

        static enum ParseBehavior {
            WARN,
            DONT_WARN_AND_AGGRESSIVELY_RESOLVE;

        }

        public class LinkParser
        extends BaseNodeParser {
            private StringBuilder buffer = new StringBuilder();
            private String name;

            @Override
            public void startElement(ParseContext context, String namespaceURI, String localName, Attributes attrs) throws SAXParseException {
                this.name = attrs.getValue("name");
            }

            @Override
            public Object endElement(ParseContext context, String namespaceURI, String localName) throws SAXParseException {
                URI uri;
                try {
                    uri = new URI(this.buffer.toString());
                }
                catch (URISyntaxException e) {
                    logger.log(Level.SEVERE, "Could not parse photo " + this.buffer, e);
                    return null;
                }
                Link link = new Link(uri);
                if (this.name != null) {
                    link.setName(this.name);
                }
                return link;
            }

            @Override
            public void addText(ParseContext context, char[] text, int start, int length) throws SAXParseException {
                this.buffer.append(text, start, length);
            }
        }

        public class PhotoParser
        extends BaseNodeParser {
            private boolean favorite;
            private StringBuilder buffer = new StringBuilder();
            private String name;

            @Override
            public void startElement(ParseContext context, String namespaceURI, String localName, Attributes attrs) throws SAXParseException {
                this.favorite = "true".equals(attrs.getValue("favorite"));
                this.name = attrs.getValue("name");
            }

            @Override
            public Object endElement(ParseContext context, String namespaceURI, String localName) throws SAXParseException {
                URI uri;
                try {
                    uri = new URI(this.buffer.toString());
                }
                catch (URISyntaxException e) {
                    logger.log(Level.SEVERE, "Could not parse photo " + this.buffer, e);
                    return null;
                }
                Photo photo = new Photo(uri, this.favorite);
                if (this.name != null) {
                    photo.setName(this.name);
                }
                return photo;
            }

            @Override
            public void addText(ParseContext context, char[] text, int start, int length) throws SAXParseException {
                this.buffer.append(text, start, length);
            }
        }
    }

    public static class LocationParser
    extends BaseNodeParser {
        private Location location;
        private final Location.Type type;
        private final Location parent;
        private final LocationSet.Builder locations;

        public LocationParser(Location.Type type, Location parent, LocationSet.Builder locationsBuilder) {
            this.type = type;
            this.parent = parent;
            this.locations = locationsBuilder;
        }

        @Override
        public NodeParser startChildElement(ParseContext context, String namespaceURI, String localName, Attributes attrs) throws SAXParseException {
            return XmlReportSetImport.getLocationParser(localName, this.location, this.locations);
        }

        @Override
        public void startElement(ParseContext context, String namespaceURI, String localName, Attributes attrs) throws SAXParseException {
            Location previousChild;
            String id = this.getRequiredAttribute(context, attrs, "id");
            String name = this.getRequiredAttribute(context, attrs, "name");
            if (name.isEmpty()) {
                name = "(Unnamed)";
            }
            if (this.parent != null && (previousChild = this.parent.getContent(name)) != null) {
                for (int i = 0; i < 10; ++i) {
                    String duplicateName = this.duplicateName(name, i);
                    if (this.parent.getContent(duplicateName) != null) continue;
                    name = duplicateName;
                    break;
                }
            }
            Location.Builder locationBuilder = Location.builder().setName(name).setType(this.type).setParent(this.parent);
            String ebirdCode = attrs.getValue("ebirdCode");
            if (ebirdCode != null) {
                locationBuilder.setEbirdCode(ebirdCode);
            }
            String latitude = attrs.getValue("lat");
            String longitude = attrs.getValue("long");
            if (latitude != null && longitude != null) {
                try {
                    LatLongCoordinates latLong = LatLongCoordinates.withLatAndLong(latitude, longitude);
                    locationBuilder.setLatLong(latLong);
                }
                catch (IllegalArgumentException e) {
                    logger.warning(String.format("Invalid lat/long: %s, %s", latitude, longitude));
                }
            }
            if ("true".equals(attrs.getValue("private"))) {
                locationBuilder.setPrivate(true);
            }
            this.location = locationBuilder.build();
            this.locations.addLocation(this.location, id);
        }

        private String duplicateName(String name, int i) {
            if (!((String)name).endsWith(" duplicate")) {
                name = (String)name + " duplicate";
            }
            if (i == 0) {
                return name;
            }
            return (String)name + " " + i;
        }

        @Override
        public void addCompletedChild(ParseContext context, String namespaceURI, String localName, Object child) throws SAXParseException {
            if (child instanceof String) {
                Location locationWithDescription = this.location.asBuilder().setDescription((String)child).build();
                this.locations.replace(this.location, locationWithDescription);
                this.location = locationWithDescription;
            }
        }

        @Override
        public Object endElement(ParseContext context, String namespaceURI, String localName) throws SAXParseException {
            return this.location;
        }
    }

    public static class LocationSetParser
    extends BaseNodeParser {
        private LocationSet.Builder locationsBuilder;

        @Override
        public Object endElement(ParseContext context, String namespaceURI, String localName) throws SAXParseException {
            return this.locationsBuilder.build();
        }

        @Override
        public void startElement(ParseContext context, String namespaceURI, String localName, Attributes attrs) throws SAXParseException {
            this.locationsBuilder = new LocationSet.Builder();
        }

        @Override
        public NodeParser startChildElement(ParseContext context, String namespaceURI, String localName, Attributes attrs) throws SAXParseException {
            return XmlReportSetImport.getLocationParser(localName, null, this.locationsBuilder);
        }
    }
}

