/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.model.xml;

import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import com.scythebill.birdlist.model.checklist.Checklist;
import com.scythebill.birdlist.model.checklist.ClementsChecklist;
import com.scythebill.birdlist.model.io.IndentingResponseWriter;
import com.scythebill.birdlist.model.io.PartialIO;
import com.scythebill.birdlist.model.io.ResponseWriter;
import com.scythebill.birdlist.model.io.TimeIO;
import com.scythebill.birdlist.model.io.XmlResponseWriter;
import com.scythebill.birdlist.model.sighting.Link;
import com.scythebill.birdlist.model.sighting.Location;
import com.scythebill.birdlist.model.sighting.Photo;
import com.scythebill.birdlist.model.sighting.ReportSet;
import com.scythebill.birdlist.model.sighting.Sighting;
import com.scythebill.birdlist.model.sighting.SightingInfo;
import com.scythebill.birdlist.model.sighting.SightingTaxon;
import com.scythebill.birdlist.model.sighting.Trip;
import com.scythebill.birdlist.model.sighting.VisitInfo;
import com.scythebill.birdlist.model.sighting.VisitInfoKey;
import com.scythebill.birdlist.model.taxa.Taxonomy;
import com.scythebill.birdlist.model.user.User;
import com.scythebill.birdlist.model.xml.XmlTaxonExport;
import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.LocalTime;
import org.joda.time.ReadablePartial;

public class XmlReportSetExport {
    static final String ATTRIBUTE_VERSION = "version";
    static final String ATTRIBUTE_TAXONOMY_ID = "taxonomy";
    static final String ATTRIBUTE_NAME = "name";
    static final String ATTRIBUTE_ID = "id";
    static final String ATTRIBUTE_EBIRD_CODE = "ebirdCode";
    static final String ELEMENT_STATE = "state";
    static final String ELEMENT_REGION = "region";
    static final String ELEMENT_COUNTY = "county";
    static final String ELEMENT_COUNTRY = "country";
    static final String ELEMENT_CITY = "city";
    static final String ELEMENT_TOWN = "town";
    static final String ELEMENT_PARK = "park";
    static final String ELEMENT_LOCATION = "location";
    static final String ELEMENT_PREFS = "prefs";
    static final String ELEMENT_DESCRIPTION = "description";
    static final String ATTRIBUTE_ADULT = "adult";
    static final String ATTRIBUTE_HEARD_ONLY = "heardOnly";
    static final String ATTRIBUTE_IMMATURE = "immature";
    static final String ATTRIBUTE_FEMALE = "female";
    static final String ATTRIBUTE_MALE = "male";
    static final String ATTRIBUTE_COUNT = "count";
    static final String ATTRIBUTE_DATE = "date";
    static final String ATTRIBUTE_TIME = "time";
    static final String ATTRIBUTE_TRIP = "trip";
    static final String ATTRIBUTE_LOCATION = "loc";
    static final String ATTRIBUTE_LATITUDE = "lat";
    static final String ATTRIBUTE_LONGITUDE = "long";
    static final String ELEMENT_TRIP = "trip";
    static final String ELEMENT_LINK = "link";
    static final String ATTRIBUTE_START_DATE = "startDate";
    static final String ATTRIBUTE_START_TIME = "startTime";
    static final String ATTRIBUTE_END_DATE = "endDate";
    static final String ATTRIBUTE_END_TIME = "endTime";
    static final String ELEMENT_NOTES = "notes";
    static final String ATTRIBUTE_TAXON = "taxon";
    static final String ATTRIBUTE_SP = "sp";
    static final String ATTRIBUTE_HYBRID = "hybrid";
    static final String ATTRIBUTE_TAXON_WITH_SSP = "taxonSsp";
    static final String ATTRIBUTE_USERS = "users";
    static final String ATTRIBUTE_SIGHTING_STATUS = "popStatus";
    static final String ATTRIBUTE_BREEDING_CODE = "breeding";
    static final String ATTRIBUTE_PHOTOGRAPHED = "photo";
    static final String ATTRIBUTE_PRIVATE = "private";
    static final String ELEMENT_SIGHTING = "sighting";
    static final String ELEMENT_PHOTO = "photo";
    static final String ATTRIBUTE_FAVORITE = "favorite";
    static final String ELEMENT_LOCATIONS = "locations";
    static final String ELEMENT_REPORT_SET = "report-set";
    static final String ELEMENT_CHECKLIST = "checklist";
    static final String ELEMENT_CHECKLIST_ENTRY = "entry";
    static final String ATTRIBUTE_CHECKLIST_STATUS = "status";
    static final String ELEMENT_VISIT_INFO = "visit-info";
    static final String ELEMENT_USER = "user";
    static final String ATTRIBUTE_OBSERVATION_TYPE = "observationType";
    static final String ELEMENT_DISTANCE = "distance";
    static final String ELEMENT_DURATION = "duration";
    static final String ELEMENT_AREA = "area";
    static final String ELEMENT_PARTY_SIZE = "partySize";
    static final String ELEMENT_COMPLETE = "complete";
    static final String ELEMENT_COMMENT = "comments";
    static final String ATTRIBUTE_ABBREVIATION = "abbrev";
    static final String ELEMENT_ONE_TIME_UPGRADE = "one-time-upgrade";
    static final char SP_SEPARATOR = ',';
    static final Splitter SP_SPLITTER;
    static final Splitter HYBRID_SPLITTER;
    static final Joiner SP_JOINER;
    static final Joiner HYBRID_JOINER;
    static final char TAXON_WITH_SSP_SEPARATOR = '|';
    static final Splitter TAXON_WITH_SSP_SPLITTER;
    static final Joiner TAXON_WITH_SSP_JOINER;
    static final char USER_SEPARATOR = ',';
    static final Splitter USER_SPLITTER;

    public void export(Writer out, String encoding, ReportSet reports, Taxonomy taxonomy) throws IOException {
        ResponseWriter rw = new XmlResponseWriter(out, encoding);
        rw = new IndentingResponseWriter(rw);
        rw.startDocument();
        rw.startElement(ELEMENT_REPORT_SET);
        rw.writeAttribute(ATTRIBUTE_VERSION, "19.0.0");
        rw.writeAttribute(ATTRIBUTE_TAXONOMY_ID, taxonomy.getId());
        for (Taxonomy taxonomy2 : reports.extendedTaxonomies()) {
            new XmlTaxonExport().withChecklists(reports.getExtendedTaxonomyChecklist(taxonomy2.getId())).writeTaxonomy(taxonomy2, rw);
        }
        rw.startElement(ELEMENT_LOCATIONS);
        this.writeLocations(rw, reports.getLocations().rootLocations());
        rw.endElement(ELEMENT_LOCATIONS);
        if (reports.getUserSet() != null) {
            for (User user : reports.getUserSet().allUsers()) {
                rw.startElement(ELEMENT_USER);
                rw.writeAttribute(ATTRIBUTE_ID, user.id());
                if (user.name() != null) {
                    rw.writeAttribute(ATTRIBUTE_NAME, user.name());
                }
                if (user.abbreviation() != null) {
                    rw.writeAttribute(ATTRIBUTE_ABBREVIATION, user.abbreviation());
                }
                rw.endElement(ELEMENT_USER);
            }
        }
        for (Trip trip : reports.getTrips().allTrips()) {
            rw.startElement("trip");
            rw.writeAttribute(ATTRIBUTE_ID, trip.id());
            if (trip.locationId() != null) {
                rw.writeAttribute(ATTRIBUTE_LOCATION, trip.locationId());
            }
            rw.writeAttribute(ATTRIBUTE_START_DATE, PartialIO.toString(trip.startDate()));
            if (trip.startTime() != null) {
                rw.writeAttribute(ATTRIBUTE_START_TIME, TimeIO.toString(trip.startTime()));
            }
            rw.writeAttribute(ATTRIBUTE_END_DATE, PartialIO.toString(trip.endDate()));
            if (trip.endTime() != null) {
                rw.writeAttribute(ATTRIBUTE_END_TIME, trip.endTime());
            }
            if (!Strings.isNullOrEmpty(trip.name())) {
                rw.writeAttribute(ATTRIBUTE_NAME, trip.name());
            }
            if (!Strings.isNullOrEmpty(trip.notes())) {
                rw.startElement(ELEMENT_NOTES);
                rw.writeText(trip.notes());
                rw.endElement(ELEMENT_NOTES);
            }
            for (Link link : trip.links()) {
                rw.startElement(ELEMENT_LINK);
                String name = link.getName();
                if (name != null) {
                    rw.writeAttribute(ATTRIBUTE_NAME, name);
                }
                rw.writeText(link.getUri().toString());
                rw.endElement(ELEMENT_LINK);
            }
            rw.endElement("trip");
        }
        this.writeSightings(rw, reports.getSightings(), taxonomy);
        for (Map.Entry entry : reports.checklists().entrySet()) {
            rw.startElement(ELEMENT_CHECKLIST);
            rw.writeAttribute(ATTRIBUTE_LOCATION, entry.getKey());
            ClementsChecklist clementsChecklist = (ClementsChecklist)entry.getValue();
            for (Map.Entry checklistEntry : clementsChecklist.baseChecklistMap().entrySet()) {
                rw.startElement(ELEMENT_CHECKLIST_ENTRY);
                this.writeSightingTaxon(rw, (SightingTaxon)checklistEntry.getKey());
                String statusText = ((Checklist.Status)((Object)checklistEntry.getValue())).text();
                if (statusText != null) {
                    rw.writeAttribute(ATTRIBUTE_CHECKLIST_STATUS, statusText);
                }
                rw.endElement(ELEMENT_CHECKLIST_ENTRY);
            }
            rw.endElement(ELEMENT_CHECKLIST);
        }
        for (Map.Entry entry : reports.visitInfos().entrySet()) {
            long standardMinutes;
            rw.startElement(ELEMENT_VISIT_INFO);
            VisitInfoKey key = (VisitInfoKey)entry.getKey();
            rw.writeAttribute(ATTRIBUTE_LOCATION, key.locationId());
            rw.writeAttribute(ATTRIBUTE_DATE, PartialIO.toString(key.date()));
            Optional<LocalTime> optional = key.startTime();
            if (optional.isPresent()) {
                rw.writeAttribute(ATTRIBUTE_TIME, TimeIO.toString(optional.get()));
            }
            VisitInfo visitInfo = (VisitInfo)entry.getValue();
            rw.writeAttribute(ATTRIBUTE_OBSERVATION_TYPE, visitInfo.observationType().id());
            if (visitInfo.area().isPresent()) {
                rw.startElement(ELEMENT_AREA);
                rw.writeText(Float.valueOf(visitInfo.area().get().hectares()));
                rw.endElement(ELEMENT_AREA);
            }
            if (visitInfo.distance().isPresent()) {
                rw.startElement(ELEMENT_DISTANCE);
                rw.writeText(Float.valueOf(visitInfo.distance().get().kilometers()));
                rw.endElement(ELEMENT_DISTANCE);
            }
            if (visitInfo.duration().isPresent() && (standardMinutes = visitInfo.duration().get().getStandardMinutes()) > 0L) {
                rw.startElement(ELEMENT_DURATION);
                rw.writeText(visitInfo.duration().get().getStandardMinutes());
                rw.endElement(ELEMENT_DURATION);
            }
            if (visitInfo.partySize().isPresent()) {
                rw.startElement(ELEMENT_PARTY_SIZE);
                rw.writeText(visitInfo.partySize().get());
                rw.endElement(ELEMENT_PARTY_SIZE);
            }
            if (visitInfo.comments().isPresent()) {
                rw.startElement(ELEMENT_COMMENT);
                rw.writeText(visitInfo.comments().get());
                rw.endElement(ELEMENT_COMMENT);
            }
            if (visitInfo.completeChecklist()) {
                rw.startElement(ELEMENT_COMPLETE);
                rw.endElement(ELEMENT_COMPLETE);
            }
            for (Photo photo : visitInfo.photos()) {
                String name;
                rw.startElement("photo");
                if (photo.isFavorite()) {
                    rw.writeAttribute(ATTRIBUTE_FAVORITE, Boolean.TRUE);
                }
                if ((name = photo.getName()) != null) {
                    rw.writeAttribute(ATTRIBUTE_NAME, name);
                }
                rw.writeText(photo.getUri().toString());
                rw.endElement("photo");
            }
            rw.endElement(ELEMENT_VISIT_INFO);
        }
        if (!StringUtils.isEmpty(reports.getPreferencesJson())) {
            rw.startElement(ELEMENT_PREFS);
            rw.writeText(reports.getPreferencesJson());
            rw.endElement(ELEMENT_PREFS);
        }
        for (String string : reports.oneTimeUpgrades()) {
            rw.startElement(ELEMENT_ONE_TIME_UPGRADE);
            rw.writeText(string);
            rw.endElement(ELEMENT_ONE_TIME_UPGRADE);
        }
        rw.endElement(ELEMENT_REPORT_SET);
        rw.endDocument();
        rw.flush();
    }

    private void writeSightings(ResponseWriter rw, Collection<Sighting> sightings, Taxonomy coreTaxonomy) throws IOException {
        for (Sighting sighting : sightings) {
            String description;
            ImmutableSet<User> users;
            Trip trip;
            LocalTime timeAsPartial;
            ReadablePartial dateAsPartial;
            rw.startElement(ELEMENT_SIGHTING);
            if (sighting.getTaxonomy() != coreTaxonomy) {
                rw.writeAttribute(ATTRIBUTE_TAXONOMY_ID, sighting.getTaxonomy().getId());
            }
            this.writeSightingTaxon(rw, sighting.getTaxon());
            if (sighting.getLocationId() != null) {
                rw.writeAttribute(ATTRIBUTE_LOCATION, sighting.getLocationId());
            }
            if ((dateAsPartial = sighting.getStoredDateAsPartial()) != null) {
                String formattedDate = PartialIO.toString(dateAsPartial);
                rw.writeAttribute(ATTRIBUTE_DATE, formattedDate);
            }
            if ((timeAsPartial = sighting.getStoredTimeAsPartial()) != null) {
                String formattedTime = TimeIO.toString(timeAsPartial);
                rw.writeAttribute(ATTRIBUTE_TIME, formattedTime);
            }
            if ((trip = sighting.getTrip()) != null) {
                rw.writeAttribute("trip", trip.id());
            }
            if (sighting.getSightingInfo().getNumber() != null) {
                rw.writeAttribute(ATTRIBUTE_COUNT, sighting.getSightingInfo().getNumber());
            }
            if (sighting.getSightingInfo().isMale()) {
                rw.writeAttribute(ATTRIBUTE_MALE, Boolean.TRUE);
            }
            if (sighting.getSightingInfo().isFemale()) {
                rw.writeAttribute(ATTRIBUTE_FEMALE, Boolean.TRUE);
            }
            if (sighting.getSightingInfo().isImmature()) {
                rw.writeAttribute(ATTRIBUTE_IMMATURE, Boolean.TRUE);
            }
            if (sighting.getSightingInfo().isAdult()) {
                rw.writeAttribute(ATTRIBUTE_ADULT, Boolean.TRUE);
            }
            if (sighting.getSightingInfo().isHeardOnly()) {
                rw.writeAttribute(ATTRIBUTE_HEARD_ONLY, Boolean.TRUE);
            }
            if (sighting.getSightingInfo().isPhotographed()) {
                rw.writeAttribute("photo", Boolean.TRUE);
            }
            if (sighting.getSightingInfo().getSightingStatus() != SightingInfo.SightingStatus.NONE) {
                rw.writeAttribute(ATTRIBUTE_SIGHTING_STATUS, sighting.getSightingInfo().getSightingStatus().getId());
            }
            if (sighting.getSightingInfo().getBreedingBirdCode() != SightingInfo.BreedingBirdCode.NONE) {
                rw.writeAttribute(ATTRIBUTE_BREEDING_CODE, sighting.getSightingInfo().getBreedingBirdCode().getId());
            }
            if (!(users = sighting.getSightingInfo().getUsers()).isEmpty()) {
                rw.writeAttribute(ATTRIBUTE_USERS, this.userIdsAsString(users));
            }
            if ((description = sighting.getSightingInfo().getDescription()) != null) {
                rw.writeText(description);
            }
            for (Photo photo : sighting.getSightingInfo().getPhotos()) {
                String name;
                rw.startElement("photo");
                if (photo.isFavorite()) {
                    rw.writeAttribute(ATTRIBUTE_FAVORITE, Boolean.TRUE);
                }
                if ((name = photo.getName()) != null) {
                    rw.writeAttribute(ATTRIBUTE_NAME, name);
                }
                rw.writeText(photo.getUri().toString());
                rw.endElement("photo");
            }
            rw.endElement(ELEMENT_SIGHTING);
        }
    }

    private String userIdsAsString(Collection<User> users) {
        StringBuilder builder = new StringBuilder(users.size() * 5);
        for (User user : users) {
            String id;
            if (builder.length() > 0) {
                builder.append(',');
            }
            if ((id = user.id()).indexOf(44) >= 0) {
                throw new IllegalStateException("ID of " + user + " contains a comma");
            }
            builder.append(id);
        }
        return builder.toString();
    }

    public void writeSightingTaxon(ResponseWriter rw, SightingTaxon sightingTaxon) throws IOException {
        switch (sightingTaxon.getType()) {
            case SINGLE: {
                rw.writeAttribute(ATTRIBUTE_TAXON, sightingTaxon.getId());
                break;
            }
            case SINGLE_WITH_SECONDARY_SUBSPECIES: {
                rw.writeAttribute(ATTRIBUTE_TAXON_WITH_SSP, TAXON_WITH_SSP_JOINER.join(sightingTaxon.getId(), sightingTaxon.getSubIdentifier(), new Object[0]));
                break;
            }
            case SP: {
                rw.writeAttribute(ATTRIBUTE_SP, SP_JOINER.join(sightingTaxon.getIds()));
                break;
            }
            case HYBRID: {
                rw.writeAttribute(ATTRIBUTE_HYBRID, HYBRID_JOINER.join(sightingTaxon.getIds()));
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected type: " + sightingTaxon.getType());
            }
        }
    }

    private void writeLocations(ResponseWriter rw, Collection<Location> locations) throws IOException {
        for (Location location : locations) {
            String element;
            if (location.getType() == null) {
                element = ELEMENT_LOCATION;
            } else {
                switch (location.getType()) {
                    case city: {
                        element = ELEMENT_CITY;
                        break;
                    }
                    case town: {
                        element = ELEMENT_TOWN;
                        break;
                    }
                    case country: {
                        element = ELEMENT_COUNTRY;
                        break;
                    }
                    case county: {
                        element = ELEMENT_COUNTY;
                        break;
                    }
                    case region: {
                        element = ELEMENT_REGION;
                        break;
                    }
                    case park: {
                        element = ELEMENT_PARK;
                        break;
                    }
                    case state: {
                        element = ELEMENT_STATE;
                        break;
                    }
                    default: {
                        element = ELEMENT_LOCATION;
                    }
                }
            }
            rw.startElement(element);
            rw.writeAttribute(ATTRIBUTE_ID, location.getId());
            rw.writeAttribute(ATTRIBUTE_NAME, location.getModelName());
            if (!Strings.isNullOrEmpty(location.getEbirdCode())) {
                rw.writeAttribute(ATTRIBUTE_EBIRD_CODE, location.getEbirdCode());
            }
            if (location.getLatLong().isPresent()) {
                rw.writeAttribute(ATTRIBUTE_LATITUDE, location.getLatLong().get().latitude());
                rw.writeAttribute(ATTRIBUTE_LONGITUDE, location.getLatLong().get().longitude());
            }
            if (location.isPrivate()) {
                rw.writeAttribute(ATTRIBUTE_PRIVATE, Boolean.TRUE);
            }
            if (location.getDescription() != null) {
                rw.startElement(ELEMENT_DESCRIPTION);
                rw.writeText(location.getDescription());
                rw.endElement(ELEMENT_DESCRIPTION);
            }
            this.writeLocations(rw, location.contents());
            rw.endElement(element);
        }
    }

    static {
        HYBRID_SPLITTER = SP_SPLITTER = Splitter.on(',');
        HYBRID_JOINER = SP_JOINER = Joiner.on(',');
        TAXON_WITH_SSP_SPLITTER = Splitter.on('|');
        TAXON_WITH_SSP_JOINER = Joiner.on('|');
        USER_SPLITTER = Splitter.on(',');
    }
}

