/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.model.xml;

import com.google.common.collect.TreeMultimap;
import com.scythebill.birdlist.model.checklist.Checklist;
import com.scythebill.birdlist.model.sighting.SightingTaxon;
import com.scythebill.birdlist.model.taxa.Taxonomy;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ExtendedTaxonomyParsing {
    private static final Pattern CHECKLIST_WITH_STATUS = Pattern.compile("(.*)\\((.*)\\)");

    private ExtendedTaxonomyParsing() {
    }

    public static TreeMultimap<String, String> buildTransposedChecklistWithStatuses(Map<String, Checklist> checklistsByLocationCode, Taxonomy taxonomy) {
        TreeMultimap<String, String> transposedChecklists = TreeMultimap.create();
        for (String locationCode : checklistsByLocationCode.keySet()) {
            Checklist checklist = checklistsByLocationCode.get(locationCode);
            for (SightingTaxon taxon : checklist.getTaxa(taxonomy)) {
                Checklist.Status status = checklist.getStatus(taxonomy, taxon);
                transposedChecklists.put((Object)taxon.getId(), switch (status) {
                    case Checklist.Status.NATIVE -> locationCode;
                    case Checklist.Status.ENDEMIC -> locationCode + "(E)";
                    case Checklist.Status.ESCAPED -> locationCode + "(ES)";
                    case Checklist.Status.EXTINCT -> locationCode + "(EX)";
                    case Checklist.Status.RARITY -> locationCode + "(R)";
                    case Checklist.Status.RARITY_FROM_INTRODUCED -> locationCode + "(RI)";
                    case Checklist.Status.INTRODUCED -> locationCode + "(I)";
                    default -> throw new AssertionError((Object)("Unexpected status " + status));
                });
            }
        }
        return transposedChecklists;
    }

    public static LocationAndStatus locationAndStatus(String locationCodeWithStatus) {
        String statusString;
        Matcher matcher = CHECKLIST_WITH_STATUS.matcher(locationCodeWithStatus);
        if (!matcher.matches()) {
            return new LocationAndStatus(locationCodeWithStatus);
        }
        String locationCode = matcher.group(1);
        return new LocationAndStatus(locationCode, switch (statusString = matcher.group(2)) {
            case "I" -> Checklist.Status.INTRODUCED;
            case "ES" -> Checklist.Status.ESCAPED;
            case "EX" -> Checklist.Status.EXTINCT;
            case "R", "V" -> Checklist.Status.RARITY;
            case "RI" -> Checklist.Status.RARITY_FROM_INTRODUCED;
            case "E" -> Checklist.Status.ENDEMIC;
            default -> Checklist.Status.NATIVE;
        });
    }

    public record LocationAndStatus(String locationCode, Checklist.Status status) {
        public LocationAndStatus {
            Objects.requireNonNull(locationCode);
        }

        public LocationAndStatus(String locationCode) {
            this(locationCode, Checklist.Status.NATIVE);
        }
    }
}

