/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.model.util;

import com.google.common.collect.Sets;
import java.util.Comparator;
import java.util.TreeSet;

public class WordSeparator {
    private static final int MAX_LENGTH_TO_SPLIT = 15;
    private final int maxWords;
    private static final Comparator<int[]> _PREFER_SHORTER_AND_LOWER = new Comparator<int[]>(){

        @Override
        public int compare(int[] o1, int[] o2) {
            if (o1.length != o2.length) {
                return o1.length - o2.length;
            }
            int diffOfProducts = WordSeparator.product(o2) - WordSeparator.product(o1);
            if (diffOfProducts != 0) {
                return diffOfProducts;
            }
            return WordSeparator.pairwise(o1, o2);
        }
    };

    public WordSeparator(int maxWords) {
        this.maxWords = maxWords;
    }

    public Iterable<int[]> getBoundaries(int length) {
        return WordSeparator.getBoundaries(length, this.maxWords);
    }

    private static Iterable<int[]> getBoundaries(int length, int maxWords) {
        TreeSet<int[]> list = Sets.newTreeSet(_PREFER_SHORTER_AND_LOWER);
        length = Math.min(length, 15);
        for (int i = 0; i < 1 << length - 1; ++i) {
            int bitCount = WordSeparator.countBits(i) + 1;
            if (bitCount > maxWords) continue;
            int[] separator = new int[bitCount];
            separator[bitCount - 1] = length;
            int bitIndex = 0;
            int bit = 1;
            int separatorIndex = 0;
            while (bit <= i) {
                if ((bit & i) != 0) {
                    separator[separatorIndex++] = bitIndex + 1;
                }
                bit <<= 1;
                ++bitIndex;
            }
            list.add(separator);
        }
        return list;
    }

    private static int countBits(int i) {
        int count = 0;
        while (i > 0) {
            ++count;
            i &= i - 1;
        }
        return count;
    }

    private static int pairwise(int[] o1, int[] o2) {
        for (int i = 0; i < o1.length; ++i) {
            int delta = o2[i] - o1[i];
            if (delta == 0) continue;
            return delta;
        }
        return 0;
    }

    private static int product(int[] array) {
        int product = 1;
        int prev = 0;
        for (int i : array) {
            product *= i - prev;
            prev = i;
        }
        return product;
    }
}

