/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.model.util;

import com.google.common.base.CharMatcher;
import com.google.common.base.Splitter;
import com.google.common.collect.Ordering;
import java.util.Iterator;

public class Versions {
    private static final CharMatcher ALLOWED_CHARACTERS = CharMatcher.anyOf("0123456789.");
    private static final Splitter VERSION_SPLITTER = Splitter.on('.').omitEmptyStrings();

    public static Ordering<String> versionOrdering() {
        return new Ordering<String>(){

            @Override
            public int compare(String left, String right) {
                left = ALLOWED_CHARACTERS.retainFrom(left);
                right = ALLOWED_CHARACTERS.retainFrom(right);
                Iterator<String> leftIter = VERSION_SPLITTER.split(left).iterator();
                Iterator<String> rightIter = VERSION_SPLITTER.split(right).iterator();
                while (leftIter.hasNext() && rightIter.hasNext()) {
                    int nextRight;
                    int nextLeft = Integer.parseInt(leftIter.next());
                    if (nextLeft == (nextRight = Integer.parseInt(rightIter.next()))) continue;
                    return nextLeft - nextRight;
                }
                if (leftIter.hasNext()) {
                    return 1;
                }
                if (rightIter.hasNext()) {
                    return -1;
                }
                return 0;
            }
        };
    }
}

