/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.model.util;

import com.google.common.collect.HashMultiset;
import com.google.common.collect.Lists;
import com.google.common.collect.Multiset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class Trie<T> {
    private final List<Node<T>> nodes = Lists.newArrayListWithCapacity(5);
    private static final char[] normalizedChars = new char[383];
    private static final String NORMALIZED_100_TABLE = "aaaaaaccccccccddddeeeeeeeeeegggggggghhhhiiiiiiiiiijjjjkkkllllllllllnnnnnnnnnoooooooorrrrrrssssssssttttttuuuuuuuuuuuuwwyyyzzzzzzf";

    public Multiset<Integer> computeNodeSizes() {
        HashMultiset<Integer> sizes = HashMultiset.create();
        for (Node<T> node : this.nodes) {
            node.computeNodeSizes(sizes);
        }
        return sizes;
    }

    public void add(String name, T value) {
        for (int i = 0; i < this.nodes.size(); ++i) {
            Node<T> node = this.nodes.get(i);
            Node<T> destinationNode = node.add(name, 0, value);
            if (destinationNode == null) continue;
            if (destinationNode != node) {
                this.nodes.set(i, destinationNode);
            }
            return;
        }
        this.nodes.add(new LeafNode<T>(value, name));
    }

    public Collection<T> findMatches(String prefix) {
        ArrayList results = Lists.newArrayList();
        this.findMatches(results, prefix, null);
        return results;
    }

    public void findMatches(Collection<T> results, String prefix, Collection<T> within) {
        for (Node<T> node : this.nodes) {
            if (node.findMatches(prefix, results, within)) break;
        }
    }

    public boolean containsPrefixed(String string) {
        for (Node<T> node : this.nodes) {
            if (!node.containsPrefixes(string, 0)) continue;
            return true;
        }
        return false;
    }

    public boolean remove(String name, T value) {
        for (int i = 0; i < this.nodes.size(); ++i) {
            Node<T> node = this.nodes.get(i);
            RemoveAction action = node.remove(name, value);
            switch (action) {
                case NOT_FOUND_BUT_DONE_LOOKING: {
                    return false;
                }
                case FOUND_WITHIN: {
                    return true;
                }
                case FOUND_AND_IM_GONE: {
                    this.nodes.remove(i);
                    return true;
                }
            }
        }
        return false;
    }

    public static String normalizeString(String s) {
        int i;
        int length = s.length();
        StringBuilder builder = null;
        for (i = 0; i < length; ++i) {
            char c = s.charAt(i);
            if (Trie.normalizeChar(c) == c) continue;
            builder = new StringBuilder(length);
            builder.append(s.substring(0, i));
            break;
        }
        if (builder == null) {
            return s;
        }
        while (i < length) {
            builder.append(Trie.normalizedCharAt(s, i));
            ++i;
        }
        return builder.toString();
    }

    private static char normalizedCharAt(String s, int index) {
        return Trie.normalizeChar(s.charAt(index));
    }

    private static char normalizeChar(char c) {
        if (c > '\u017f') {
            return c;
        }
        return normalizedChars[c];
    }

    private static char normalizeCharSlow(char c) {
        c = Character.toLowerCase(c);
        switch (c) {
            case '\u00e0': 
            case '\u00e1': 
            case '\u00e2': 
            case '\u00e3': 
            case '\u00e4': 
            case '\u00e5': {
                return 'a';
            }
            case '\u00e7': {
                return 'c';
            }
            case '\u00e8': 
            case '\u00e9': 
            case '\u00ea': 
            case '\u00eb': {
                return 'e';
            }
            case '\u00ec': 
            case '\u00ed': 
            case '\u00ee': 
            case '\u00ef': {
                return 'i';
            }
            case '\u00f1': {
                return 'n';
            }
            case '\u00f0': 
            case '\u00f2': 
            case '\u00f3': 
            case '\u00f4': 
            case '\u00f5': 
            case '\u00f6': 
            case '\u00f8': {
                return 'o';
            }
            case '\u00f9': 
            case '\u00fa': 
            case '\u00fb': 
            case '\u00fc': {
                return 'u';
            }
            case '\u00fd': 
            case '\u00ff': {
                return 'y';
            }
        }
        if (c >= '\u0100' && c <= '\u017f') {
            return NORMALIZED_100_TABLE.charAt(c - 256);
        }
        return c;
    }

    static {
        for (int i = 0; i < normalizedChars.length; ++i) {
            Trie.normalizedChars[i] = Trie.normalizeCharSlow((char)i);
        }
    }

    private static abstract class Node<T> {
        private Node() {
        }

        public abstract boolean findMatches(String var1, Collection<T> var2, Collection<T> var3);

        public abstract boolean containsPrefixes(String var1, int var2);

        protected void computeNodeSizes(Multiset<Integer> sizes) {
        }

        public abstract Node<T> add(String var1, int var2, T var3);

        public abstract RemoveAction remove(String var1, T var2);

        protected abstract void allValues(Collection<T> var1, Collection<T> var2);
    }

    private static class LeafNode<T>
    extends Node<T> {
        private String suffix;
        private short length;
        private char firstChar;
        private final List<T> values = Lists.newArrayList();

        public LeafNode(T firstValue, String suffix) {
            this.values.add(firstValue);
            this.suffix = Trie.normalizeString(suffix);
            this.storeLengthAndFirstChar();
        }

        @Override
        public boolean containsPrefixes(String string, int index) {
            if (string.length() < this.suffix.length() + index) {
                return false;
            }
            return string.regionMatches(index, this.suffix, 0, this.suffix.length());
        }

        @Override
        public boolean findMatches(String prefix, Collection<T> results, Collection<T> within) {
            if (this.suffix.startsWith(prefix)) {
                this.allValues(results, within);
                return true;
            }
            return false;
        }

        @Override
        protected void allValues(Collection<T> results, Collection<T> within) {
            if (within == null) {
                results.addAll(this.values);
            } else {
                int size = this.values.size();
                for (int i = 0; i < size; ++i) {
                    T value = this.values.get(i);
                    if (!within.contains(value)) continue;
                    results.add(value);
                }
            }
        }

        private boolean _matches(String prefix, int index) {
            if (prefix.length() - index != this.length) {
                return false;
            }
            return this.suffix.regionMatches(0, prefix, index, this.length);
        }

        @Override
        public RemoveAction remove(String name, T value) {
            if (name.equals(this.suffix)) {
                this.values.remove(value);
                return this.values.isEmpty() ? RemoveAction.FOUND_AND_IM_GONE : RemoveAction.FOUND_WITHIN;
            }
            return RemoveAction.NOT_FOUND;
        }

        @Override
        public Node<T> add(String name, int index, T value) {
            if (this._matches(name, index)) {
                this.values.add(value);
                return this;
            }
            if (name.length() == index) {
                return null;
            }
            char c = Trie.normalizedCharAt(name, index);
            if (c == this.firstChar) {
                InternalNode<T> newNode = new InternalNode<T>(c);
                this.suffix = this.suffix.substring(1);
                this.storeLengthAndFirstChar();
                newNode.children.add(this);
                return newNode.add(name, index, value);
            }
            return null;
        }

        private void storeLengthAndFirstChar() {
            this.length = (short)this.suffix.length();
            this.firstChar = this.length == 0 ? (char)'\u0000' : Trie.normalizedCharAt(this.suffix, 0);
        }

        public String toString() {
            return "[Leaf:" + this.firstChar + "," + this.suffix + "]";
        }
    }

    private static enum RemoveAction {
        NOT_FOUND,
        NOT_FOUND_BUT_DONE_LOOKING,
        FOUND_WITHIN,
        FOUND_AND_IM_GONE;

    }

    private static class InternalNode<T>
    extends Node<T> {
        private final List<Node<T>> children;
        private final char character;

        public InternalNode(char c) {
            this.character = c;
            this.children = Lists.newArrayList();
        }

        public String toString() {
            return "[Internal:" + this.character + "]";
        }

        @Override
        public boolean containsPrefixes(String string, int index) {
            if (string.length() > index && string.charAt(index) == this.character) {
                for (Node<T> child : this.children) {
                    if (!child.containsPrefixes(string, index + 1)) continue;
                    return true;
                }
            }
            return false;
        }

        @Override
        protected void computeNodeSizes(Multiset<Integer> sizes) {
            sizes.add(this.children.size());
            for (Node<T> child : this.children) {
                child.computeNodeSizes(sizes);
            }
        }

        @Override
        public boolean findMatches(String prefix, Collection<T> results, Collection<T> within) {
            if (Trie.normalizedCharAt(prefix, 0) == this.character) {
                if (prefix.length() == 1) {
                    this.allValues(results, within);
                } else {
                    String prefixMinusFirst = prefix.substring(1);
                    for (Node<T> node : this.children) {
                        if (node.findMatches(prefixMinusFirst, results, within)) break;
                    }
                }
                return true;
            }
            return false;
        }

        @Override
        protected void allValues(Collection<T> results, Collection<T> within) {
            for (Node<T> node : this.children) {
                node.allValues(results, within);
            }
        }

        @Override
        public Node<T> add(String name, int index, T value) {
            if (name.length() > index && Trie.normalizedCharAt(name, index) == this.character) {
                for (int i = 0; i < this.children.size(); ++i) {
                    Node<T> node = this.children.get(i);
                    Node<T> destinationNode = node.add(name, index + 1, value);
                    if (destinationNode == null) continue;
                    if (destinationNode != node) {
                        this.children.set(i, destinationNode);
                    }
                    return this;
                }
                this.children.add(new LeafNode<T>(value, name.substring(index + 1)));
                return this;
            }
            return null;
        }

        @Override
        public RemoveAction remove(String name, T value) {
            if (name.length() > 0 && Trie.normalizedCharAt(name, 0) == this.character) {
                name = name.substring(1);
                for (int i = 0; i < this.children.size(); ++i) {
                    Node<T> node = this.children.get(i);
                    RemoveAction action = node.remove(name, value);
                    if (action == RemoveAction.NOT_FOUND) continue;
                    if (action != RemoveAction.FOUND_AND_IM_GONE) break;
                    this.children.remove(i);
                    break;
                }
                return this.children.isEmpty() ? RemoveAction.FOUND_AND_IM_GONE : RemoveAction.FOUND_WITHIN;
            }
            return RemoveAction.NOT_FOUND;
        }
    }
}

