/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.model.util;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.scythebill.birdlist.model.taxa.Species;
import com.scythebill.birdlist.model.taxa.Taxon;
import com.scythebill.birdlist.model.taxa.TaxonUtils;
import com.scythebill.birdlist.model.taxa.Taxonomy;
import com.scythebill.birdlist.model.util.IndexerBuilder;
import com.scythebill.birdlist.model.util.Progress;
import com.scythebill.birdlist.model.util.ToString;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;

public class TaxonomyIndexer {
    private final IndexerBuilder commonIndexLoader;
    private final IndexerBuilder sciIndexLoader;
    private final Future<? extends Taxonomy> taxonomyFuture;

    public TaxonomyIndexer(Future<? extends Taxonomy> taxonomyFuture) {
        this.taxonomyFuture = taxonomyFuture;
        Function alternateCommonNames = Species::getAlternateCommonNames;
        this.commonIndexLoader = new IndexerBuilder(taxonomyFuture, new ToString<Taxon>(){

            @Override
            public String getString(Taxon taxon) {
                return taxon.getCommonName();
            }

            @Override
            public String getPreviewString(Taxon taxon) {
                return this.getString(taxon);
            }
        }, alternateCommonNames, true);
        Function alternateNames = Species::getAlternateNames;
        this.sciIndexLoader = new IndexerBuilder(taxonomyFuture, new ToString<Taxon>(){

            @Override
            public String getString(Taxon taxon) {
                return TaxonUtils.getFullName(taxon);
            }

            @Override
            public String getPreviewString(Taxon taxon) {
                return this.getString(taxon);
            }
        }, alternateNames, false);
    }

    public ListenableFuture<?> load(ListeningExecutorService executorService) {
        Future commonIndexerFuture = executorService.submit((Callable)this.commonIndexLoader);
        Futures.addCallback(commonIndexerFuture, new FutureCallback<IndexerBuilder.Indexers>(){

            @Override
            public void onSuccess(IndexerBuilder.Indexers result) {
                Futures.getUnchecked(TaxonomyIndexer.this.taxonomyFuture).setCommonIndexer(result.indexer);
                Futures.getUnchecked(TaxonomyIndexer.this.taxonomyFuture).setAlternateCommonIndexer(result.alternateIndexer);
            }

            @Override
            public void onFailure(Throwable t) {
                throw new AssertionError((Object)t);
            }
        }, executorService);
        Future sciIndexerFuture = executorService.submit((Callable)this.sciIndexLoader);
        Futures.addCallback(sciIndexerFuture, new FutureCallback<IndexerBuilder.Indexers>(){

            @Override
            public void onSuccess(IndexerBuilder.Indexers result) {
                Futures.getUnchecked(TaxonomyIndexer.this.taxonomyFuture).setScientificIndexer(result.indexer);
                Futures.getUnchecked(TaxonomyIndexer.this.taxonomyFuture).setAlternateScientificIndexer(result.alternateIndexer);
            }

            @Override
            public void onFailure(Throwable t) {
                throw new AssertionError((Object)t);
            }
        }, executorService);
        return Futures.allAsList(ImmutableList.of(commonIndexerFuture, sciIndexerFuture));
    }

    public Progress getCommonIndexLoader() {
        return this.commonIndexLoader;
    }

    public Progress getScientificIndexLoader() {
        return this.sciIndexLoader;
    }
}

