/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.model.util;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;

public class TaxonNames {
    private static final Splitter SPLIT_NAMES = Splitter.on(' ');
    private static final Joiner JOIN_NAMES = Joiner.on(' ');

    public static final String joinFromEnd(List<String> names, Joiner join) {
        String nameOfFirst;
        if (names.size() == 1) {
            return names.get(0);
        }
        ArrayList<List<String>> components = Lists.newArrayList();
        int shortest = Integer.MAX_VALUE;
        for (String name : names) {
            List<String> split = SPLIT_NAMES.splitToList(name);
            components.add(split);
            shortest = Math.min(shortest, split.size());
        }
        if (shortest == 1) {
            return join.join(names);
        }
        ArrayList<String> commonNames = Lists.newArrayList();
        while ((nameOfFirst = TaxonNames.getNthFromEnd((List)components.get(0), commonNames.size())) != null) {
            boolean allMatch = true;
            for (List component : Iterables.skip(components, 1)) {
                String name = TaxonNames.getNthFromEnd(component, commonNames.size());
                if (name != null && name.equals(nameOfFirst)) continue;
                allMatch = false;
                break;
            }
            if (!allMatch) break;
            commonNames.add(0, nameOfFirst);
            if (commonNames.size() < shortest - 1) continue;
            break;
        }
        ArrayList<String> nonCommonNames = Lists.newArrayList();
        for (List list : components) {
            nonCommonNames.add(JOIN_NAMES.join(list.subList(0, list.size() - commonNames.size())));
        }
        commonNames.add(0, join.join(nonCommonNames));
        return JOIN_NAMES.join(commonNames);
    }

    private static String getNthFromEnd(List<String> list, int nth) {
        int index = list.size() - nth - 1;
        return index < 0 ? null : list.get(index);
    }

    public static final String joinFromStart(List<String> names, Joiner join) {
        String nameOfFirst;
        if (names.size() == 1) {
            return names.get(0);
        }
        ArrayList<ArrayList<String>> components = Lists.newArrayList();
        for (String name : names) {
            components.add(Lists.newArrayList(SPLIT_NAMES.split(name)));
        }
        ArrayList<String> commonNames = Lists.newArrayList();
        while ((nameOfFirst = TaxonNames.getNthFromStart((List)components.get(0), commonNames.size())) != null) {
            boolean allMatch = true;
            for (List component : Iterables.skip(components, 1)) {
                String name = TaxonNames.getNthFromStart(component, commonNames.size());
                if (name != null && name.equals(nameOfFirst)) continue;
                allMatch = false;
                break;
            }
            if (!allMatch) break;
            commonNames.add(nameOfFirst);
        }
        ArrayList<String> nonCommonNames = Lists.newArrayList();
        for (List list : components) {
            nonCommonNames.add(JOIN_NAMES.join(list.subList(commonNames.size(), list.size())));
        }
        commonNames.add(join.join(nonCommonNames));
        return JOIN_NAMES.join(commonNames);
    }

    private static String getNthFromStart(List<String> list, int nth) {
        return nth >= list.size() ? null : list.get(nth);
    }
}

