/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.model.util;

import com.google.common.collect.Ordering;
import com.scythebill.birdlist.model.sighting.SightingTaxon;
import com.scythebill.birdlist.model.taxa.Taxon;
import java.util.Iterator;
import javax.annotation.Nullable;

public class ResolvedComparator
extends Ordering<SightingTaxon.Resolved> {
    @Override
    public int compare(@Nullable SightingTaxon.Resolved left, @Nullable SightingTaxon.Resolved right) {
        int rightMax;
        if (left.getType() == SightingTaxon.Type.SINGLE) {
            if (right.getType() == SightingTaxon.Type.SINGLE) {
                return left.getTaxon().getTaxonomyIndex() - right.getTaxon().getTaxonomyIndex();
            }
            int maxIndex = this.getMaxIndex(right);
            return left.getTaxon().getTaxonomyIndex() <= maxIndex ? -1 : 1;
        }
        if (right.getType() == SightingTaxon.Type.SINGLE) {
            int maxIndex = this.getMaxIndex(left);
            return maxIndex < right.getTaxon().getTaxonomyIndex() ? -1 : 1;
        }
        int leftMax = this.getMaxIndex(left);
        if (leftMax != (rightMax = this.getMaxIndex(right))) {
            return leftMax - rightMax;
        }
        Iterator<Taxon> leftIterator = left.getTaxa().iterator();
        Iterator<Taxon> rightIterator = right.getTaxa().iterator();
        while (leftIterator.hasNext() && rightIterator.hasNext()) {
            Taxon nextRight;
            Taxon nextLeft = leftIterator.next();
            if (nextLeft == (nextRight = rightIterator.next())) continue;
            return nextLeft.getTaxonomyIndex() - nextRight.getTaxonomyIndex();
        }
        if (leftIterator.hasNext()) {
            return 1;
        }
        if (rightIterator.hasNext()) {
            return -1;
        }
        return left.getType().compareTo(right.getType());
    }

    private int getMaxIndex(SightingTaxon.Resolved right) {
        int max = -1;
        for (Taxon taxon : right.getTaxa()) {
            max = Math.max(max, taxon.getTaxonomyIndex());
        }
        return max;
    }
}

