/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.model.util;

import com.google.common.base.Strings;
import java.util.Locale;
import java.util.prefs.Preferences;

public class LocalePreferences {
    private static LocalePreferences instance = new LocalePreferences();
    private Locale localeAtStartup;
    private String uiLocale;

    private LocalePreferences() {
        Preferences preferences = Preferences.userNodeForPackage(this.getClass());
        this.uiLocale = preferences.get("uiLocale", "");
        this.localeAtStartup = this.isDefault() ? Locale.getDefault() : Locale.forLanguageTag(this.uiLocale);
    }

    public static LocalePreferences instance() {
        return instance;
    }

    public Locale getUiLocale() {
        return this.localeAtStartup;
    }

    public Locale getSavedLocale() {
        if (this.isDefault()) {
            return Locale.getDefault();
        }
        return Locale.forLanguageTag(this.uiLocale);
    }

    public boolean isDefault() {
        return Strings.isNullOrEmpty(this.uiLocale);
    }

    public void saveLocale(Locale locale) {
        this.uiLocale = locale == null ? "" : locale.toLanguageTag();
        Preferences preferences = Preferences.userNodeForPackage(this.getClass());
        preferences.put("uiLocale", this.uiLocale);
    }
}

