/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.model.util;

import com.google.common.base.CharMatcher;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.lang.invoke.CallSite;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.TreeSet;
import org.joda.time.DateTimeFieldType;
import org.joda.time.LocalDate;
import org.joda.time.Partial;
import org.joda.time.chrono.GJChronology;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public final class LocalDateFormatterChooser {
    private static final CharMatcher COMPONENT_SEPARATORS = CharMatcher.anyOf("/-,").or(CharMatcher.whitespace());
    private static final CharMatcher COMPONENT_SEPARATORS_OR_DIGIT = CharMatcher.anyOf("/-,").or(CharMatcher.whitespace()).or(CharMatcher.inRange('0', '9'));
    private static final CharMatcher COMPONENT_TEXT = COMPONENT_SEPARATORS.negate();
    private static final ImmutableList<String> MONTH_OR_DAY_NUMBER_FORMATS = ImmutableList.of("M", "d");
    private static final ImmutableList<String> MONTH_TEXT_FORMATS = ImmutableList.of("MMM");
    private static final ImmutableList<String> YEAR_NUMBER_FORMATS = ImmutableList.of("yy");
    private static final ImmutableList<String> YEAR_OR_DAY_NUMBER_FORMATS = ImmutableList.of("yy", "d");
    private static final ImmutableList<String> YEAR_OR_DAY_OR_MONTH_NUMBER_FORMATS = ImmutableList.of("yy", "M", "d");

    public ImmutableList<ChosenFormat> chooseFormatters(Collection<String> dates) {
        ArrayListMultimap datesBySeparators = ArrayListMultimap.create(5, dates.size());
        for (String date : dates) {
            String retainedSeparators = COMPONENT_SEPARATORS.retainFrom(date);
            datesBySeparators.put(retainedSeparators, date);
        }
        TreeSet<String> separators = new TreeSet<String>(Comparator.comparing(s -> datesBySeparators.get(s).size()).reversed().thenComparing(s -> s.length()).thenComparing(Comparator.naturalOrder()));
        separators.addAll(datesBySeparators.keySet());
        ImmutableList.Builder formatters = ImmutableList.builder();
        for (String separator : separators) {
            this.chooseFormatter(datesBySeparators.get(separator)).ifPresent(formatters::add);
        }
        return formatters.build();
    }

    private Optional<ChosenFormat> chooseFormatter(List<String> dates) {
        String firstDate = dates.get(0);
        AbstractCollection hypotheses = this.computeHypotheses(firstDate);
        if (hypotheses.size() > 1) {
            for (String date : dates) {
                int successful = 0;
                for (ChosenFormat hypothesis : hypotheses) {
                    try {
                        hypothesis.formatter().parseLocalDate(date);
                        ++successful;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {}
                }
                if (successful == hypotheses.size() || successful == 0) continue;
                ArrayList<ChosenFormat> newHypotheses = new ArrayList<ChosenFormat>(successful);
                for (ChosenFormat hypothesis : hypotheses) {
                    try {
                        hypothesis.formatter().parseLocalDate(date);
                        newHypotheses.add(hypothesis);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {}
                }
                hypotheses = newHypotheses;
                if (hypotheses.size() != 1) continue;
                break;
            }
        }
        return hypotheses.stream().findFirst();
    }

    private ImmutableList<ChosenFormat> computeHypotheses(String date) {
        ArrayList<Object> hypotheses = new ArrayList<Object>(2);
        hypotheses.add("");
        int position = 0;
        while (true) {
            int nextSeparator = CharMatcher.inRange('0', '9').matches(date.charAt(position)) ? COMPONENT_SEPARATORS.indexIn(date, position) : COMPONENT_SEPARATORS_OR_DIGIT.indexIn(date, position);
            String component = nextSeparator < 0 ? date.substring(position) : date.substring(position, nextSeparator);
            List<String> possibleFormats = this.computePossibleFormats(component);
            ArrayList<CallSite> newHypotheses = new ArrayList<CallSite>(hypotheses.size() * possibleFormats.size());
            for (String possibleFormat : possibleFormats) {
                for (String string : hypotheses) {
                    if (string.contains(possibleFormat)) continue;
                    newHypotheses.add((CallSite)((Object)(string + possibleFormat)));
                }
            }
            hypotheses = newHypotheses;
            if (nextSeparator < 0) break;
            int nextComponent = COMPONENT_TEXT.indexIn(date, nextSeparator);
            String separator = nextComponent < 0 ? date.substring(nextSeparator) : date.substring(nextSeparator, nextComponent);
            for (int i = 0; i < hypotheses.size(); ++i) {
                hypotheses.set(i, (String)hypotheses.get(i) + separator);
            }
            if (nextComponent < 0) break;
            position = nextComponent;
        }
        return hypotheses.stream().map(ChosenFormat::forPattern).flatMap(Collection::stream).collect(ImmutableList.toImmutableList());
    }

    private List<String> computePossibleFormats(String component) {
        if (CharMatcher.inRange('0', '9').matchesAllOf(component)) {
            if (component.length() == 1) {
                return MONTH_OR_DAY_NUMBER_FORMATS;
            }
            if (component.length() > 2) {
                return YEAR_NUMBER_FORMATS;
            }
            int intComponent = Integer.parseInt(component);
            if (intComponent > 31) {
                return YEAR_NUMBER_FORMATS;
            }
            if (intComponent > 12) {
                return YEAR_OR_DAY_NUMBER_FORMATS;
            }
            return YEAR_OR_DAY_OR_MONTH_NUMBER_FORMATS;
        }
        return MONTH_TEXT_FORMATS;
    }

    public static class ChosenFormat {
        private final DateTimeFormatter formatter;
        private final ImmutableSet<DateTimeFieldType> fieldTypes;
        private final String pattern;

        public DateTimeFormatter formatter() {
            return this.formatter;
        }

        public Partial parse(String date) {
            Partial partial = new Partial(GJChronology.getInstance());
            LocalDate localDate = this.formatter.parseLocalDate(date);
            if (this.fieldTypes.contains(DateTimeFieldType.year())) {
                partial = partial.with(DateTimeFieldType.year(), localDate.getYear());
            }
            if (this.fieldTypes.contains(DateTimeFieldType.monthOfYear())) {
                partial = partial.with(DateTimeFieldType.monthOfYear(), localDate.getMonthOfYear());
            }
            if (this.fieldTypes.contains(DateTimeFieldType.dayOfMonth())) {
                partial = partial.with(DateTimeFieldType.dayOfMonth(), localDate.getDayOfMonth());
            }
            return partial;
        }

        static ImmutableList<ChosenFormat> forPattern(String pattern) {
            ImmutableSet.Builder fields = ImmutableSet.builder();
            if (pattern.indexOf(121) >= 0) {
                fields.add(DateTimeFieldType.year());
            }
            if (pattern.indexOf(77) >= 0) {
                fields.add(DateTimeFieldType.monthOfYear());
            }
            if (pattern.indexOf(100) >= 0) {
                fields.add(DateTimeFieldType.dayOfMonth());
            }
            ChosenFormat chosenFormatInDefaultLocale = new ChosenFormat(DateTimeFormat.forPattern(pattern), (ImmutableSet<DateTimeFieldType>)fields.build(), pattern);
            if (Locale.getDefault().getLanguage().equals(Locale.ENGLISH.getLanguage())) {
                return ImmutableList.of(chosenFormatInDefaultLocale);
            }
            return ImmutableList.of(chosenFormatInDefaultLocale, chosenFormatInDefaultLocale.withLocale(Locale.US));
        }

        private ChosenFormat withLocale(Locale locale) {
            return new ChosenFormat(this.formatter.withLocale(locale), this.fieldTypes, this.pattern);
        }

        private ChosenFormat(DateTimeFormatter formatter, ImmutableSet<DateTimeFieldType> fieldTypes, String pattern) {
            this.formatter = formatter;
            this.fieldTypes = fieldTypes;
            this.pattern = pattern;
        }

        public String toString() {
            return MoreObjects.toStringHelper(this).add("pattern", this.pattern).toString();
        }
    }
}

