/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.model.util;

import com.google.common.base.Function;
import com.scythebill.birdlist.model.taxa.Species;
import com.scythebill.birdlist.model.taxa.Taxon;
import com.scythebill.birdlist.model.taxa.Taxonomy;
import com.scythebill.birdlist.model.util.AlternateName;
import com.scythebill.birdlist.model.util.Indexer;
import com.scythebill.birdlist.model.util.Progress;
import com.scythebill.birdlist.model.util.ToString;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;

public class IndexerBuilder
implements Callable<Indexers>,
Progress {
    private volatile int max = 10000;
    private final AtomicInteger current = new AtomicInteger(0);
    private final ToString<Taxon> namer;
    private final Future<? extends Taxonomy> taxonomyFuture;
    private Function<Species, Iterable<String>> alternatesFunction;
    private final boolean includeSubspecies;

    public IndexerBuilder(Future<? extends Taxonomy> taxonomyFuture, ToString<Taxon> namer, Function<Species, Iterable<String>> alternatesFunction, boolean includeSubspecies) {
        this.taxonomyFuture = taxonomyFuture;
        this.namer = namer;
        this.alternatesFunction = alternatesFunction;
        this.includeSubspecies = includeSubspecies;
    }

    @Override
    public Indexers call() throws Exception {
        Taxonomy taxonomy = this.taxonomyFuture.get();
        this.max = taxonomy.getSpeciesCount();
        Indexers indexers = new Indexers();
        indexers.indexer = new Indexer();
        indexers.alternateIndexer = new Indexer();
        this.addToIndex(taxonomy, indexers, this.namer, taxonomy.getRoot());
        return indexers;
    }

    @Override
    public long current() {
        return this.current.get();
    }

    @Override
    public long max() {
        return this.max;
    }

    private void addToIndex(Taxonomy taxonomy, Indexers indexers, ToString<Taxon> namer, Taxon taxon) {
        if (taxon instanceof Species) {
            if (!taxon.isDisabled()) {
                String id = taxonomy.getId(taxon);
                String name = namer.getString(taxon);
                if (name != null) {
                    indexers.indexer.add(name, id);
                }
                if (this.alternatesFunction != null) {
                    for (String alternate : this.alternatesFunction.apply((Species)taxon)) {
                        String nameToIndex = this.trimSuffixes(alternate);
                        indexers.alternateIndexer.add(nameToIndex, AlternateName.forNameAndId(alternate, id));
                    }
                }
            }
            if (taxon.getType() == Taxon.Type.species) {
                this.current.incrementAndGet();
            }
            if (!this.includeSubspecies) {
                return;
            }
        }
        for (Taxon child : taxon.getContents()) {
            this.addToIndex(taxonomy, indexers, namer, child);
        }
    }

    private String trimSuffixes(String alternate) {
        int indexOf = alternate.indexOf(" -");
        if (indexOf > 0) {
            return alternate.substring(0, indexOf);
        }
        return alternate;
    }

    public static class Indexers {
        public Indexer<String> indexer;
        public Indexer<AlternateName<String>> alternateIndexer;
    }
}

