/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.model.util;

import com.google.common.base.CharMatcher;
import com.google.common.base.Splitter;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multiset;
import com.scythebill.birdlist.model.util.Trie;
import com.scythebill.birdlist.model.util.WordSeparator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;

public class Indexer<T> {
    private List<Trie<T>> tries;
    private int maxWords;
    private WordSeparator wordSeparator;
    private static final Splitter WORD_SEPARATORS = Splitter.on(CharMatcher.whitespace().or(CharMatcher.anyOf("-.,/"))).omitEmptyStrings();
    private static final CharMatcher CHARACTERS_TO_DROP = CharMatcher.anyOf("'()");
    private ImmutableMultimap<String, String> alternateIndexEntries = ImmutableMultimap.of();

    public Indexer() {
        this(5);
    }

    public Indexer(int maxWords) {
        this.maxWords = maxWords;
        this.tries = new ArrayList<Trie<T>>(maxWords);
        this.wordSeparator = new WordSeparator(maxWords);
    }

    public Multiset<Integer> computeSizes() {
        HashMultiset<Integer> sizes = HashMultiset.create();
        for (Trie<T> trie : this.tries) {
            sizes.addAll(trie.computeNodeSizes());
        }
        return sizes;
    }

    public Collection<T> find(String entry) {
        if (entry == null || entry.length() == 0) {
            return Collections.emptyList();
        }
        List<String> tokens = ImmutableList.copyOf(WORD_SEPARATORS.split(entry = CHARACTERS_TO_DROP.removeFrom(Trie.normalizeString(entry))));
        if (tokens.size() > 1) {
            return this.find(tokens);
        }
        int length = entry.length();
        LinkedHashSet<T> fullResults = new LinkedHashSet<T>();
        Iterable<int[]> tokenBoundariesForThisLength = this.wordSeparator.getBoundaries(length);
        for (int[] tokenBoundaries : tokenBoundariesForThisLength) {
            tokens = Indexer._createListOfTokens(entry, tokenBoundaries);
            Collection<T> results = this.find(tokens);
            fullResults.addAll(results);
        }
        return fullResults;
    }

    private static List<String> _createListOfTokens(String entry, int[] boundaries) {
        ArrayList<String> l = new ArrayList<String>(boundaries.length);
        int start = 0;
        for (int i = 0; i < boundaries.length; ++i) {
            l.add(entry.substring(start, boundaries[i]));
            start = boundaries[i];
        }
        return l;
    }

    public Collection<T> find(List<String> tokens) {
        int trieCount;
        int tokenCount = tokens.size();
        if (tokenCount > (trieCount = this.tries.size())) {
            return Collections.emptySet();
        }
        return this._find(tokens, 0, 0, null);
    }

    private Collection<T> _find(List<String> tokens, int tokenNumber, int minimumTrie, Collection<T> within) {
        LinkedHashSet results = new LinkedHashSet();
        String token = tokens.get(tokenNumber);
        int lastAvailableTrie = this.tries.size() - (tokens.size() - tokenNumber);
        for (int i = minimumTrie; i <= lastAvailableTrie; ++i) {
            Collection ithTrieResults = new LinkedHashSet();
            this.tries.get(i).findMatches(ithTrieResults, token, within);
            if (!ithTrieResults.isEmpty() && tokenNumber + 1 < tokens.size()) {
                Collection nextResults = this._find(tokens, tokenNumber + 1, i + 1, ithTrieResults);
                ithTrieResults = nextResults;
                if (nextResults.isEmpty() || nextResults.size() == 1) {
                    ithTrieResults = nextResults;
                } else {
                    Iterator iter = ithTrieResults.iterator();
                    while (iter.hasNext()) {
                        if (nextResults.contains(iter.next())) continue;
                        iter.remove();
                    }
                }
            }
            results.addAll(ithTrieResults);
        }
        return results;
    }

    public void add(String name, T value) {
        Iterator<String> tokens = WORD_SEPARATORS.split(name).iterator();
        for (int i = 0; i < this.maxWords && tokens.hasNext(); ++i) {
            String word = CHARACTERS_TO_DROP.removeFrom(tokens.next());
            if (this.tries.size() == i) {
                this.tries.add(new Trie());
            }
            Trie<T> trie = this.tries.get(i);
            trie.add(word, value);
            for (String alternate : this.alternateIndexEntries.get((Object)word)) {
                trie.add(alternate, value);
            }
        }
    }

    public void remove(String name, T value) {
        Iterator<String> tokens = WORD_SEPARATORS.split(name).iterator();
        for (int i = 0; i < this.maxWords && tokens.hasNext(); ++i) {
            String word = CHARACTERS_TO_DROP.removeFrom(tokens.next());
            if (this.tries.size() == i) break;
            Trie<T> trie = this.tries.get(i);
            trie.remove(word, value);
            for (String alternate : this.alternateIndexEntries.get((Object)word)) {
                trie.remove(alternate, value);
            }
        }
    }

    public void setAlternateIndexEntries(ImmutableMultimap<String, String> alternateIndexEntries) {
        this.alternateIndexEntries = alternateIndexEntries;
    }
}

