/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.model.util;

import com.google.common.collect.Lists;
import com.scythebill.birdlist.model.util.Dirty;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import org.joda.time.Instant;

public class DirtyImpl
implements Dirty {
    private volatile boolean dirty;
    private final List<PropertyChangeListener> listeners = Lists.newLinkedList();
    private volatile Instant dirtySince;

    public DirtyImpl(boolean dirty) {
        this.dirty = dirty;
        if (dirty) {
            this.dirtySince = new Instant();
        }
    }

    @Override
    public void addDirtyListener(PropertyChangeListener listener) {
        this.listeners.add(listener);
    }

    public void setDirty(boolean newDirty) {
        if (newDirty != this.dirty) {
            this.dirty = newDirty;
            this.dirtySince = this.dirty ? new Instant() : null;
            this.firePropertyChanged();
        }
    }

    private void firePropertyChanged() {
        PropertyChangeEvent event = new PropertyChangeEvent(this, "dirty", !this.dirty, this.dirty);
        for (PropertyChangeListener listener : this.listeners) {
            listener.propertyChange(event);
        }
    }

    @Override
    public boolean isDirty() {
        return this.dirty;
    }

    @Override
    public Instant dirtySince() {
        return this.dirtySince;
    }
}

