/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.model.util;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.scythebill.birdlist.model.util.Metric;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class BKTree<K, V> {
    private final BKNode<K, V> root;
    private final Metric<K> metric;
    private Function<K, K> keyTransform;

    public static <K, V> Builder<K, V> builder(Metric<K> metric) {
        return new Builder(metric);
    }

    public List<V> search(K q, int maxDistance) {
        if (this.root == null) {
            return ImmutableList.of();
        }
        ArrayList accumulator = Lists.newArrayList();
        this.root.search(this.keyTransform.apply(q), this.metric, maxDistance, accumulator);
        return accumulator;
    }

    private BKTree(BKNode<K, V> root, Metric<K> metric, Function<K, K> keyTransform) {
        this.root = root;
        this.metric = metric;
        this.keyTransform = keyTransform;
    }

    public static class Builder<K, V> {
        private BKNode<K, V> root;
        private final Metric<K> metric;
        private Function<K, K> keyTransform = Functions.identity();

        public BKTree<K, V> build() {
            return new BKTree<K, V>(this.root, this.metric, this.keyTransform);
        }

        private Builder(Metric<K> metric) {
            this.metric = Preconditions.checkNotNull(metric);
        }

        public void add(K key, V value) {
            BKNode<K, V> newNode = new BKNode<K, V>(this.keyTransform.apply(key), value);
            if (this.root == null) {
                this.root = newNode;
            }
            this.addInternal(this.root, newNode);
        }

        private void addInternal(BKNode<K, V> src, BKNode<K, V> newNode) {
            if (src.equals(newNode)) {
                return;
            }
            int distance = this.metric.distance(src.key, newNode.key);
            BKNode<K, V> bkNode = src.childAtDistance(distance);
            if (bkNode == null) {
                src.addChild(distance, newNode);
            } else {
                this.addInternal(bkNode, newNode);
            }
        }

        public Builder<K, V> withTransform(Function<K, K> transform) {
            this.keyTransform = transform;
            return this;
        }
    }

    static class BKNode<K, V> {
        private final K key;
        private final V value;
        private final Map<Integer, BKNode<K, V>> children = Maps.newHashMap();

        public BKNode(K key, V value) {
            this.key = Preconditions.checkNotNull(key);
            this.value = value;
        }

        BKNode<K, V> childAtDistance(int pos) {
            return this.children.get(pos);
        }

        private void addChild(int pos, BKNode<K, V> child) {
            this.children.put(pos, child);
        }

        void search(K query, Metric<K> metric, int maxDistance, List<V> accumulator) {
            int distance = metric.distance(this.key, query);
            if (distance <= maxDistance) {
                accumulator.add(this.value);
            }
            if (this.children.size() == 0) {
                return;
            }
            for (int i = Math.max(1, distance - maxDistance); i <= distance + maxDistance; ++i) {
                BKNode<K, V> child = this.children.get(i);
                if (child == null) continue;
                child.search(query, metric, maxDistance, accumulator);
            }
        }
    }
}

