/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.model.util;

import com.google.common.base.CharMatcher;
import com.google.common.base.Splitter;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;

public class Abbreviations {
    private Abbreviations() {
    }

    public static Optional<String> abbreviate(String name, Predicate<String> reserved, AbbreviationConfig config) {
        if (name.isEmpty()) {
            return Optional.empty();
        }
        List<String> nameParts = Splitter.on(config.ignoredCharacters.or(CharMatcher.whitespace())).omitEmptyStrings().limit(config.maxWords).splitToList(name);
        if (nameParts.isEmpty()) {
            return Optional.empty();
        }
        StringBuilder builder = new StringBuilder(name.length());
        Object abbreviation = null;
        for (int i = nameParts.size(); i <= nameParts.size() * config.maxPerWordChars; ++i) {
            builder.setLength(0);
            int lettersForEach = i / nameParts.size();
            int leftover = i % nameParts.size();
            for (int j = 0; j < nameParts.size(); ++j) {
                int length = j < leftover ? lettersForEach + 1 : lettersForEach;
                String part = nameParts.get(j);
                builder.append(part.substring(0, Math.min(length, part.length())));
            }
            abbreviation = builder.toString();
            if (!reserved.test((String)abbreviation) && ((String)abbreviation).length() >= config.minLength) break;
        }
        int extraCount = 1;
        while (true) {
            String abbreviationWithSuffix;
            String string = abbreviationWithSuffix = extraCount == 1 ? abbreviation : "" + abbreviation + extraCount;
            if (!reserved.test(abbreviationWithSuffix)) {
                return Optional.of(abbreviationWithSuffix);
            }
            ++extraCount;
        }
    }

    public static class AbbreviationConfig {
        public CharMatcher ignoredCharacters = CharMatcher.none();
        public int maxPerWordChars = 3;
        public int maxWords = 4;
        public int minLength = 1;
    }
}

