/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.model.user;

import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableSet;
import com.scythebill.birdlist.model.query.SightingPredicates;
import com.scythebill.birdlist.model.sighting.ReportSet;
import com.scythebill.birdlist.model.sighting.Sighting;
import com.scythebill.birdlist.model.sighting.Trip;
import com.scythebill.birdlist.model.sighting.VisitInfoKey;
import com.scythebill.birdlist.model.user.User;

public class Users {
    private Users() {
    }

    public static ImmutableSet<User> usersForVisitInfoKey(ReportSet reportSet, VisitInfoKey visitInfoKey) {
        if (reportSet.getUserSet() == null) {
            return ImmutableSet.of();
        }
        ImmutableSet.Builder users = ImmutableSet.builder();
        for (Sighting sighting : reportSet.getSightings()) {
            if (!sighting.hasSightingInfo() || !visitInfoKey.matches(sighting)) continue;
            users.addAll(sighting.getSightingInfo().getUsers());
        }
        return users.build();
    }

    public static ImmutableSet<User> usersForTrip(ReportSet reportSet, Trip trip) {
        if (reportSet.getUserSet() == null) {
            return ImmutableSet.of();
        }
        Predicate<Sighting> tripPredicate = SightingPredicates.isPartOfTrip(trip, reportSet.getLocations());
        ImmutableSet.Builder users = ImmutableSet.builder();
        for (Sighting sighting : reportSet.getSightings()) {
            if (!sighting.hasSightingInfo() || !tripPredicate.apply(sighting)) continue;
            users.addAll(sighting.getSightingInfo().getUsers());
        }
        return users.build();
    }
}

