/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.model.user;

import com.google.common.base.CharMatcher;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import com.scythebill.birdlist.model.user.User;
import com.scythebill.birdlist.model.util.Abbreviations;
import com.scythebill.birdlist.model.util.Dirty;
import com.scythebill.birdlist.model.util.DirtyImpl;
import java.text.BreakIterator;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;

public class UserSet {
    public static final CharMatcher NOT_ELIGIBLE_ID_CHARS = CharMatcher.anyOf(",/ ");
    private final Map<String, User> users = Maps.newLinkedHashMap();
    private final Map<String, User> usersByAbbreviation = Maps.newLinkedHashMap();
    private final DirtyImpl dirty = new DirtyImpl(false);
    static Abbreviations.AbbreviationConfig abbreviationConfig = new Abbreviations.AbbreviationConfig();

    public User addUser(User.Builder builder) {
        User existingUserByAbbreviation;
        if (builder.abbreviation() != null && User.NOT_ELIGIBLE_ABBREVIATION_CHARS.matchesAnyOf(builder.abbreviation())) {
            throw new IllegalStateException("Abbreviations may not contain any of \",/ \"");
        }
        if (builder.id() == null) {
            String id;
            String name = builder.name();
            Object idBase = null;
            if (Strings.isNullOrEmpty(name)) {
                idBase = Strings.nullToEmpty(builder.abbreviation()).toLowerCase();
            } else {
                idBase = "";
                BreakIterator iterator = BreakIterator.getWordInstance();
                iterator.setText(name);
                int start = iterator.first();
                int end = iterator.next();
                while (end != -1) {
                    String substring = name.substring(start, Math.min(end, start + 2));
                    if (!CharMatcher.whitespace().matchesAllOf(substring)) {
                        idBase = (String)idBase + substring.toLowerCase();
                    }
                    start = end;
                    end = iterator.next();
                }
            }
            idBase = NOT_ELIGIBLE_ID_CHARS.removeFrom((CharSequence)idBase);
            if (((String)idBase).isEmpty()) {
                idBase = "u";
            }
            int i = 0;
            while (true) {
                String string = id = i == 0 ? idBase : (String)idBase + i;
                if (!this.users.containsKey(id)) break;
                ++i;
            }
            builder.setId(id);
        }
        User user = builder.build();
        User existingUser = this.users.get(user.id());
        if (user.abbreviation() != null && (existingUserByAbbreviation = this.usersByAbbreviation.get(user.abbreviation())) != null && existingUserByAbbreviation != existingUser) {
            throw new IllegalStateException("There is already a user with this abbreviation: " + existingUserByAbbreviation);
        }
        if (existingUser != null && existingUser.abbreviation() != null) {
            this.usersByAbbreviation.remove(existingUser.abbreviation());
        }
        if (user.abbreviation() != null) {
            this.usersByAbbreviation.put(user.abbreviation(), user);
        }
        this.users.put(user.id(), user);
        this.dirty.setDirty(true);
        return user;
    }

    public boolean hasUserWithId(String id) {
        return this.users.containsKey(id);
    }

    public void removeUser(User user) {
        if (!this.users.containsKey(user.id())) {
            throw new IllegalStateException("User " + user + " is not present");
        }
        if (user.abbreviation() != null && !this.usersByAbbreviation.containsKey(user.abbreviation())) {
            throw new IllegalStateException("User " + user + " abbreviation is not present");
        }
        this.users.remove(user.id());
        if (user.abbreviation() != null) {
            this.usersByAbbreviation.remove(user.abbreviation());
        }
        this.dirty.setDirty(true);
    }

    public User userById(String id) {
        User user = this.users.get(Preconditions.checkNotNull(id));
        if (user == null) {
            throw new IllegalArgumentException("No user with ID " + id);
        }
        return user;
    }

    public User userByAbbreviation(String abbreviation) {
        User user = this.usersByAbbreviation.get(Preconditions.checkNotNull(abbreviation));
        if (user == null) {
            throw new IllegalArgumentException("No user with abbreviation " + abbreviation);
        }
        return user;
    }

    public User.Builder newUserBuilderFromStorage(String id) {
        return new User.Builder().setId(id);
    }

    public User.Builder newUserBuilder() {
        return new User.Builder();
    }

    public Collection<User> allUsers() {
        return Collections.unmodifiableCollection(this.users.values());
    }

    public boolean hasUserWithAbbreviation(String abbreviation) {
        return this.usersByAbbreviation.containsKey(abbreviation);
    }

    public Dirty getDirty() {
        return this.dirty;
    }

    public void clearDirty() {
        this.dirty.setDirty(false);
    }

    public Optional<String> computeDefaultAbbreviation(String name, Optional<User> currentUser) {
        return Abbreviations.abbreviate(name, abbreviation -> !this.isAbbreviationAvailable((String)abbreviation, currentUser), abbreviationConfig);
    }

    private boolean isAbbreviationAvailable(String abbreviation, Optional<User> currentUser) {
        User userByAbbreviation;
        if (!this.hasUserWithAbbreviation(abbreviation)) {
            return true;
        }
        return currentUser.isPresent() && (userByAbbreviation = this.userByAbbreviation(abbreviation)) == currentUser.get();
    }

    static {
        UserSet.abbreviationConfig.ignoredCharacters = User.NOT_ELIGIBLE_ABBREVIATION_CHARS;
        UserSet.abbreviationConfig.maxPerWordChars = 3;
        UserSet.abbreviationConfig.maxWords = 5;
    }
}

