/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.model.user;

import com.google.common.base.CharMatcher;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.scythebill.birdlist.model.user.UserSet;
import java.util.Comparator;
import java.util.Objects;
import javax.annotation.Nullable;

public class User {
    public static final CharMatcher NOT_ELIGIBLE_ABBREVIATION_CHARS = CharMatcher.anyOf(",/ \n");
    private final String name;
    private final String abbreviation;
    private final String id;

    public static Comparator<User> comparator() {
        return Comparator.comparing(user -> Strings.nullToEmpty(user.name())).thenComparing(user -> Strings.nullToEmpty(user.abbreviation()));
    }

    private User(Builder builder) {
        this.name = Strings.emptyToNull(builder.name);
        this.abbreviation = Strings.emptyToNull(builder.abbreviation);
        if (this.name == null && this.abbreviation == null) {
            throw new IllegalStateException("Users must have either a name or an abbreviation");
        }
        this.id = Preconditions.checkNotNull(builder.id);
    }

    public String id() {
        return this.id;
    }

    @Nullable
    public String name() {
        return this.name;
    }

    @Nullable
    public String abbreviation() {
        return this.abbreviation;
    }

    public Builder asBuilder() {
        return new Builder(this);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).omitNullValues().add("name", this.name).add("abbreviation", this.abbreviation).add("id", this.id).toString();
    }

    public static class Builder {
        private String id;
        private String abbreviation;
        private String name;

        Builder() {
        }

        Builder(User user) {
            this.id = user.id;
            this.abbreviation = user.abbreviation;
            this.name = user.name;
        }

        public Builder setName(String name) {
            this.name = CharMatcher.whitespace().trimAndCollapseFrom(name, ' ');
            return this;
        }

        public Builder setAbbreviation(String abbreviation) {
            this.abbreviation = abbreviation;
            return this;
        }

        Builder setId(String id) {
            Preconditions.checkState(this.id == null, "Cannot overwrite an ID");
            this.id = id;
            return this;
        }

        User build() {
            return new User(this);
        }

        public String name() {
            return this.name;
        }

        public String abbreviation() {
            return this.abbreviation;
        }

        String id() {
            return this.id;
        }

        public boolean isValid(UserSet userSet) {
            if (Strings.isNullOrEmpty(this.abbreviation) && Strings.isNullOrEmpty(this.name)) {
                return false;
            }
            if (!Strings.isNullOrEmpty(this.abbreviation) && NOT_ELIGIBLE_ABBREVIATION_CHARS.matchesAnyOf(this.abbreviation)) {
                return false;
            }
            if (!Strings.isNullOrEmpty(this.abbreviation) && userSet.hasUserWithAbbreviation(this.abbreviation)) {
                User userByAbbreviation = userSet.userByAbbreviation(this.abbreviation);
                return userByAbbreviation.id().equals(this.id);
            }
            return true;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Builder)) {
                return false;
            }
            Builder that = (Builder)o;
            return Strings.nullToEmpty(that.abbreviation).equals(Strings.nullToEmpty(this.abbreviation)) && Strings.nullToEmpty(that.name).equals(Strings.nullToEmpty(this.name));
        }

        public int hashCode() {
            return Objects.hash(this.abbreviation, this.name);
        }
    }
}

