/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.model.taxa.names;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.scythebill.birdlist.model.io.CsvImportLines;
import com.scythebill.birdlist.model.io.ImportLines;
import com.scythebill.birdlist.model.taxa.names.NamesLoader;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;

public class NamesLoaders {
    private static final Logger logger = Logger.getLogger(NamesLoaders.class.getName());

    private NamesLoaders() {
    }

    public static NamesLoader fromFiles(String filePattern) {
        return new NamesLoaderImpl(filePattern){

            @Override
            protected ImportLines importLines(String formatted) {
                File file = new File(formatted);
                if (!file.exists()) {
                    return null;
                }
                try {
                    return CsvImportLines.fromFile(file, StandardCharsets.UTF_8);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        };
    }

    public static NamesLoader fromUrls(String urlPattern) {
        return new NamesLoaderImpl(urlPattern){

            @Override
            protected ImportLines importLines(String formatted) {
                ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                URL resource = classLoader.getResource(formatted);
                if (resource == null) {
                    return null;
                }
                try {
                    return CsvImportLines.fromUrl(resource, StandardCharsets.UTF_8);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        };
    }

    static abstract class NamesLoaderImpl
    implements NamesLoader {
        private final String pattern;

        NamesLoaderImpl(String pattern) {
            this.pattern = pattern;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public Map<String, String> load(String locale) {
            String formatted = String.format(this.pattern, locale);
            try {
                ImportLines importLines = this.importLines(formatted);
                if (importLines == null) {
                    return ImmutableMap.of();
                }
                try {
                    ImmutableMap.Builder<String, String> map = ImmutableMap.builder();
                    while (true) {
                        String[] nextLine;
                        if ((nextLine = importLines.nextLine()) == null) {
                            ImmutableMap<String, String> immutableMap = map.build();
                            return immutableMap;
                        }
                        map.put(nextLine[0], nextLine[1]);
                    }
                }
                finally {
                    importLines.close();
                }
            }
            catch (IOException e) {
                logger.severe("Could not load " + formatted);
                return ImmutableMap.of();
            }
        }

        @Override
        public Set<String> findPresentNames(String locale, Set<String> taxonNames) {
            String formatted = String.format(this.pattern, locale);
            try {
                ImportLines importLines = this.importLines(formatted);
                if (importLines == null) {
                    return ImmutableSet.of();
                }
                ImmutableSet.Builder builder = ImmutableSet.builder();
                while (true) {
                    String[] nextLine;
                    if ((nextLine = importLines.nextLine()) == null) {
                        return builder.build();
                    }
                    if (!taxonNames.contains(nextLine[1])) continue;
                    builder.add(nextLine[1]);
                }
            }
            catch (IOException e) {
                return ImmutableSet.of();
            }
        }

        protected abstract ImportLines importLines(String var1);
    }
}

