/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.model.taxa.names;

import com.google.common.base.Preconditions;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.inject.Singleton;
import com.scythebill.birdlist.model.taxa.MappedTaxonomy;
import com.scythebill.birdlist.model.taxa.Species;
import com.scythebill.birdlist.model.taxa.Taxon;
import com.scythebill.birdlist.model.taxa.TaxonUtils;
import com.scythebill.birdlist.model.taxa.Taxonomy;
import com.scythebill.birdlist.model.taxa.names.NamesLoader;
import com.scythebill.birdlist.model.taxa.names.NamesPreferences;
import com.scythebill.birdlist.model.util.Indexer;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;

@Singleton
public class LocalNames {
    private final NamesLoader loader;
    private final NamesPreferences namesPreferences;
    private final LoadingCache<String, Map<String, String>> namesCache = CacheBuilder.newBuilder().maximumSize(2L).build(new CacheLoader<String, Map<String, String>>(){

        @Override
        public Map<String, String> load(String locale) throws Exception {
            return LocalNames.this.loader.load(locale);
        }
    });
    private final LoadingCache<String, Indexer<String>> indexerCache = CacheBuilder.newBuilder().maximumSize(2L).build(new CacheLoader<String, Indexer<String>>(){

        @Override
        public Indexer<String> load(String locale) throws Exception {
            return LocalNames.this.newIndexer(LocalNames.this.namesCache.get(locale));
        }
    });
    private static final LocalNames TRIVIAL = new LocalNames(new NamesLoader(){

        @Override
        public Map<String, String> load(String locale) {
            return ImmutableMap.of();
        }

        @Override
        public Set<String> findPresentNames(String locale, Set<String> taxonNames) {
            return ImmutableSet.of();
        }
    }, new NamesPreferences(), NamesPreferences.LocaleOption.CLEMENTS);
    private NamesPreferences.LocaleOption localeOption;

    public static LocalNames trival() {
        return TRIVIAL;
    }

    public static LocalNames trival(NamesPreferences namesPreferences) {
        return new LocalNames(new NamesLoader(){

            @Override
            public Map<String, String> load(String locale) {
                return ImmutableMap.of();
            }

            @Override
            public Set<String> findPresentNames(String locale, Set<String> taxonNames) {
                return ImmutableSet.of();
            }
        }, namesPreferences, NamesPreferences.LocaleOption.CLEMENTS);
    }

    public Indexer<String> getIndexer() {
        Map<String, String> namesMap = this.namesMap();
        if (namesMap.isEmpty()) {
            return null;
        }
        try {
            return this.indexerCache.get(this.namesPreferences.getLocale(this.localeOption));
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    public LocalNames(NamesLoader loader, NamesPreferences namesPreferences, NamesPreferences.LocaleOption localeOption) {
        this.loader = loader;
        this.namesPreferences = namesPreferences;
        this.localeOption = localeOption;
    }

    public String getCommonName(Taxon taxon) {
        if (taxon.getCommonName() != null) {
            Map<String, String> map = this.namesMap();
            String localityName = map.get(taxon.getId());
            if (localityName != null) {
                return localityName;
            }
            return taxon.getCommonName();
        }
        Taxon parentWithCommonName = LocalNames.getParentWithCommonName(taxon);
        if (parentWithCommonName == null) {
            return TaxonUtils.getFullName(taxon);
        }
        return this.getCommonName(parentWithCommonName) + " (" + TaxonUtils.getAbbreviatedName(taxon) + ")";
    }

    public String getSimpleCommonName(Taxon taxon) {
        Taxon parentWithCommonName = LocalNames.getParentWithCommonName(taxon);
        if (parentWithCommonName == null) {
            return TaxonUtils.getFullName(TaxonUtils.getParentOfType(taxon, Taxon.Type.species));
        }
        return this.getCommonName(parentWithCommonName);
    }

    private static Taxon getParentWithCommonName(Taxon taxon) {
        while (taxon.getCommonName() == null) {
            if ((taxon = taxon.getParent()).getType().compareTo(Taxon.Type.species) <= 0) continue;
            return null;
        }
        return taxon;
    }

    private Map<String, String> namesMap() {
        Map<String, String> map;
        try {
            map = this.namesCache.get(this.namesPreferences.getLocale(this.localeOption));
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e.getCause());
        }
        return map;
    }

    public boolean isCommonNamePreferred() {
        return this.namesPreferences.scientificOrCommon == NamesPreferences.ScientificOrCommon.COMMON_FIRST || this.namesPreferences.scientificOrCommon == NamesPreferences.ScientificOrCommon.COMMON_ONLY;
    }

    public String compoundName(Taxon taxon, boolean abbreviateGenus, Species.Status status) {
        String sciName = !abbreviateGenus ? TaxonUtils.getFullName(taxon) : TaxonUtils.getAbbreviatedName(taxon);
        Taxon parentWithCommonName = LocalNames.getParentWithCommonName(taxon);
        if (parentWithCommonName == null) {
            return String.format("%s - %s", new Object[]{sciName, status});
        }
        switch (this.namesPreferences.scientificOrCommon) {
            case COMMON_FIRST: {
                return String.format("%s - %s (%s)", new Object[]{this.getCommonName(parentWithCommonName), status, sciName});
            }
            case SCIENTIFIC_FIRST: {
                return String.format("%s - %s (%s)", new Object[]{sciName, status, this.getCommonName(parentWithCommonName)});
            }
            case COMMON_ONLY: {
                return String.format("%s - %s", new Object[]{this.getCommonName(taxon), status});
            }
            case SCIENTIFIC_ONLY: {
                return String.format("%s - %s", new Object[]{sciName, status});
            }
        }
        throw new AssertionError();
    }

    public String compoundName(Taxon taxon, boolean abbreviateGenus) {
        String sciName = !abbreviateGenus ? TaxonUtils.getFullName(taxon) : TaxonUtils.getAbbreviatedName(taxon);
        Taxon parentWithCommonName = LocalNames.getParentWithCommonName(taxon);
        if (parentWithCommonName == null) {
            return sciName;
        }
        switch (this.namesPreferences.scientificOrCommon) {
            case COMMON_FIRST: {
                return String.format("%s (%s)", this.getCommonName(parentWithCommonName), sciName);
            }
            case SCIENTIFIC_FIRST: {
                return String.format("%s (%s)", sciName, this.getCommonName(parentWithCommonName));
            }
            case COMMON_ONLY: {
                return this.getCommonName(taxon);
            }
            case SCIENTIFIC_ONLY: {
                return sciName;
            }
        }
        throw new AssertionError();
    }

    private Indexer<String> newIndexer(Map<String, String> map) {
        Indexer<String> indexer = new Indexer<String>();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            indexer.add(entry.getValue(), entry.getKey());
        }
        return indexer;
    }

    public String abbreviatedScientificName(Taxon taxon) {
        if (this.namesPreferences.scientificOrCommon == NamesPreferences.ScientificOrCommon.COMMON_ONLY) {
            return this.getCommonName(taxon);
        }
        return TaxonUtils.getAbbreviatedName(taxon);
    }

    public Set<NamesPreferences.AvailableLocale> availableLocales(Taxonomy taxonomy) {
        if (taxonomy.isBuiltIn()) {
            if (taxonomy instanceof MappedTaxonomy) {
                return ImmutableSet.copyOf(NamesPreferences.AvailableIocLocale.values());
            }
            return ImmutableSet.copyOf(NamesPreferences.AvailableClementsLocale.values());
        }
        return ImmutableSet.of();
    }

    public Multimap<NamesPreferences.AvailableLocale, String> possibleTranslations(Set<NamesPreferences.AvailableLocale> among, Set<String> taxonNames) {
        Multimap<NamesPreferences.AvailableLocale, String> possibilities = Multimaps.newMultimap(new LinkedHashMap(), LinkedHashSet::new);
        for (NamesPreferences.AvailableLocale locale : among) {
            Set<String> presentNames = this.loader.findPresentNames(locale.code(), taxonNames);
            if (presentNames.isEmpty()) continue;
            possibilities.putAll(locale, presentNames);
        }
        return possibilities;
    }

    public NamesPreferences.AvailableLocale currentLocale(Taxonomy taxonomy) {
        if (!taxonomy.isBuiltIn()) {
            return null;
        }
        boolean isIoc = taxonomy instanceof MappedTaxonomy;
        String locale = isIoc ? this.namesPreferences.locale : this.namesPreferences.clementsLocale;
        for (Enum value : isIoc ? NamesPreferences.AvailableIocLocale.values() : NamesPreferences.AvailableClementsLocale.values()) {
            if (!value.code().equals(locale)) continue;
            return value;
        }
        return isIoc ? NamesPreferences.AvailableIocLocale.ENGLISH : NamesPreferences.AvailableClementsLocale.ENGLISH;
    }

    public void setLocale(Taxonomy taxonomy, NamesPreferences.AvailableLocale locale) {
        Preconditions.checkArgument(taxonomy.isBuiltIn());
        if (taxonomy instanceof MappedTaxonomy) {
            this.namesPreferences.locale = locale.code();
        } else {
            this.namesPreferences.clementsLocale = locale.code();
        }
    }
}

