/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.model.taxa;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.scythebill.birdlist.model.checklist.Checklist;
import com.scythebill.birdlist.model.checklist.Checklists;
import com.scythebill.birdlist.model.sighting.Location;
import com.scythebill.birdlist.model.sighting.SightingTaxon;
import com.scythebill.birdlist.model.sighting.SightingTaxons;
import com.scythebill.birdlist.model.taxa.CompletedUpgrade;
import com.scythebill.birdlist.model.taxa.MappedTaxonomy;
import com.scythebill.birdlist.model.taxa.Taxon;
import com.scythebill.birdlist.model.taxa.TaxonUtils;
import com.scythebill.birdlist.model.taxa.Taxonomy;
import com.scythebill.birdlist.model.taxa.TaxonomyMapping;
import com.scythebill.birdlist.model.taxa.UpgradeTracker;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;

class UpgradeTrackerImpl
implements UpgradeTracker,
CompletedUpgrade {
    private final Set<SightingTaxon> needsWarning = Sets.newHashSet();
    private final Set<SightingTaxon> sps = Sets.newHashSet();
    private final Checklists checklists;
    private final MappedTaxonomy mappedTaxonomy;
    private final TaxonomyMapping mapping;
    private ImmutableSet<SightingTaxon> additionalSps;
    private Taxonomy taxonomyForAdditionalSps;

    UpgradeTrackerImpl(Checklists checklists, MappedTaxonomy mappedTaxonomy, TaxonomyMapping mapping) throws IOException {
        this.checklists = checklists;
        this.mappedTaxonomy = mappedTaxonomy;
        this.mapping = mapping;
    }

    @Override
    public SightingTaxon getTaxonId(String recordedTaxonId, boolean shouldWarn) {
        SightingTaxon newTaxonId = this.getTaxonIdInternal(recordedTaxonId);
        if (shouldWarn) {
            if (this.mapping.shouldWarn(newTaxonId)) {
                this.needsWarning.add(newTaxonId);
            }
            if (newTaxonId.getType() == SightingTaxon.Type.SP) {
                this.sps.add(newTaxonId);
            }
        }
        return newTaxonId;
    }

    private SightingTaxon getTaxonIdInternal(String recordedTaxonId) {
        return this.mapping.mapSingleTaxon(recordedTaxonId);
    }

    @Override
    public SightingTaxon getTaxonIdOfSightingWithSsp(SightingTaxon recordedTaxonId, boolean shouldWarn) {
        Taxon iocTaxon;
        Preconditions.checkState(recordedTaxonId.getType() == SightingTaxon.Type.SINGLE_WITH_SECONDARY_SUBSPECIES);
        SightingTaxon explicitMapping = this.mapping.mapSingleWithSecondarySubspecies(recordedTaxonId);
        if (explicitMapping != null) {
            return explicitMapping;
        }
        SightingTaxon mainTaxonMapping = this.getTaxonId(recordedTaxonId.getId(), shouldWarn);
        SightingTaxon.Resolved resolved = mainTaxonMapping.resolve(this.mappedTaxonomy);
        if (resolved == null) {
            return mainTaxonMapping;
        }
        Taxon foundSubspecies = null;
        Iterator<Taxon> iterator = resolved.getTaxa().iterator();
        while (iterator.hasNext() && (foundSubspecies = this.findSubspecies(TaxonUtils.getParentOfType(iocTaxon = iterator.next(), Taxon.Type.species), recordedTaxonId.getSubIdentifier())) == null) {
        }
        if (foundSubspecies == null) {
            return this.attemptToPreserveSspMapping(recordedTaxonId, mainTaxonMapping);
        }
        SightingTaxon newMapping = this.mappedTaxonomy.getMapping(foundSubspecies);
        if (newMapping == null) {
            return this.attemptToPreserveSspMapping(recordedTaxonId, mainTaxonMapping);
        }
        return newMapping;
    }

    private SightingTaxon attemptToPreserveSspMapping(SightingTaxon recordedTaxonId, SightingTaxon mainTaxonMapping) {
        if (mainTaxonMapping.getType() == SightingTaxon.Type.SINGLE) {
            return SightingTaxons.newSightingTaxonWithSecondarySubspecies(mainTaxonMapping.getId(), recordedTaxonId.getSubIdentifier());
        }
        return mainTaxonMapping;
    }

    private Taxon findSubspecies(Taxon iocTaxon, String subIdentifier) {
        if (iocTaxon.getType() == Taxon.Type.subspecies && subIdentifier.equals(iocTaxon.getName())) {
            return iocTaxon;
        }
        for (Taxon child : iocTaxon.getContents()) {
            Taxon found = this.findSubspecies(child, subIdentifier);
            if (found == null) continue;
            return found;
        }
        return null;
    }

    @Override
    public SightingTaxon getChecklistResolvedTaxonId(Taxonomy taxonomy, String recordedTaxonId, Location location) {
        Checklist checklist;
        SightingTaxon newTaxonId = this.mapping.mapSingleTaxon(recordedTaxonId);
        if (newTaxonId.getType() == SightingTaxon.Type.SP && (checklist = this.checklists.getNearestBuiltInChecklist(taxonomy, null, location)) != null) {
            HashSet<String> plausibleIds = Sets.newHashSet();
            for (String id : newTaxonId.getIds()) {
                SightingTaxon sightingTaxon = SightingTaxons.newSightingTaxon(id);
                SightingTaxon.Resolved resolved = sightingTaxon.resolve(taxonomy);
                if (resolved.getSmallestTaxonType() != Taxon.Type.species) {
                    return newTaxonId;
                }
                if (checklist.getStatus(taxonomy, sightingTaxon) == null) continue;
                plausibleIds.add(id);
            }
            if (plausibleIds.isEmpty()) {
                return newTaxonId;
            }
            return SightingTaxons.newPossiblySpTaxon(plausibleIds);
        }
        return newTaxonId;
    }

    @Override
    public Collection<SightingTaxon> warnings() {
        return Collections.unmodifiableSet(this.needsWarning);
    }

    @Override
    public Collection<SightingTaxon> sps(Taxonomy taxonomy) {
        if (this.taxonomyForAdditionalSps != null && this.additionalSps != null && taxonomy == this.taxonomyForAdditionalSps) {
            return Collections.unmodifiableSet(Sets.union(this.sps, this.additionalSps));
        }
        return Collections.unmodifiableSet(this.sps);
    }

    @Override
    public String getPreviousTaxonomyId() {
        return this.mapping.getPreviousTaxonomyId();
    }

    @Override
    public Iterable<String> getTaxonId(Taxonomy taxonomy, Iterable<String> taxa, boolean shouldWarn) {
        LinkedHashSet<String> mappedTaxa = Sets.newLinkedHashSet();
        for (String taxon : taxa) {
            mappedTaxa.addAll(this.getTaxonIdInternal(taxon).getIds());
        }
        return TaxonUtils.simplifyTaxa(this.mappedTaxonomy.getBaseTaxonomy(), mappedTaxa);
    }

    @Override
    public CompletedUpgrade getCompletedUpgrade() {
        return this;
    }

    @Override
    public String getNewTaxonomyName() {
        return this.mappedTaxonomy.getBaseTaxonomy().getName();
    }

    @Override
    public Taxonomy getForcedTaxonomy() {
        return null;
    }

    @Override
    public void applyAdditionalSps(Taxonomy onlyForTaxonomy, ImmutableSet<SightingTaxon> additionalSps) {
        this.additionalSps = additionalSps;
        this.taxonomyForAdditionalSps = onlyForTaxonomy;
    }
}

