/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.model.taxa;

import com.google.common.collect.ImmutableSet;
import com.google.inject.Inject;
import com.opencsv.exceptions.CsvValidationException;
import com.scythebill.birdlist.model.checklist.Checklists;
import com.scythebill.birdlist.model.sighting.SightingTaxon;
import com.scythebill.birdlist.model.taxa.IocUpgradeLoader;
import com.scythebill.birdlist.model.taxa.MappedTaxonomy;
import com.scythebill.birdlist.model.taxa.TaxonomyMapping;
import com.scythebill.birdlist.model.taxa.TaxonomyMappingLoader;
import com.scythebill.birdlist.model.taxa.UnsupportedTaxonomyException;
import com.scythebill.birdlist.model.taxa.UpgradeTracker;
import com.scythebill.birdlist.model.taxa.UpgradeTrackerImpl;
import java.io.IOException;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class TaxonomyMappings {
    private final Map<String, TaxonomyMappingLoader> mappingLoaders;
    private final Map<String, IocUpgradeLoader> iocLoaders;
    private final Checklists checklists;

    @Inject
    public TaxonomyMappings(Set<TaxonomyMappingLoader> mappingLoaders, Set<IocUpgradeLoader> iocLoaders, Checklists checklists) {
        this.checklists = checklists;
        this.mappingLoaders = mappingLoaders.stream().collect(Collectors.toMap(TaxonomyMappingLoader::getId, l -> l));
        this.iocLoaders = iocLoaders.stream().collect(Collectors.toMap(IocUpgradeLoader::getId, l -> l));
    }

    public UpgradeTracker getTracker(String recordedTaxonomyId, MappedTaxonomy mappedTaxonomy) throws IOException, CsvValidationException {
        TaxonomyMappingLoader loader = this.mappingLoaders.get(recordedTaxonomyId);
        if (loader == null) {
            throw new UnsupportedTaxonomyException("No mapping for taxonomy " + recordedTaxonomyId, recordedTaxonomyId);
        }
        TaxonomyMapping mapping = loader.loadMapping();
        return new UpgradeTrackerImpl(this.checklists, mappedTaxonomy, mapping);
    }

    public ImmutableSet<SightingTaxon> getIocAffectedSightingTaxa(String recordedIocTaxonomy) throws IOException {
        IocUpgradeLoader iocUpgradeLoader = this.iocLoaders.get(recordedIocTaxonomy);
        if (iocUpgradeLoader == null) {
            return ImmutableSet.of();
        }
        return iocUpgradeLoader.affectedSightingTaxa();
    }

    public void registerMapping(TaxonomyMappingLoader mapping, String fromId) {
        this.mappingLoaders.put(fromId, mapping);
    }
}

