/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.model.taxa;

import com.google.common.base.Splitter;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.io.CharSource;
import com.opencsv.CSVReader;
import com.opencsv.exceptions.CsvValidationException;
import com.scythebill.birdlist.model.sighting.SightingTaxon;
import com.scythebill.birdlist.model.sighting.SightingTaxons;
import com.scythebill.birdlist.model.taxa.TaxonomyMapping;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;

public class TaxonomyMappingLoader {
    private static final Splitter MULTI_SPLITTER = Splitter.on(',');
    private final String id;
    private final CharSource mappingSupplier;
    private final CharSource iocSspSupplement;

    public TaxonomyMappingLoader(String id, CharSource mappingSupplier, @Nullable CharSource iocSspSupplement) {
        this.id = id;
        this.mappingSupplier = mappingSupplier;
        this.iocSspSupplement = iocSspSupplement;
    }

    public String getId() {
        return this.id;
    }

    public TaxonomyMapping loadMapping() throws IOException, CsvValidationException {
        return new LoadedMapping();
    }

    private class LoadedMapping
    implements TaxonomyMapping {
        private final Map<String, SightingTaxon> mapping = Maps.newHashMap();
        private final Map<SightingTaxon, SightingTaxon> sspSupplement = Maps.newHashMap();
        private final Set<SightingTaxon> warnings = Sets.newHashSet();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        LoadedMapping() throws IOException, CsvValidationException {
            BufferedReader input = TaxonomyMappingLoader.this.mappingSupplier.openBufferedStream();
            try (CSVReader csv = new CSVReader(input);){
                String[] line;
                while ((line = csv.readNext()) != null) {
                    String from = line[1];
                    String to = line[2];
                    if (!from.isEmpty() && !to.isEmpty()) {
                        if (this.mapping.containsKey(from)) {
                            throw new IllegalStateException("Two mappings for " + from);
                        }
                        if ("MULT".equals(line[0])) {
                            Iterable<String> split = MULTI_SPLITTER.split(to);
                            SightingTaxon spTaxon = SightingTaxons.newSpTaxon(split);
                            this.mapping.put(from, spTaxon);
                        } else {
                            this.mapping.put(from, SightingTaxons.newSightingTaxon(to));
                        }
                    }
                    if (!"WARN".equals(line[0])) continue;
                    this.warnings.add(SightingTaxons.newSightingTaxon(line[2]));
                }
            }
            if (TaxonomyMappingLoader.this.iocSspSupplement != null) {
                BufferedReader supplementInput = TaxonomyMappingLoader.this.iocSspSupplement.openBufferedStream();
                try (CSVReader supplementCsv = new CSVReader(supplementInput);){
                    String[] line;
                    while ((line = supplementCsv.readNext()) != null) {
                        SightingTaxon iocSsp = SightingTaxons.newSightingTaxonWithSecondarySubspecies(line[0], line[1]);
                        SightingTaxon mappedSsp = SightingTaxons.newSightingTaxon(line[2]);
                        this.sspSupplement.put(iocSsp, mappedSsp);
                    }
                }
            }
        }

        @Override
        public SightingTaxon mapSingleTaxon(String id) {
            return this.mapping.get(id);
        }

        @Override
        public SightingTaxon mapSingleWithSecondarySubspecies(SightingTaxon sightingTaxon) {
            return this.sspSupplement.get(sightingTaxon);
        }

        @Override
        public boolean shouldWarn(SightingTaxon newTaxonId) {
            return this.warnings.contains(newTaxonId);
        }

        @Override
        public String getPreviousTaxonomyId() {
            return TaxonomyMappingLoader.this.getId();
        }
    }
}

