/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.model.taxa;

import com.google.common.base.CharMatcher;
import com.google.common.base.Preconditions;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.scythebill.birdlist.model.sighting.SightingTaxon;
import com.scythebill.birdlist.model.sighting.SightingTaxons;
import com.scythebill.birdlist.model.taxa.Taxon;
import com.scythebill.birdlist.model.taxa.TaxonImpl;
import com.scythebill.birdlist.model.taxa.Taxonomy;
import com.scythebill.birdlist.model.taxa.names.LocalNames;
import com.scythebill.birdlist.model.util.AlternateName;
import com.scythebill.birdlist.model.util.Indexer;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TaxonomyImpl
implements Taxonomy {
    private Taxon root;
    private final BiMap<String, Taxon> taxa = HashBiMap.create();
    private final List<String> additionalCredits = Lists.newArrayList();
    private final String name;
    private final String id;
    private LocalNames localNames = LocalNames.trival();
    private volatile int speciesCount = 0;
    private volatile int taxonCount = 0;
    private volatile Indexer<String> commonIndexer;
    private volatile Indexer<String> scientificIndexer;
    private final String accountUrlFormat;
    private final String accountLinkTitle;
    private static final CharMatcher ILLEGAL_ID_CHARACTERS = CharMatcher.anyOf("|,");
    private static final Map<Taxon.Type, String> ID_PREFIXES = new HashMap<Taxon.Type, String>();
    private Indexer<AlternateName<String>> alternateCommonIndexer;
    private Indexer<AlternateName<String>> alternateSciIndexer;

    public TaxonomyImpl(String id, String name, String accountUrlFormat, String accountLinkTitle) {
        this.id = id;
        this.name = name;
        this.accountUrlFormat = accountUrlFormat;
        this.accountLinkTitle = accountLinkTitle;
    }

    public TaxonomyImpl() {
        this(null, null, null, null);
    }

    public void setRoot(Taxon taxon) {
        Preconditions.checkState(this.root == null, "Root to taxonomy already set");
        this.root = taxon;
    }

    @Override
    public Taxon getRoot() {
        return this.root;
    }

    @Override
    public Taxon findSpecies(String fullName) {
        int space = fullName.indexOf(32);
        if (space < 1) {
            throw new IllegalArgumentException("'" + fullName + "' does not contain a space");
        }
        String genusName = fullName.substring(0, space);
        Taxon genus = this.root.findByName(genusName, Taxon.Type.genus);
        if (genus == null) {
            return null;
        }
        String speciesName = fullName.substring(space + 1);
        return genus.findByName(speciesName, Taxon.Type.species);
    }

    @Override
    public String getId(Taxon taxon) {
        return (String)this.taxa.inverse().get(taxon);
    }

    @Override
    public Taxon getTaxon(String id) {
        return (Taxon)this.taxa.get(id);
    }

    public void register(Taxon taxon, String id) {
        if (taxon == null || id == null) {
            throw new NullPointerException();
        }
        if (taxon.getType() == Taxon.Type.species) {
            ++this.speciesCount;
        }
        if (ILLEGAL_ID_CHARACTERS.matchesAnyOf(id)) {
            throw new IllegalArgumentException("Illegal ID: " + id);
        }
        Taxon existingTaxonForKey = this.taxa.put(id, taxon);
        if (existingTaxonForKey != null) {
            this.taxa.put(id, existingTaxonForKey);
            throw new IllegalArgumentException(id + " is already present as " + existingTaxonForKey);
        }
        ((TaxonImpl)taxon).setIndex(this.taxonCount++);
    }

    @Override
    public void registerWithNewId(Taxon taxon) {
        Preconditions.checkNotNull(taxon);
        String id = this._calculateId(taxon);
        this.register(taxon, id);
    }

    @Override
    public void unregister(Taxon taxon) {
        Preconditions.checkArgument(taxon.getTaxonomy() == this, "Not registered with this taxonomy");
        this.taxa.inverse().remove(taxon);
        if (taxon.getType() == Taxon.Type.species) {
            --this.speciesCount;
        }
    }

    @Override
    public BiMap<String, Taxon> asBimap() {
        return Maps.unmodifiableBiMap(this.taxa);
    }

    private String _calculateId(Taxon taxon) {
        StringBuilder builder = new StringBuilder(16);
        builder.append(ID_PREFIXES.get((Object)taxon.getType()));
        int shortNameLength = 3;
        switch (taxon.getType()) {
            case species: 
            case group: 
            case subspecies: {
                Taxon parent = taxon.getParent();
                if (parent == null) {
                    throw new NullPointerException(taxon + " does not have a parent.");
                }
                String parentPrefix = ID_PREFIXES.get((Object)parent.getType());
                String parentName = parent.getId().substring(parentPrefix.length());
                builder.append(parentName);
                break;
            }
            case genus: {
                shortNameLength = 5;
                break;
            }
        }
        builder.append(TaxonomyImpl._getShortName(taxon.getName(), shortNameLength));
        int baseLength = builder.length();
        String id = null;
        int i = 0;
        while (true) {
            if (i > 0) {
                builder.append(Integer.toString(i));
            }
            if (!this.taxa.containsKey(id = builder.toString())) break;
            builder.setLength(baseLength);
            ++i;
        }
        return id;
    }

    private static String _getShortName(String fullName, int shortNameLength) {
        if (fullName == null) {
            return "";
        }
        return CharMatcher.whitespace().trimFrom(fullName.substring(0, Math.min(shortNameLength, fullName.length())));
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int getSpeciesCount() {
        return this.speciesCount;
    }

    @Override
    public Collection<String> additionalCredits() {
        return Collections.unmodifiableList(this.additionalCredits);
    }

    public void addAdditionalCredit(String additionalCredit) {
        this.additionalCredits.add(additionalCredit);
    }

    @Override
    public SightingTaxon.Resolved resolveInto(SightingTaxon sightingTaxon) {
        return sightingTaxon.resolveInternal(this);
    }

    @Override
    public void setCommonIndexer(Indexer<String> commonIndexer) {
        this.commonIndexer = commonIndexer;
    }

    @Override
    public Indexer<String> getCommonIndexer() {
        return this.commonIndexer;
    }

    @Override
    public void setScientificIndexer(Indexer<String> sciIndexer) {
        this.scientificIndexer = sciIndexer;
    }

    @Override
    public Indexer<String> getScientificIndexer() {
        return this.scientificIndexer;
    }

    @Override
    public SightingTaxon toBaseSightingTaxon(String id) {
        return SightingTaxons.newSightingTaxon(id);
    }

    @Override
    public void setAlternateCommonIndexer(Indexer<AlternateName<String>> alternateCommonIndexer) {
        this.alternateCommonIndexer = alternateCommonIndexer;
    }

    @Override
    public Indexer<AlternateName<String>> getAlternateCommonIndexer() {
        return this.alternateCommonIndexer;
    }

    @Override
    public void setAlternateScientificIndexer(Indexer<AlternateName<String>> alternateSciIndexer) {
        this.alternateSciIndexer = alternateSciIndexer;
    }

    @Override
    public Indexer<AlternateName<String>> getAlternateScientificIndexer() {
        return this.alternateSciIndexer;
    }

    @Override
    public LocalNames getLocalNames() {
        return this.localNames;
    }

    public void setLocalNames(LocalNames localNames) {
        this.localNames = Preconditions.checkNotNull(localNames);
    }

    @Override
    public Indexer<String> getLocalizedCommonIndexer() {
        return this.localNames.getIndexer();
    }

    @Override
    public boolean isBuiltIn() {
        return true;
    }

    @Override
    public String getTaxonAccountUrl(String taxonAccountId) {
        if (this.accountUrlFormat == null) {
            return null;
        }
        return this.accountUrlFormat.replace("{id}", taxonAccountId);
    }

    @Override
    public String getAccountLinkTitle() {
        return this.accountLinkTitle;
    }

    static {
        ID_PREFIXES.put(Taxon.Type.classTaxon, "class");
        ID_PREFIXES.put(Taxon.Type.family, "fam");
        ID_PREFIXES.put(Taxon.Type.genus, "ge");
        ID_PREFIXES.put(Taxon.Type.order, "ord");
        ID_PREFIXES.put(Taxon.Type.phylum, "phylum");
        ID_PREFIXES.put(Taxon.Type.species, "sp");
        ID_PREFIXES.put(Taxon.Type.group, "gr");
        ID_PREFIXES.put(Taxon.Type.subspecies, "ssp");
    }
}

