/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.model.taxa;

import com.google.common.collect.BiMap;
import com.scythebill.birdlist.model.sighting.SightingTaxon;
import com.scythebill.birdlist.model.taxa.Taxon;
import com.scythebill.birdlist.model.taxa.names.LocalNames;
import com.scythebill.birdlist.model.util.AlternateName;
import com.scythebill.birdlist.model.util.Indexer;
import java.util.Collection;

public interface Taxonomy {
    public String getId();

    public String getName();

    public Collection<String> additionalCredits();

    public Taxon getRoot();

    public String getId(Taxon var1);

    public Taxon getTaxon(String var1);

    public BiMap<String, Taxon> asBimap();

    public Taxon findSpecies(String var1);

    public void registerWithNewId(Taxon var1);

    public void unregister(Taxon var1);

    public int getSpeciesCount();

    public SightingTaxon.Resolved resolveInto(SightingTaxon var1);

    public void setCommonIndexer(Indexer<String> var1);

    public Indexer<String> getCommonIndexer();

    public void setScientificIndexer(Indexer<String> var1);

    public Indexer<String> getScientificIndexer();

    public void setAlternateCommonIndexer(Indexer<AlternateName<String>> var1);

    public Indexer<String> getLocalizedCommonIndexer();

    public Indexer<AlternateName<String>> getAlternateCommonIndexer();

    public void setAlternateScientificIndexer(Indexer<AlternateName<String>> var1);

    public Indexer<AlternateName<String>> getAlternateScientificIndexer();

    public SightingTaxon toBaseSightingTaxon(String var1);

    public LocalNames getLocalNames();

    public boolean isBuiltIn();

    public String getTaxonAccountUrl(String var1);

    public String getAccountLinkTitle();
}

