/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.model.taxa;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import com.scythebill.birdlist.model.checklist.Checklist;
import com.scythebill.birdlist.model.sighting.SightingTaxon;
import com.scythebill.birdlist.model.taxa.MappedTaxonomy;
import com.scythebill.birdlist.model.taxa.Species;
import com.scythebill.birdlist.model.taxa.Taxon;
import com.scythebill.birdlist.model.taxa.TaxonVisitor;
import com.scythebill.birdlist.model.taxa.Taxonomy;
import com.scythebill.birdlist.model.taxa.names.LocalNames;
import com.scythebill.birdlist.model.util.ResolvedComparator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;

public class TaxonUtils {
    public static final Ordering<Taxon> ORDERING = new Ordering<Taxon>(){

        @Override
        public int compare(Taxon left, Taxon right) {
            return left.getTaxonomyIndex() - right.getTaxonomyIndex();
        }
    };

    private TaxonUtils() {
    }

    public static boolean isChildOfOrSame(Taxon parent, String childId) {
        if (childId.equals(parent.getId())) {
            return true;
        }
        Taxon child = parent.getTaxonomy().getTaxon(childId);
        return TaxonUtils.isChildOf(parent, child);
    }

    public static boolean isItselfOrAChildIn(Taxon taxon, Collection<String> taxonIds) {
        if (taxonIds.contains(taxon.getId())) {
            return true;
        }
        for (Taxon child : taxon.getContents()) {
            if (!TaxonUtils.isItselfOrAChildIn(child, taxonIds)) continue;
            return true;
        }
        return false;
    }

    public static boolean isChildOf(Taxon parent, Taxon child) {
        while (child.getType().compareTo(parent.getType()) < 0) {
            if ((child = child.getParent()) != parent) continue;
            return true;
        }
        return false;
    }

    public static Taxon getParentOfAtLeastType(Taxon taxon, Taxon.Type type) {
        Taxon parent = taxon;
        while (parent.getType().compareTo(type) < 0) {
            Preconditions.checkState((parent = parent.getParent()) != null);
        }
        return parent;
    }

    public static Taxon getParentOfType(Taxon taxon, Taxon.Type type) {
        Taxon parent = TaxonUtils.getParentOfTypeOrNull(taxon, type);
        Preconditions.checkState(parent != null);
        return parent;
    }

    public static boolean hasParentOfType(Taxon taxon, Taxon.Type type) {
        Taxon parent = TaxonUtils.getParentOfTypeOrNull(taxon, type);
        return parent != null;
    }

    public static Taxon getParentOfTypeOrNull(Taxon taxon, Taxon.Type type) {
        Taxon parent;
        for (parent = taxon; parent != null && parent.getType() != type; parent = parent.getParent()) {
        }
        return parent;
    }

    public static String getFullName(Taxon taxon) {
        if (taxon.getType() == Taxon.Type.species) {
            return taxon.getParent().getName() + " " + taxon.getName();
        }
        if (taxon.getType() == Taxon.Type.group || taxon.getType() == Taxon.Type.subspecies) {
            Taxon species = TaxonUtils.getParentOfType(taxon, Taxon.Type.species);
            return TaxonUtils.getFullName(species) + " " + taxon.getName();
        }
        return taxon.getName();
    }

    public static String getCommonName(Taxon taxon) {
        LocalNames localNames = taxon.getTaxonomy().getLocalNames();
        return localNames.getCommonName(taxon);
    }

    public static String getEnglishCommonName(Taxon taxon) {
        return LocalNames.trival().getCommonName(taxon);
    }

    public static String getSimpleCommonName(Taxon taxon) {
        LocalNames localNames = taxon.getTaxonomy().getLocalNames();
        return localNames.getSimpleCommonName(taxon);
    }

    public static String getAbbreviatedName(Taxon taxon) {
        if (taxon.getType() == Taxon.Type.species) {
            return taxon.getParent().getName().substring(0, 1) + "." + taxon.getName();
        }
        if (taxon.getType() == Taxon.Type.group || taxon.getType() == Taxon.Type.subspecies) {
            Taxon species = TaxonUtils.getParentOfType(taxon, Taxon.Type.species);
            Taxon genus = species.getParent();
            return genus.getName().substring(0, 1) + "." + species.getName().substring(0, 1) + "." + taxon.getName();
        }
        return taxon.getName();
    }

    public static int sortedInsert(List<SightingTaxon.Resolved> list, SightingTaxon.Resolved taxon) {
        Preconditions.checkNotNull(list);
        Preconditions.checkNotNull(taxon);
        int index = Collections.binarySearch(list, taxon, new ResolvedComparator());
        if (index >= 0) {
            return -1;
        }
        index = -(index + 1);
        list.add(index, taxon);
        return index;
    }

    public static int countChildren(Taxon taxon, Taxon.Type type, Checklist checklist, Checklist.Status ... excluding) {
        return TaxonUtils.countChildren(taxon, type, checklist, ImmutableSet.copyOf(excluding));
    }

    public static int countFamilies(Taxonomy taxonomy, @Nullable Checklist checklist, Checklist.Status ... excluding) {
        if (checklist == null) {
            AtomicInteger familyCount = new AtomicInteger();
            TaxonUtils.visitTaxa(taxonomy, (Taxon taxon) -> {
                if (taxon.getType() == Taxon.Type.family) {
                    familyCount.incrementAndGet();
                    return false;
                }
                return true;
            });
            return familyCount.get();
        }
        ImmutableSet<Checklist.Status> invalidStatuses = ImmutableSet.copyOf(excluding);
        long count = checklist.getTaxa(taxonomy).stream().filter(taxon -> !invalidStatuses.contains((Object)checklist.getStatus(taxonomy, (SightingTaxon)taxon))).map(taxon -> taxon.resolveInternal(taxonomy)).map(resolved -> resolved.getParentOfAtLeastType(Taxon.Type.family)).distinct().count();
        return (int)count;
    }

    public static int countChildren(Taxon taxon, Taxon.Type type, Checklist checklist, Set<Checklist.Status> excluding) {
        int total = 0;
        for (Taxon child : taxon.getContents()) {
            if (child.getType() == type) {
                if (checklist != null && !checklist.includesTaxon(child, excluding)) continue;
                ++total;
                continue;
            }
            total += TaxonUtils.countChildren(child, type, checklist, excluding);
        }
        return total;
    }

    public static Taxon getFirstChildOfType(Taxon taxon, final Taxon.Type type) {
        final AtomicReference foundTaxon = new AtomicReference();
        TaxonUtils.visitTaxa(taxon, new TaxonVisitor(){

            @Override
            public boolean visitTaxon(Taxon taxon) {
                if (foundTaxon.get() != null) {
                    return false;
                }
                if (taxon.getType() == type) {
                    foundTaxon.set(taxon);
                    return false;
                }
                return true;
            }
        });
        return (Taxon)foundTaxon.get();
    }

    public static void visitTaxa(Taxonomy taxonomy, TaxonVisitor visitor) {
        TaxonUtils.visitTaxa(taxonomy.getRoot(), visitor);
    }

    public static void visitTaxa(Taxon taxon, TaxonVisitor visitor) {
        if (visitor.visitTaxon(taxon)) {
            for (Taxon child : taxon.getContents()) {
                TaxonUtils.visitTaxa(child, visitor);
            }
        }
    }

    public static Set<String> getTaxaAtLevel(Iterable<SightingTaxon.Resolved> taxa, Taxon.Type type) {
        HashSet<String> set = Sets.newHashSet();
        for (SightingTaxon.Resolved taxon : taxa) {
            Object parent;
            if (taxon.getType() == SightingTaxon.Type.SINGLE) {
                if (taxon.getSmallestTaxonType().compareTo(type) > 0 || (parent = TaxonUtils.getParentOfTypeOrNull(taxon.getTaxon(), type)) == null) continue;
                set.add(parent.getId());
                continue;
            }
            if (taxon.getSmallestTaxonType().compareTo(type) >= 0 || (parent = taxon.getParentOfAtLeastType(type)).getType() != SightingTaxon.Type.SINGLE) continue;
            set.add(parent.getId());
        }
        return set;
    }

    public static List<Taxon> getTaxa(Taxonomy taxonomy, Collection<String> ids, boolean includeFamilies) {
        ArrayList<Taxon> list = new ArrayList<Taxon>(ids.size());
        TaxonUtils._addTaxa(list, taxonomy, taxonomy.getRoot(), ids, includeFamilies, null);
        return list;
    }

    private static boolean _addTaxa(List<Taxon> list, Taxonomy taxonomy, Taxon taxon, Collection<String> ids, boolean includeFamilies, Taxon currentFamily) {
        boolean added = false;
        if (ids.contains(taxonomy.getId(taxon))) {
            if (includeFamilies && currentFamily != null) {
                list.add(currentFamily);
            }
            list.add(taxon);
            added = true;
            currentFamily = null;
        }
        if (taxon.getType() == Taxon.Type.family) {
            currentFamily = taxon;
        }
        for (Taxon child : taxon.getContents()) {
            if (!TaxonUtils._addTaxa(list, taxonomy, child, ids, includeFamilies, currentFamily)) continue;
            added = true;
            currentFamily = null;
        }
        return added;
    }

    public static String getRange(Species species) {
        if (species.getRange() != null) {
            return species.getRange();
        }
        StringBuilder rangesOfChildren = new StringBuilder();
        for (Taxon child : species.getContents()) {
            Species childSpecies;
            String childRange;
            if (!(child instanceof Species) || (childRange = TaxonUtils.getRange(childSpecies = (Species)child)) == null) continue;
            if (rangesOfChildren.length() > 0) {
                rangesOfChildren.append(";");
            }
            rangesOfChildren.append(childRange);
        }
        if (rangesOfChildren.length() == 0) {
            return null;
        }
        return rangesOfChildren.toString();
    }

    public static Species.Status getTaxonStatus(Taxon taxon) {
        Species.Status status = Species.Status.LC;
        do {
            Species.Status taxonStatus;
            if ((taxonStatus = ((Species)taxon).getStatus()).compareTo(status) <= 0) continue;
            status = taxonStatus;
        } while ((taxon = taxon.getParent()).getType().compareTo(Taxon.Type.species) <= 0);
        return status;
    }

    public static Taxon getSharedParent(Taxon first, Taxon second) {
        if (first == second) {
            return first;
        }
        if (first.getType() == second.getType()) {
            return TaxonUtils.getSharedParent(first.getParent(), second.getParent());
        }
        if (first.getType().compareTo(second.getType()) < 0) {
            return TaxonUtils.getSharedParent(first.getParent(), second);
        }
        return TaxonUtils.getSharedParent(first, second.getParent());
    }

    public static Taxon getPreviousSibling(Taxon taxon) {
        Taxon parent = taxon.getParent();
        if (parent == null) {
            return null;
        }
        Taxon previous = null;
        for (Taxon child : parent.getContents()) {
            if (child == taxon) {
                return previous;
            }
            previous = child;
        }
        return null;
    }

    public static Taxon getNextSibling(Taxon taxon) {
        Taxon parent = taxon.getParent();
        if (parent == null) {
            return null;
        }
        boolean found = false;
        for (Taxon child : parent.getContents()) {
            if (found) {
                return child;
            }
            if (child != taxon) continue;
            found = true;
        }
        return null;
    }

    public static Taxonomy getBaseTaxonomy(Taxonomy taxonomy) {
        if (taxonomy instanceof MappedTaxonomy) {
            return ((MappedTaxonomy)taxonomy).getBaseTaxonomy();
        }
        return taxonomy;
    }

    public static boolean areCompatible(Taxonomy taxonomy, Taxonomy taxonomy2) {
        return TaxonUtils.getBaseTaxonomy(taxonomy) == TaxonUtils.getBaseTaxonomy(taxonomy2);
    }

    public static Set<String> mapToCommonLevel(Taxonomy taxonomy, Set<String> taxonIds) {
        Taxon.Type highestType = null;
        boolean multipleTypes = false;
        ArrayList<Taxon> taxa = Lists.newArrayList();
        for (String taxonId : taxonIds) {
            Taxon taxon = taxonomy.getTaxon(taxonId);
            taxa.add(taxon);
            if (highestType == null) {
                highestType = taxon.getType();
                continue;
            }
            if (highestType == taxon.getType()) continue;
            multipleTypes = true;
            if (taxon.getType().compareTo(highestType) <= 0) continue;
            highestType = taxon.getType();
        }
        if (multipleTypes) {
            taxonIds = Sets.newLinkedHashSet();
            for (Taxon taxon : taxa) {
                taxonIds.add(TaxonUtils.getParentOfType(taxon, highestType).getId());
            }
        }
        return taxonIds;
    }

    public static List<Taxon> getDescendantsOfType(Taxon taxon, final Taxon.Type type) {
        final ArrayList<Taxon> list = new ArrayList<Taxon>();
        TaxonUtils.visitTaxa(taxon, new TaxonVisitor(){

            @Override
            public boolean visitTaxon(Taxon taxon) {
                if (taxon.getType() == type) {
                    list.add(taxon);
                    return false;
                }
                return true;
            }
        });
        return list;
    }

    public static Collection<String> simplifyTaxa(Taxonomy taxonomy, Collection<String> taxa) {
        if (taxa.size() == 1) {
            return taxa;
        }
        for (String id : taxa) {
            Taxon taxon = taxonomy.getTaxon(id);
            if (taxon.getType() == Taxon.Type.species) continue;
            Taxon parent = taxon.getParent();
            LinkedHashSet<String> childIds = Sets.newLinkedHashSet();
            for (Taxon child : parent.getContents()) {
                childIds.add(child.getId());
            }
            if (!taxa.containsAll(childIds)) continue;
            LinkedHashSet<String> simplifiedIds = Sets.newLinkedHashSet(taxa);
            simplifiedIds.removeAll(childIds);
            simplifiedIds.add(parent.getId());
            return TaxonUtils.simplifyTaxa(taxonomy, simplifiedIds);
        }
        return taxa;
    }
}

