/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.model.taxa;

import com.google.common.base.Objects;
import com.scythebill.birdlist.model.sighting.SightingTaxon;
import com.scythebill.birdlist.model.taxa.Species;
import com.scythebill.birdlist.model.taxa.Taxon;
import com.scythebill.birdlist.model.taxa.Taxonomy;
import java.util.ArrayList;
import java.util.List;

public class TaxonImpl
implements Taxon {
    private final Taxon.Type type;
    private Taxon parent;
    private String commonName;
    private String name;
    private List<Taxon> contents;
    private Taxonomy taxonomy;
    private int index;
    private boolean disabled;
    private String accountId;
    private String conceptId;

    public TaxonImpl(Taxon.Type type, Taxonomy tx) {
        this(type, null, tx);
    }

    public TaxonImpl(Taxon.Type type, Taxon parent) {
        this(type, parent, parent == null ? null : parent.getTaxonomy());
    }

    private TaxonImpl(Taxon.Type type, Taxon parent, Taxonomy tx) {
        if (type == null) {
            throw new NullPointerException();
        }
        this.taxonomy = tx;
        this.type = type;
        this.setParent(parent);
    }

    @Override
    public void built() {
        this.getTaxonomy().registerWithNewId(this);
    }

    public void setParent(Taxon parent) {
        this.parent = parent;
        if (parent != null) {
            if (parent.getType().compareTo(this.getType()) <= 0) {
                throw new IllegalStateException("Cannot add " + this.getType() + " to " + parent.getType());
            }
            this.taxonomy = parent.getTaxonomy();
            if (this.contents != null) {
                for (Taxon child : this.contents) {
                    ((TaxonImpl)child).setParent(this);
                }
            }
        }
    }

    @Override
    public Taxonomy getTaxonomy() {
        return this.taxonomy;
    }

    @Override
    public Taxon getParent() {
        return this.parent;
    }

    @Override
    public Taxon.Type getType() {
        return this.type;
    }

    @Override
    public int getTaxonomyIndex() {
        return this.index;
    }

    @Override
    public List<Taxon> getContents() {
        if (this.contents == null) {
            this.contents = new ArrayList<Taxon>();
        }
        return this.contents;
    }

    @Override
    public Taxon findByName(String name) {
        if (this.contents == null) {
            return null;
        }
        for (Taxon taxon : this.contents) {
            if (!name.equals(taxon.getName())) continue;
            return taxon;
        }
        return null;
    }

    @Override
    public Taxon findByName(String name, Taxon.Type type) {
        if (type == this.getType()) {
            if (name.equals(this.getName())) {
                return this;
            }
            return null;
        }
        if (this.contents == null) {
            return null;
        }
        for (Taxon taxon : this.contents) {
            Taxon found = taxon.findByName(name, type);
            if (found == null) continue;
            return found;
        }
        return null;
    }

    @Override
    public String getCommonName() {
        return this.commonName;
    }

    public void setCommonName(String commonName) {
        this.commonName = commonName;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getAccountId() {
        return this.accountId;
    }

    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    @Override
    public String getConceptId() {
        return this.conceptId;
    }

    public void setConceptId(String conceptId) {
        this.conceptId = conceptId;
    }

    @Override
    public String getId() {
        if (this.taxonomy == null) {
            throw new IllegalStateException("Taxonomy not set on " + this.getName() + ", " + this.getParent() + ", id not available");
        }
        return this.taxonomy.getId(this);
    }

    @Override
    public SightingTaxon toBaseSightingTaxon() {
        return this.taxonomy.toBaseSightingTaxon(this.getId());
    }

    @Override
    public void setDisabled(boolean disabled) {
        this.disabled = disabled;
    }

    @Override
    public boolean isDisabled() {
        return this.disabled;
    }

    void setIndex(int index) {
        this.index = index;
    }

    public String toString() {
        String className = this.getClass().getName();
        className = className.substring(className.lastIndexOf(46) + 1);
        return className + "[" + this.getName() + "," + this.getType() + ",parent=" + this.getParent() + "]";
    }

    @Override
    public Species.Status getStatus() {
        return Species.Status.LC;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Taxon)) {
            return false;
        }
        Taxon that = (Taxon)o;
        return this.type == that.getType() && Objects.equal(this.name, that.getName()) && Objects.equal(this.parent, that.getParent());
    }

    public int hashCode() {
        return this.type.hashCode() * 31 ^ (this.name == null ? 0 : this.name.hashCode());
    }
}

