/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.model.taxa;

import com.scythebill.birdlist.model.sighting.SightingTaxon;
import com.scythebill.birdlist.model.taxa.Species;
import com.scythebill.birdlist.model.taxa.Taxonomy;
import java.util.List;

public interface Taxon {
    public Type getType();

    public Taxon getParent();

    public List<Taxon> getContents();

    public Taxon findByName(String var1);

    public Taxon findByName(String var1, Type var2);

    public String getCommonName();

    public String getName();

    public Taxonomy getTaxonomy();

    public String getId();

    public int getTaxonomyIndex();

    public String getAccountId();

    public String getConceptId();

    public SightingTaxon toBaseSightingTaxon();

    public void built();

    public boolean equals(Object var1);

    public void setDisabled(boolean var1);

    public boolean isDisabled();

    public Species.Status getStatus();

    public static enum Type {
        subspecies,
        group,
        species,
        genus,
        family,
        order,
        classTaxon("class"),
        phylum;

        private String name;

        private Type() {
            this(null);
        }

        private Type(String name) {
            this.name = name;
        }

        public boolean isAtOrLowerLevelThan(Type type) {
            return this.compareTo(type) <= 0;
        }

        public boolean isLowerLevelThan(Type type) {
            return this.compareTo(type) < 0;
        }

        public String getName() {
            if (this.name != null) {
                return this.name;
            }
            return this.name();
        }
    }
}

